/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.service.ClientService;
import com.bigdata.service.jini.AbstractServer;
import com.bigdata.service.jini.FakeLifeCycle;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.RemoteAdministrable;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.sun.jini.start.LifeCycle;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import org.apache.log4j.MDC;

public class ClientServer
extends AbstractServer {
    public ClientServer(String[] args, LifeCycle lifeCycle) {
        super(args, lifeCycle);
    }

    public static void main(String[] args) {
        new ClientServer(args, new FakeLifeCycle()).run();
        System.exit(0);
    }

    @Override
    protected ClientService newService(Properties properties) {
        AdministrableClientService service = new AdministrableClientService(this, properties);
        this.getClient().setDelegate(new ClientService.ClientServiceFederationDelegate(service));
        return service;
    }

    public static class AdministrableClientService
    extends ClientService
    implements RemoteAdministrable,
    RemoteDestroyAdmin {
        protected final ClientServer server;

        public AdministrableClientService(ClientServer server, Properties properties) {
            super(properties);
            this.server = server;
        }

        public Object getAdmin() throws RemoteException {
            if (log.isInfoEnabled()) {
                log.info((Object)("" + this.getServiceUUID()));
            }
            return this.server.proxy;
        }

        @Override
        protected void setupLoggingContext() {
            super.setupLoggingContext();
            try {
                InetAddress clientAddr = ((ClientHost)ServerContext.getServerContextElement(ClientHost.class)).getClientHost();
                MDC.put((String)"clientname", (Object)clientAddr.getHostName());
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }

        @Override
        protected void clearLoggingContext() {
            MDC.remove((String)"clientname");
            super.clearLoggingContext();
        }

        @Override
        public synchronized void destroy() {
            if (!this.server.isShuttingDown()) {
                this.server.runDestroy();
            } else if (this.isOpen()) {
                super.destroy();
            }
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
            this.server.shutdownNow(false);
        }

        @Override
        public synchronized void shutdownNow() {
            super.shutdownNow();
            this.server.shutdownNow(false);
        }

        @Override
        public JiniFederation<?> getFederation() {
            return this.server.getClient().getFederation();
        }

        @Override
        public Future<? extends Object> submit(Callable<? extends Object> task) {
            return ((JiniFederation)this.getFederation()).getProxy(super.submit(task));
        }

        @Override
        public String getServiceName() {
            String s = this.server.getServiceName();
            if (s == null) {
                s = super.getServiceName();
            }
            return s;
        }
    }

    public static interface Options
    extends ClientService.Options {
    }
}

