/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.BigdataStatics;
import com.bigdata.jini.start.config.ZookeeperClientConfig;
import com.bigdata.jini.util.ConfigMath;
import com.bigdata.service.AbstractScaleOutClient;
import com.bigdata.service.jini.JiniClientConfig;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.NV;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;

public class JiniClient<T>
extends AbstractScaleOutClient<T> {
    private final AtomicReference<JiniFederation<T>> fed = new AtomicReference();
    private final Lock connectLock = new ReentrantLock(false);
    public final JiniClientConfig jiniConfig;
    public final ZookeeperClientConfig zooConfig;
    private final Configuration config;

    @Override
    public boolean isConnected() {
        return this.fed.get() != null;
    }

    @Override
    public JiniFederation<T> getFederation() {
        JiniFederation<T> fed = this.fed.get();
        if (fed == null) {
            throw new IllegalStateException();
        }
        return fed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean immediateShutdown) {
        this.connectLock.lock();
        try {
            JiniFederation<T> fed = this.fed.get();
            if (fed != null) {
                if (immediateShutdown) {
                    fed.shutdownNow();
                } else {
                    fed.shutdown();
                }
            }
            this.fed.set(null);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JiniFederation<T> connect() {
        this.connectLock.lock();
        try {
            JiniFederation<T> fed = this.fed.get();
            if (fed == null) {
                fed = new JiniFederation(this, this.jiniConfig, this.zooConfig);
                this.fed.set(fed);
            }
            JiniFederation<T> jiniFederation = fed;
            return jiniFederation;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public JiniClientConfig getJiniClientConfig() {
        return this.jiniConfig;
    }

    public final ZookeeperClientConfig getZookeeperClientConfig() {
        return this.zooConfig;
    }

    public final Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public Properties getProperties() {
        return super.getProperties();
    }

    public Properties getProperties(String component) throws ConfigurationException {
        return JiniClient.getProperties(component, this.getConfiguration());
    }

    public static Properties getProperties(String className, Configuration config) throws ConfigurationException {
        NV[] a = (NV[])config.getEntry(JiniClient.class.getName(), "properties", NV[].class, (Object)new NV[0]);
        NV[] b = className != null ? (NV[])config.getEntry(className, "properties", NV[].class, (Object)new NV[0]) : null;
        NV[] tmp = ConfigMath.concat(a, b);
        Properties properties = new Properties();
        for (NV nv : tmp) {
            properties.setProperty(nv.getName(), nv.getValue());
        }
        if (log.isInfoEnabled() || BigdataStatics.debug) {
            String msg = "className=" + className + " : properties=" + properties.toString();
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)msg);
            }
        }
        return properties;
    }

    public static JiniClient newInstance(String[] args) {
        JiniClient.setSecurityManager();
        try {
            return new JiniClient(args);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public JiniClient(String[] args) throws ConfigurationException {
        this(JiniClient.class, ConfigurationProvider.getInstance((String[])args));
    }

    public JiniClient(Class cls, Configuration config) throws ConfigurationException {
        super(JiniClient.getProperties(cls.getName(), config));
        this.jiniConfig = new JiniClientConfig(cls.getName(), config);
        this.zooConfig = new ZookeeperClientConfig(config);
        this.config = config;
    }

    protected static void setSecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            System.setSecurityManager(new SecurityManager());
            if (log.isInfoEnabled()) {
                log.info((Object)"Set security manager");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Security manager already in place: " + sm.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getProperties(File propertyFile) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading properties: file=" + propertyFile));
        }
        Properties properties = new Properties();
        try (InputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(propertyFile));
            properties.load(is);
            if (log.isInfoEnabled()) {
                log.info((Object)("Read properties: " + properties));
            }
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static interface Options
    extends AbstractScaleOutClient.Options {
        public static final String CACHE_MISS_TIMEOUT = "cacheMissTimeout";
        public static final String DEFAULT_CACHE_MISS_TIMEOUT = "2000";
    }
}

