/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.httpd.CounterSetHTTPD;
import com.bigdata.service.DefaultServiceFederationDelegate;
import com.bigdata.service.IService;
import com.bigdata.service.LoadBalancerService;
import com.bigdata.service.jini.AbstractServer;
import com.bigdata.service.jini.FakeLifeCycle;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.RemoteAdministrable;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.bigdata.service.jini.util.DumpFederation;
import com.bigdata.util.config.NicUtil;
import com.bigdata.util.httpd.AbstractHTTPD;
import com.bigdata.util.httpd.HTTPGetHandler;
import com.bigdata.util.httpd.NanoHTTPD;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import org.apache.log4j.MDC;

public class LoadBalancerServer
extends AbstractServer {
    public LoadBalancerServer(String[] args, LifeCycle lifeCycle) {
        super(args, lifeCycle);
    }

    public static void main(String[] args) {
        new LoadBalancerServer(args, new FakeLifeCycle()).run();
        System.exit(0);
    }

    @Override
    protected LoadBalancerService newService(Properties properties) {
        AdministrableLoadBalancer service = new AdministrableLoadBalancer(this, properties);
        JiniClient client = this.getClient();
        if (client.isConnected()) {
            throw new IllegalStateException();
        }
        client.setDelegate(new LoadBalancerServiceFederationDelegate(service));
        return service;
    }

    public static class AdministrableLoadBalancer
    extends LoadBalancerService
    implements RemoteAdministrable,
    RemoteDestroyAdmin {
        protected final LoadBalancerServer server;

        public AdministrableLoadBalancer(LoadBalancerServer server, Properties properties) {
            super(properties);
            this.server = server;
        }

        @Override
        public JiniFederation<?> getFederation() {
            return this.server.getClient().getFederation();
        }

        public Object getAdmin() throws RemoteException {
            if (log.isInfoEnabled()) {
                log.info((Object)("" + this.getServiceUUID()));
            }
            return this.server.proxy;
        }

        @Override
        protected void setupLoggingContext() {
            super.setupLoggingContext();
            if (log.isInfoEnabled()) {
                MDC.put((String)"clientname", (Object)this.getClientHostname());
            }
        }

        @Override
        protected void clearLoggingContext() {
            if (log.isInfoEnabled()) {
                MDC.remove((String)"clientname");
            }
            super.clearLoggingContext();
        }

        @Override
        public synchronized void destroy() {
            if (!this.server.isShuttingDown()) {
                this.server.runDestroy();
            } else if (this.isOpen()) {
                super.destroy();
            }
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
            this.server.shutdownNow(false);
        }

        @Override
        public synchronized void shutdownNow() {
            super.shutdownNow();
            this.server.shutdownNow(false);
        }

        @Override
        protected String getClientHostname() {
            InetAddress clientAddr;
            try {
                clientAddr = ((ClientHost)ServerContext.getServerContextElement(ClientHost.class)).getClientHost();
            }
            catch (ServerNotActiveException e) {
                try {
                    clientAddr = InetAddress.getByName(NicUtil.getIpAddress("default.nic", "default", false));
                }
                catch (Throwable t) {
                    return NicUtil.getIpAddressByLocalHost();
                }
            }
            return clientAddr.getCanonicalHostName();
        }

        @Override
        public String getServiceName() {
            String s = this.server.getServiceName();
            if (s == null) {
                s = super.getServiceName();
            }
            return s;
        }
    }

    static class LoadBalancerServiceFederationDelegate
    extends DefaultServiceFederationDelegate<LoadBalancerService> {
        public LoadBalancerServiceFederationDelegate(LoadBalancerService service) {
            super(service);
        }

        @Override
        public void serviceJoin(IService service, UUID serviceUUID) {
            try {
                Class serviceIface = service.getServiceIface();
                String hostname = service.getHostname();
                if (log.isInfoEnabled()) {
                    log.info((Object)("serviceJoin: serviceUUID=" + serviceUUID + ", serviceIface=" + serviceIface + ", hostname=" + hostname));
                }
                ((LoadBalancerService)this.service).join(serviceUUID, serviceIface, hostname);
            }
            catch (IOException ex) {
                log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }

        @Override
        public void serviceLeave(UUID serviceUUID) {
            if (log.isInfoEnabled()) {
                log.info((Object)("serviceUUID=" + serviceUUID));
            }
            ((LoadBalancerService)this.service).leave(serviceUUID);
        }

        @Override
        public AbstractHTTPD newHttpd(int httpdPort, ICounterSetAccess access) throws IOException {
            return new CounterSetHTTPD(httpdPort, access, this.service){
                final IndicesHandler indicesHandler;
                {
                    this.indicesHandler = new IndicesHandler();
                }

                @Override
                public NanoHTTPD.Response doGet(NanoHTTPD.Request req) throws Exception {
                    if (req.uri.equals("/indices")) {
                        return this.indicesHandler.doGet(req);
                    }
                    return super.doGet(req);
                }

                class IndicesHandler
                implements HTTPGetHandler {
                    IndicesHandler() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public NanoHTTPD.Response doGet(NanoHTTPD.Request req) throws Exception {
                        Vector<String> namespaces = req.params.get("namespace");
                        Vector<String> timestamps = req.params.get("timestamp");
                        if (namespaces == null) {
                            namespaces = new Vector();
                            namespaces.add("");
                        }
                        if (timestamps == null) {
                            timestamps = new Vector();
                            timestamps.add("-1");
                        }
                        JiniFederation fed = (JiniFederation)((LoadBalancerService)this.getService()).getFederation();
                        StringWriter w = new StringWriter();
                        DumpFederation.FormatTabTable formatter = new DumpFederation.FormatTabTable(w);
                        formatter.writeHeaders();
                        for (String t : timestamps) {
                            long timestamp;
                            try {
                                timestamp = Long.valueOf(t);
                            }
                            catch (NumberFormatException ex) {
                                return new NanoHTTPD.Response("400 Bad Request", "text/plain", "Not a valid timestamp: " + t);
                            }
                            long tx = fed.getTransactionService().newTx(timestamp);
                            try {
                                DumpFederation dumper = new DumpFederation(fed, tx, formatter);
                                for (String s : namespaces) {
                                    dumper.dumpIndices(s);
                                }
                                formatter.flush();
                            }
                            finally {
                                fed.getTransactionService().abort(tx);
                            }
                        }
                        NanoHTTPD.Response r = new NanoHTTPD.Response("200 OK", "text/plain", w.toString());
                        r.addHeader("Cache-Control", "max-age=60, must-revalidate, public");
                        return r;
                    }
                }
            };
        }
    }

    public static interface Options
    extends LoadBalancerService.Options {
    }
}

