/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.counters.CounterSet;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.service.DefaultServiceFederationDelegate;
import com.bigdata.service.DistributedTransactionService;
import com.bigdata.service.jini.AbstractServer;
import com.bigdata.service.jini.FakeLifeCycle;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.RemoteAdministrable;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.sun.jini.start.LifeCycle;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.util.Properties;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import org.apache.log4j.MDC;

public class TransactionServer
extends AbstractServer {
    public TransactionServer(String[] args, LifeCycle lifeCycle) {
        super(args, lifeCycle);
    }

    public static void main(String[] args) {
        new TransactionServer(args, new FakeLifeCycle()).run();
        System.exit(0);
    }

    @Override
    protected AbstractTransactionService newService(Properties properties) {
        AdministrableTransactionService service = new AdministrableTransactionService(this, properties);
        this.getClient().setDelegate(new TransactionServiceFederationDelegate(service));
        return service;
    }

    public static class AdministrableTransactionService
    extends DistributedTransactionService
    implements RemoteAdministrable,
    RemoteDestroyAdmin {
        protected final TransactionServer server;

        public AdministrableTransactionService(TransactionServer server, Properties properties) {
            super(properties);
            this.server = server;
        }

        @Override
        public JiniFederation<?> getFederation() {
            return this.server.getClient().getFederation();
        }

        public Object getAdmin() throws RemoteException {
            if (log.isInfoEnabled()) {
                log.info((Object)("" + this.getServiceUUID()));
            }
            return this.server.proxy;
        }

        @Override
        protected void setupLoggingContext() {
            super.setupLoggingContext();
            try {
                InetAddress clientAddr = ((ClientHost)ServerContext.getServerContextElement(ClientHost.class)).getClientHost();
                MDC.put((String)"clientname", (Object)clientAddr.getHostName());
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }

        @Override
        protected void clearLoggingContext() {
            MDC.remove((String)"clientname");
            super.clearLoggingContext();
        }

        @Override
        public synchronized void destroy() {
            if (!this.server.isShuttingDown()) {
                this.server.runDestroy();
            } else if (this.isOpen()) {
                super.destroy();
            }
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
            this.server.shutdownNow(false);
        }

        @Override
        public synchronized void shutdownNow() {
            super.shutdownNow();
            this.server.shutdownNow(false);
        }

        @Override
        public String getServiceName() {
            String s = this.server.getServiceName();
            if (s == null) {
                s = super.getServiceName();
            }
            return s;
        }
    }

    public static class TransactionServiceFederationDelegate
    extends DefaultServiceFederationDelegate<DistributedTransactionService> {
        public TransactionServiceFederationDelegate(DistributedTransactionService service) {
            super(service);
        }

        @Override
        public void didStart() {
            super.didStart();
            this.setupCounters();
        }

        protected void setupCounters() {
            if (this.getServiceUUID() == null) {
                throw new IllegalStateException("The ServiceUUID is not available yet");
            }
            if (!((DistributedTransactionService)this.service).isOpen()) {
                log.warn((Object)"Service is not open.");
                return;
            }
            CounterSet serviceRoot = ((DistributedTransactionService)this.service).getFederation().getServiceCounterSet();
            serviceRoot.attach(((DistributedTransactionService)this.service).getCounters());
        }
    }

    public static interface Options
    extends DistributedTransactionService.Options {
    }
}

