/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.lookup;

import com.bigdata.service.IDataService;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.lookup.BigdataCachingServiceClient;
import com.bigdata.service.jini.lookup.DataServiceFilter;
import com.bigdata.service.jini.lookup.MetadataServiceFilter;
import java.rmi.RemoteException;
import java.util.UUID;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.lookup.entry.Name;

public class DataServicesClient
extends BigdataCachingServiceClient<IDataService> {
    public DataServicesClient(JiniFederation fed, long timeout) throws RemoteException {
        super(fed, IDataService.class, new ServiceTemplate(null, new Class[]{IDataService.class}, null), null, timeout);
    }

    public final IDataService getDataService() {
        return (IDataService)this.getService(DataServiceFilter.INSTANCE);
    }

    public final IMetadataService getMetadataService() {
        return (IMetadataService)this.getService(MetadataServiceFilter.INSTANCE);
    }

    public IDataService getDataService(UUID serviceUUID) {
        ServiceItem serviceItem = this.getServiceItem(serviceUUID);
        if (serviceItem == null) {
            log.error((Object)("No such service: uuid=" + serviceUUID));
            return null;
        }
        if (!DataServiceFilter.INSTANCE.check(serviceItem)) {
            throw new RuntimeException("Not a data service: " + serviceItem);
        }
        return (IDataService)serviceItem.service;
    }

    public IMetadataService getMetadataService(UUID serviceUUID) {
        ServiceItem serviceItem = this.getServiceItem(serviceUUID);
        if (serviceItem == null) {
            log.warn((Object)("No such service: uuid=" + serviceUUID));
            return null;
        }
        if (!MetadataServiceFilter.INSTANCE.check(serviceItem)) {
            throw new RuntimeException("Not a metadata service: " + serviceItem);
        }
        return (IMetadataService)serviceItem.service;
    }

    public UUID[] getDataServiceUUIDs(int maxCount) {
        return super.getServiceUUIDs(maxCount, DataServiceFilter.INSTANCE);
    }

    public IDataService getDataServiceByName(final String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (IDataService)this.getService(new DataServiceFilter(){

            @Override
            public boolean check(ServiceItem item) {
                if (super.check(item)) {
                    for (Entry e : item.attributeSets) {
                        if (!(e instanceof Name) || !((Name)e).name.equals(name)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

