/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.lookup;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceItemFilter;
import org.apache.log4j.Logger;

public class ServiceCache
implements ServiceDiscoveryListener {
    protected static final transient Logger log = Logger.getLogger(ServiceCache.class);
    private final ConcurrentHashMap<ServiceID, ServiceItem> serviceIdMap;
    private final ServiceDiscoveryListener listener;

    public ServiceCache(ServiceDiscoveryListener listener) {
        this.listener = listener;
        this.serviceIdMap = new ConcurrentHashMap();
    }

    public void serviceAdded(ServiceDiscoveryEvent e) {
        ServiceItem item = e.getPostEventServiceItem();
        ServiceID serviceID = item.serviceID;
        if (log.isInfoEnabled()) {
            log.info((Object)("" + e + ", class=" + item));
        }
        this.serviceIdMap.put(serviceID, item);
        if (this.listener != null) {
            this.listener.serviceAdded(e);
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent e) {
        ServiceItem item = e.getPostEventServiceItem();
        ServiceID serviceID = item.serviceID;
        if (log.isInfoEnabled()) {
            log.info((Object)("" + e + ", class=" + item));
        }
        this.serviceIdMap.put(serviceID, item);
        if (this.listener != null) {
            this.listener.serviceChanged(e);
        }
    }

    public void serviceRemoved(ServiceDiscoveryEvent e) {
        ServiceItem item = e.getPreEventServiceItem();
        ServiceID serviceID = item.serviceID;
        Object service = item.service;
        if (log.isInfoEnabled()) {
            log.info((Object)("" + e + ", class=" + item));
        }
        this.serviceIdMap.remove(serviceID);
        if (this.listener != null) {
            this.listener.serviceRemoved(e);
        }
    }

    public ServiceItem getServiceItemByID(ServiceID serviceID) {
        if (serviceID == null) {
            throw new IllegalArgumentException();
        }
        return this.serviceIdMap.get(serviceID);
    }

    public int getServiceCount() {
        return this.serviceIdMap.size();
    }

    public ServiceItem[] getServiceItems(int maxCount, ServiceItemFilter filter) {
        if (maxCount < 0) {
            throw new IllegalArgumentException();
        }
        int n = maxCount == 0 ? this.getServiceCount() : maxCount;
        Vector<ServiceItem> v = new Vector<ServiceItem>(n);
        Iterator<Map.Entry<ServiceID, ServiceItem>> itr = this.serviceIdMap.entrySet().iterator();
        while (itr.hasNext() && v.size() < n) {
            Map.Entry<ServiceID, ServiceItem> entry = itr.next();
            ServiceItem item = entry.getValue();
            if (filter != null && !filter.check(item)) continue;
            v.add(item);
        }
        int m = v.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("found " + m + " matching service items"));
        }
        return v.toArray(new ServiceItem[m]);
    }
}

