/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.IRunnableBuffer;
import com.bigdata.service.FederationCallable;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.ndx.IAsynchronousWriteBufferFactory;
import com.bigdata.service.ndx.pipeline.IDuplicateRemover;

public class AggregatorTask<T extends IKeyArrayIndexProcedure, O, R, A>
extends FederationCallable<Void>
implements IAsynchronousWriteBufferFactory {
    private static final long serialVersionUID = -1786088168899639231L;
    private final String name;
    private final long timestamp;
    private final IResultHandler<R, A> resultHandler;
    private final IDuplicateRemover<O> duplicateRemover;
    private final AbstractKeyArrayIndexProcedureConstructor<T> ctor;
    private transient IRunnableBuffer<KVO<O>[]> writeBuffer;
    private transient IRunnableBuffer<KVO<O>[]> writeBufferProxy;

    public AggregatorTask(String name, long timestamp, IResultHandler<R, A> resultHandler, IDuplicateRemover<O> duplicateRemover, AbstractKeyArrayIndexProcedureConstructor<T> ctor) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.timestamp = timestamp;
        this.resultHandler = resultHandler;
        this.duplicateRemover = duplicateRemover;
        this.ctor = ctor;
    }

    public JiniFederation getFederation() {
        return (JiniFederation)super.getFederation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            this.writeBuffer = this.getFederation().getIndex(this.name, this.timestamp).newWriteBuffer(this.resultHandler, this.duplicateRemover, this.ctor);
            this.writeBufferProxy = this.getFederation().getProxy(this.writeBuffer);
            try {
                this.writeBuffer.getFuture().get();
            }
            catch (InterruptedException ex) {
                this.writeBuffer.getFuture().cancel(true);
                throw ex;
            }
        }
        finally {
            this.writeBufferProxy = null;
            this.writeBuffer = null;
        }
        return null;
    }

    @Override
    public <T extends IKeyArrayIndexProcedure, O, R, A> IRunnableBuffer<KVO<O>[]> newWriteBuffer(IResultHandler<R, A> resultHandler, IDuplicateRemover<O> duplicateRemover, AbstractKeyArrayIndexProcedureConstructor<T> ctor) {
        if (this.writeBufferProxy == null) {
            throw new IllegalStateException();
        }
        return (IBlockingBuffer)this.writeBufferProxy;
    }
}

