/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.lookup.BigdataCachingServiceClient;
import com.bigdata.service.jini.master.ServicesTemplate;
import java.rmi.Remote;
import java.util.concurrent.Callable;
import net.jini.core.lookup.ServiceItem;
import org.apache.log4j.Logger;

public class DiscoverServices
implements Callable<ServiceItem[]> {
    protected static final transient Logger log = Logger.getLogger(DiscoverServices.class);
    private final JiniFederation fed;
    private final ServicesTemplate servicesTemplate;
    private final long timeout;

    public DiscoverServices(JiniFederation fed, ServicesTemplate servicesTemplate, long timeout) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (servicesTemplate == null) {
            throw new IllegalArgumentException();
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.servicesTemplate = servicesTemplate;
        this.timeout = timeout;
    }

    @Override
    public ServiceItem[] call() throws Exception {
        int serviceCount;
        BigdataCachingServiceClient<Remote> serviceClient = new BigdataCachingServiceClient<Remote>(this.fed, Remote.class, this.servicesTemplate.template, this.servicesTemplate.filter, 1000L){};
        long begin = System.currentTimeMillis();
        long elapsed = 0L;
        int ntries = 0;
        while ((serviceCount = serviceClient.getServiceCache().getServiceCount()) < this.servicesTemplate.minMatches && (elapsed = System.currentTimeMillis() - begin) < this.timeout) {
            long remaining;
            ++ntries;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Discovered " + serviceCount + " : ntries=" + ntries + ", elapsed=" + elapsed + ", template=" + this.servicesTemplate));
            }
            Thread.sleep((remaining = this.timeout - elapsed) < 100L ? remaining : 100L);
        }
        ServiceItem[] a = serviceClient.getServiceCache().getServiceItems(0, null);
        if (log.isInfoEnabled()) {
            log.info((Object)("Discovered " + serviceCount + " : ntries=" + ntries + ", elapsed=" + elapsed + ", template=" + this.servicesTemplate));
        }
        return a;
    }
}

