/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.btree.BTree;
import com.bigdata.btree.BigdataSet;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.jini.master.ClientLocator;
import com.bigdata.service.jini.master.IAsynchronousClientTask;
import com.bigdata.service.jini.master.MappedTaskMaster;
import com.bigdata.service.jini.master.ResourceBufferStatistics;
import com.bigdata.service.jini.master.ResourceBufferSubtaskStatistics;
import com.bigdata.service.jini.master.ResourceBufferTask;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetSubtask;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

public class ResourceBufferSubtask<H extends ResourceBufferStatistics<L, HS>, O, E extends Serializable, L extends ClientLocator, S extends ResourceBufferSubtask, HS extends ResourceBufferSubtaskStatistics, M extends ResourceBufferTask<H, E, S, L, HS>, T extends IKeyArrayIndexProcedure, A>
extends AbstractPendingSetSubtask<HS, M, E, L> {
    private final Set<E> pendingSet = this.newPendingSet();

    @Override
    protected Set<E> getPendingSet() {
        return this.pendingSet;
    }

    public ResourceBufferSubtask(M master, L locator, IAsynchronousClientTask<?, E> clientTask, BlockingBuffer<E[]> buffer) {
        super(master, locator, clientTask, buffer);
    }

    protected Set<E> newPendingSet() {
        int initialCapacity = ((MappedTaskMaster.JobState)((ResourceBufferTask)this.master).taskMaster.getJobState()).pendingSetSubtaskInitialCapacity;
        if (initialCapacity == Integer.MAX_VALUE) {
            TemporaryStore store = ((ResourceBufferTask)this.master).getFederation().getTempStore();
            IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
            BTree ndx = BTree.create(store, metadata);
            return new BigdataSet(ndx);
        }
        return new LinkedHashSet(initialCapacity);
    }
}

