/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.FederationCallable;
import com.bigdata.service.IRemoteExecutor;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.AbstractAsynchronousClientTask;
import com.bigdata.service.jini.master.ClientLocator;
import com.bigdata.service.jini.master.IAsynchronousClientTask;
import com.bigdata.service.jini.master.IHashFunction;
import com.bigdata.service.jini.master.MappedTaskMaster;
import com.bigdata.service.jini.master.ResourceBufferStatistics;
import com.bigdata.service.jini.master.ResourceBufferSubtask;
import com.bigdata.service.jini.master.ResourceBufferSubtaskStatistics;
import com.bigdata.service.jini.master.TaskMaster;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import net.jini.core.lookup.ServiceItem;

public abstract class ResourceBufferTask<H extends ResourceBufferStatistics<L, HS>, E extends Serializable, S extends ResourceBufferSubtask, L extends ClientLocator, HS extends ResourceBufferSubtaskStatistics>
extends AbstractPendingSetMasterTask<H, E, S, L> {
    protected final MappedTaskMaster taskMaster;
    protected final int sinkQueueCapacity;
    protected final int sinkChunkSize;
    protected final long sinkChunkTimeoutNanos;
    private final Map<E, Collection<L>> pendingMap;

    @Override
    protected Map<E, Collection<L>> getPendingMap() {
        return this.pendingMap;
    }

    public String toString() {
        return this.getClass().getName() + "{jobName=" + ((TaskMaster.JobState)this.taskMaster.getJobState()).jobName + ", open=" + this.buffer.isOpen() + "}";
    }

    public ResourceBufferTask(MappedTaskMaster taskMaster, long sinkIdleTimeoutNanos, long sinkPollTimeoutNanos, int sinkQueueCapacity, int sinkChunkSize, long sinkChunkTimeoutNanos, H stats, BlockingBuffer<E[]> buffer) {
        super(taskMaster.getFederation(), stats, buffer, sinkIdleTimeoutNanos, sinkPollTimeoutNanos);
        if (sinkQueueCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (sinkChunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (sinkChunkTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        this.taskMaster = taskMaster;
        this.sinkQueueCapacity = sinkQueueCapacity;
        this.sinkChunkSize = sinkChunkSize;
        this.sinkChunkTimeoutNanos = sinkChunkTimeoutNanos;
        this.pendingMap = this.newPendingMap();
    }

    @Override
    protected void willShutdown() throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleChunk(E[] chunk, boolean reopen) throws InterruptedException {
        long begin = System.nanoTime();
        try {
            long beforeSplit = System.nanoTime();
            int N = ((TaskMaster.JobState)this.taskMaster.getJobState()).nclients;
            IHashFunction hashFunction = ((MappedTaskMaster.JobState)this.taskMaster.getJobState()).clientHashFunction;
            List[] v = new List[N];
            for (E e : chunk) {
                int h = hashFunction.hashFunction(e);
                int i = Math.abs(h % N);
                if (v[i] == null) {
                    v[i] = new LinkedList();
                }
                v[i].add(e);
            }
            long splitNanos = System.nanoTime() - beforeSplit;
            ResourceBufferStatistics i$ = (ResourceBufferStatistics)this.stats;
            synchronized (i$) {
                ((ResourceBufferStatistics)this.stats).elapsedSplitChunkNanos += splitNanos;
            }
            for (int i = 0; i < v.length; ++i) {
                List t = v[i];
                if (t == null) continue;
                Serializable[] split = (Serializable[])Array.newInstance(chunk[0].getClass(), t.size());
                if (t.toArray(split) != split) {
                    throw new AssertionError();
                }
                this.halted();
                this.addToOutputBuffer(new ClientLocator(i), split, 0, split.length, reopen);
            }
        }
        finally {
            ResourceBufferStatistics resourceBufferStatistics = (ResourceBufferStatistics)this.stats;
            synchronized (resourceBufferStatistics) {
                ((ResourceBufferStatistics)this.stats).handledChunkCount.incrementAndGet();
                ((ResourceBufferStatistics)this.stats).elapsedHandleChunkNanos += System.nanoTime() - begin;
            }
        }
    }

    @Override
    protected S newSubtask(L locator, BlockingBuffer<E[]> out) {
        ServiceItem serviceItem = ((TaskMaster.JobState)this.taskMaster.getJobState()).clientServiceMap.getServiceItem(((ClientLocator)locator).getClientNo());
        assert (serviceItem != null);
        IRemoteExecutor service = (IRemoteExecutor)serviceItem.service;
        assert (service != null);
        try {
            IAsynchronousClientTask clientTask = (IAsynchronousClientTask)service.submit(new ClientTaskFactory((AbstractAsynchronousClientTask)this.taskMaster.newClientTask(this.masterProxy, locator))).get();
            if (clientTask.getFuture().isDone()) {
                clientTask.getFuture().get();
                throw new RuntimeException("Could not start task on remote service: " + locator);
            }
            return (S)new ResourceBufferSubtask(this, locator, clientTask, out);
        }
        catch (Throwable t) {
            this.halt(t);
            throw new RuntimeException(t);
        }
    }

    @Override
    protected BlockingBuffer<E[]> newSubtaskBuffer() {
        return new BlockingBuffer<E[]>(new LinkedBlockingDeque(this.sinkQueueCapacity), this.sinkChunkSize, this.sinkChunkTimeoutNanos, TimeUnit.NANOSECONDS, this.buffer.isOrdered());
    }

    @Override
    protected void submitSubtask(FutureTask<? extends AbstractSubtaskStats> subtask) {
        this.getFederation().getExecutorService().submit(subtask);
    }

    @Override
    protected Map<E, Collection<L>> newPendingMap() {
        int initialCapacity = ((MappedTaskMaster.JobState)this.taskMaster.getJobState()).pendingSetMasterInitialCapacity;
        if (initialCapacity == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        return new LinkedHashMap(initialCapacity);
    }

    public static class M<E extends Serializable>
    extends ResourceBufferTask<ResourceBufferStatistics<ClientLocator, ResourceBufferSubtaskStatistics>, E, ResourceBufferSubtask, ClientLocator, ResourceBufferSubtaskStatistics> {
        public M(MappedTaskMaster taskMaster, long sinkIdleTimeoutNanos, long sinkPollTimeoutNanos, int sinkQueueCapacity, int sinkChunkSize, long sinkChunkTimeoutNanos, ResourceBufferStatistics<ClientLocator, ResourceBufferSubtaskStatistics> stats, BlockingBuffer<E[]> buffer) {
            super(taskMaster, sinkIdleTimeoutNanos, sinkPollTimeoutNanos, sinkQueueCapacity, sinkChunkSize, sinkChunkTimeoutNanos, stats, buffer);
        }
    }

    private static class ClientTaskFactory
    extends FederationCallable<IAsynchronousClientTask> {
        private static final long serialVersionUID = -5106901692329093593L;
        private final AbstractAsynchronousClientTask task;

        public ClientTaskFactory(AbstractAsynchronousClientTask task) {
            if (task == null) {
                throw new IllegalArgumentException();
            }
            this.task = task;
        }

        @Override
        public IAsynchronousClientTask call() throws Exception {
            this.task.setFederation(this.getFederation());
            FutureTask ft = new FutureTask(this.task);
            this.task.setFuture(ft);
            this.getFederation().getExecutorService().submit(ft);
            return ((JiniFederation)this.getFederation()).getProxy(this.task, true);
        }
    }
}

