/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.counters.CounterSet;
import com.bigdata.io.SerializerUtil;
import com.bigdata.service.IRemoteExecutor;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.DiscoverServices;
import com.bigdata.service.jini.master.ServiceMap;
import com.bigdata.service.jini.master.ServicesTemplate;
import com.bigdata.service.jini.util.DumpFederation;
import com.bigdata.util.concurrent.ExecutionExceptions;
import com.bigdata.zookeeper.ZLock;
import com.bigdata.zookeeper.ZLockImpl;
import com.bigdata.zookeeper.ZooHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.lookup.ServiceItem;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public abstract class TaskMaster<S extends JobState, T extends Callable<U>, U>
implements Callable<Void> {
    protected static final Logger log = Logger.getLogger(TaskMaster.class);
    protected final JiniFederation<?> fed;
    private S jobState;

    public JiniFederation<?> getFederation() {
        return this.fed;
    }

    public S getJobState() {
        return this.jobState;
    }

    protected final Future<Void> innerMain() {
        final Future<Void> future = this.fed.getExecutorService().submit(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                future.cancel(true);
                System.err.println("Shutting down: " + new Date());
            }
        });
        return future;
    }

    protected TaskMaster(JiniFederation<?> fed) throws ConfigurationException {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        String component = System.getProperty("bigdata.component", this.getClass().getName());
        Configuration config = ((JiniClient)fed.getClient()).getConfiguration();
        this.jobState = this.newJobState(component, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws InterruptedException, ExecutionException {
        try {
            this.innerMain().get();
        }
        finally {
            System.err.println("Done: " + new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Void call() throws Exception {
        ZLock zlock = this.setupJob();
        try {
            ((JobState)this.jobState).beginMillis = System.currentTimeMillis();
            this.beginJob(this.getJobState());
            try {
                this.runJob();
            }
            catch (CancellationException ex) {
                this.error(this.jobState, ex);
                throw ex;
            }
            catch (InterruptedException ex) {
                this.error(this.jobState, ex);
                throw ex;
            }
            catch (ExecutionException ex) {
                this.error(this.jobState, ex);
                throw ex;
            }
            this.success(this.jobState);
        }
        finally {
            this.tearDownJob(this.jobState, zlock);
        }
        if (((JobState)this.jobState).forceOverflow) {
            this.forceOverflow();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJob() throws Exception, InterruptedException {
        long begin = System.currentTimeMillis();
        boolean failure = true;
        try {
            this.startClients();
            this.awaitAll();
            failure = false;
        }
        catch (Throwable throwable) {
            long elapsed = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                log.info((Object)("Done: " + (failure ? "failure" : "success") + ", elapsed=" + elapsed));
            }
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("Done: " + (failure ? "failure" : "success") + ", elapsed=" + elapsed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startClients() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will run " + ((JobState)this.jobState).nclients));
        }
        ((JobState)this.jobState).futures = new LinkedHashMap(((JobState)this.jobState).nclients);
        int nstarted = 0;
        try {
            for (int clientNum = 0; clientNum < ((JobState)this.jobState).nclients; ++clientNum) {
                ServiceItem serviceItem = ((JobState)this.jobState).clientServiceMap.getServiceItem(clientNum);
                if (serviceItem == null) {
                    throw new RuntimeException("ServiceItem not resolved? client#=" + clientNum);
                }
                if (!(serviceItem.service instanceof IRemoteExecutor)) {
                    throw new RuntimeException("Service does not implement " + IRemoteExecutor.class + ", serviceItem=" + serviceItem);
                }
                IRemoteExecutor service = (IRemoteExecutor)serviceItem.service;
                T clientTask = this.newClientTask(clientNum);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Running client#=" + clientNum + " on " + serviceItem));
                }
                ((JobState)this.jobState).futures.put(clientNum, service.submit((Callable<? extends Object>)clientTask));
                ++nstarted;
            }
        }
        finally {
            if (nstarted < ((JobState)this.jobState).nclients) {
                log.error((Object)("Aborting : could not start client(s): nstarted=" + nstarted + ", nclients=" + ((JobState)this.jobState).nclients));
                this.cancelAll(true);
            }
        }
    }

    protected void awaitAll() throws ExecutionException, InterruptedException {
        try {
            while (!this.allDone()) {
                int nremaining = ((JobState)this.jobState).futures.size();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("#remaining futures=" + nremaining));
                }
                if (nremaining < 10) {
                    Thread.sleep(1000L);
                    continue;
                }
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException t) {
            log.error((Object)("Cancelling job: cause=" + t));
            try {
                this.cancelAll(true);
            }
            catch (Throwable t2) {
                log.error((Object)t2);
            }
            throw new RuntimeException(t);
        }
        catch (ExecutionException t) {
            log.error((Object)("Cancelling job: cause=" + t));
            try {
                this.cancelAll(true);
            }
            catch (Throwable t2) {
                log.error((Object)t2);
            }
            throw new RuntimeException(t);
        }
    }

    protected void success(S jobState) throws Exception {
        ((JobState)jobState).endMillis = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Clients done: elapsed=" + ((JobState)jobState).getElapsedMillis()));
        }
        System.out.println("commit point: " + this.getFederation().getLastCommitTime());
        ZooHelper.destroyZNodes(this.fed.getZookeeperAccessor().getZookeeper(), ((JobState)jobState).getJobZPath(this.fed), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(S jobState, Throwable t) {
        try {
            ((JobState)jobState).endMillis = System.currentTimeMillis();
            log.error((Object)("Abort: elapsed=" + ((JobState)jobState).getElapsedMillis() + " : cause=" + t), t);
        }
        finally {
            try {
                this.cancelAll(true);
            }
            catch (Throwable t2) {
                t2.printStackTrace(System.err);
            }
        }
    }

    protected void tearDownJob(S jobState, ZLock zlock) throws Exception {
        zlock.unlock();
    }

    protected abstract S newJobState(String var1, Configuration var2) throws ConfigurationException;

    protected abstract T newClientTask(int var1);

    protected void beginJob(S jobState) throws Exception {
        if (((JobState)jobState).indexDumpDir != null) {
            this.fed.addScheduledTask(new DumpFederation.ScheduledDumpTask(this.fed, ((JobState)jobState).indexDumpNamespace, 10, ((JobState)jobState).indexDumpDir, "indexDump", TimeUnit.MINUTES), 0L, 1L, TimeUnit.MINUTES);
            this.fed.addScheduledTask(new DumpFederation.ScheduledDumpTask(this.fed, ((JobState)jobState).indexDumpNamespace, 5, ((JobState)jobState).indexDumpDir, "indexDump", TimeUnit.MINUTES), 10L, 10L, TimeUnit.MINUTES);
            this.fed.addScheduledTask(new DumpFederation.ScheduledDumpTask(this.fed, ((JobState)jobState).indexDumpNamespace, Integer.MAX_VALUE, ((JobState)jobState).indexDumpDir, "indexDump", TimeUnit.MINUTES), 1L, 1L, TimeUnit.HOURS);
        }
    }

    protected ZLock setupJob() throws KeeperException, InterruptedException, TimeoutException {
        ZooKeeper zookeeper = this.fed.getZookeeperAccessor().getZookeeper();
        try {
            zookeeper.create(this.fed.getZooConfig().zroot + "/" + "jobs", new byte[0], this.fed.getZooConfig().acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        String jobClassZPath = ((JobState)this.jobState).getJobClassZPath(this.fed);
        try {
            zookeeper.create(jobClassZPath, new byte[0], this.fed.getZooConfig().acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
        ZLockImpl zlock = ZLockImpl.getLock(zookeeper, jobClassZPath + "/" + "locknode_" + ((JobState)this.jobState).jobName, this.fed.getZooConfig().acl);
        zlock.lock();
        try {
            String jobZPath = ((JobState)this.jobState).getJobZPath(this.fed);
            if (((JobState)this.jobState).deleteJob && zookeeper.exists(jobZPath, false) != null) {
                log.warn((Object)("Deleting old job: " + jobZPath));
                ZooHelper.destroyZNodes(this.fed.getZookeeperAccessor().getZookeeper(), jobZPath, 0);
                this.detachPerformanceCounters();
            }
            try {
                zookeeper.create(jobZPath, SerializerUtil.serialize(this.jobState), this.fed.getZooConfig().acl, CreateMode.PERSISTENT);
                if (log.isInfoEnabled()) {
                    log.info((Object)("New job: " + this.jobState));
                }
                try {
                    DiscoveredServices discoveredServices = new DiscoverServicesWithPreconditionsTask().call();
                    ((JobState)this.jobState).clientServiceMap.assignClientsToServices(discoveredServices.clientServiceItems);
                    ((JobState)this.jobState).aggregatorServiceMap.assignClientsToServices(discoveredServices.aggregatorServiceItems);
                    zookeeper.setData(jobZPath, SerializerUtil.serialize(this.jobState), -1);
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Wrote client assignments into zookeeper.");
                    }
                }
                catch (Throwable t) {
                    try {
                        zookeeper.delete(jobZPath, -1);
                    }
                    catch (Throwable t2) {
                        log.error((Object)t2);
                    }
                    throw new RuntimeException(t);
                }
            }
            catch (KeeperException.NodeExistsException ex) {
                this.jobState = (JobState)SerializerUtil.deserialize(zookeeper.getData(jobZPath, false, new Stat()));
                ((JobState)this.jobState).clientServiceMap.resolveServiceUUIDs(this.fed);
                ((JobState)this.jobState).aggregatorServiceMap.resolveServiceUUIDs(this.fed);
                ((JobState)this.jobState).resumedJob = true;
                log.warn((Object)("Pre-existing job: " + jobZPath));
            }
        }
        catch (KeeperException t) {
            zlock.unlock();
            throw t;
        }
        catch (InterruptedException t) {
            zlock.unlock();
            throw t;
        }
        catch (Throwable t) {
            zlock.unlock();
            throw new RuntimeException(t);
        }
        return zlock;
    }

    protected void detachPerformanceCounters() {
        this.getFederation().getServiceCounterSet().makePath("Jobs").detach(((JobState)this.jobState).jobName);
    }

    protected void attachPerformanceCounters(CounterSet counterSet) {
        if (counterSet == null) {
            throw new IllegalArgumentException();
        }
        this.getFederation().getServiceCounterSet().makePath("Jobs").makePath(((JobState)this.getJobState()).jobName).attach(counterSet, true);
    }

    protected boolean allDone() throws InterruptedException, ExecutionException {
        if (((JobState)this.jobState).futures == null) {
            throw new IllegalStateException();
        }
        LinkedList<Integer> finished = new LinkedList<Integer>();
        int nremaining = ((JobState)this.jobState).futures.size();
        for (Map.Entry<Integer, Future<?>> entry : ((JobState)this.jobState).futures.entrySet()) {
            int clientNum = entry.getKey();
            Future<?> future = entry.getValue();
            if (!future.isDone()) continue;
            Object value = future.get();
            System.out.println("Done: " + new Date() + " : clientNum=" + clientNum + " of " + ((JobState)this.jobState).nclients + " with " + --nremaining + " remaining : result=" + value);
            try {
                this.notifyOutcome(clientNum, value);
            }
            catch (Throwable t) {
                log.error((Object)("Ignoring thrown exception: " + t));
            }
            finished.add(clientNum);
        }
        Iterator<Map.Entry<Integer, Future<Object>>> i$ = finished.iterator();
        while (i$.hasNext()) {
            int clientNum = (Integer)((Object)i$.next());
            ((JobState)this.jobState).futures.remove(clientNum);
        }
        return ((JobState)this.jobState).futures.isEmpty();
    }

    protected synchronized void cancelAll(boolean mayInterruptIfRunning) {
        if (((JobState)this.jobState).futures == null) {
            return;
        }
        log.warn((Object)("Cancelling all futures: nfutures=" + ((JobState)this.jobState).futures.size()));
        Iterator<Future<?>> itr = ((JobState)this.jobState).futures.values().iterator();
        while (itr.hasNext()) {
            Future<?> f = itr.next();
            if (!f.isDone()) {
                f.cancel(mayInterruptIfRunning);
            }
            itr.remove();
        }
    }

    protected void forceOverflow() {
        System.out.println("Forcing overflow: now=" + new Date());
        this.fed.forceOverflow(true, true);
        System.out.println("Forced overflow: now=" + new Date());
    }

    protected void notifyOutcome(int clientNum, U value) {
    }

    private class DiscoverServicesWithPreconditionsTask
    implements Callable<DiscoveredServices> {
        @Override
        public DiscoveredServices call() throws Exception {
            ServiceItem[] aggregatorServiceItems;
            if (TaskMaster.this.jobState == null) {
                throw new IllegalArgumentException();
            }
            if (((TaskMaster)TaskMaster.this).jobState.servicesTemplates == null) {
                throw new IllegalArgumentException();
            }
            if (((TaskMaster)TaskMaster.this).jobState.servicesDiscoveryTimeout <= 0L) {
                throw new IllegalArgumentException();
            }
            Future<ServiceItem[]> discoverClientServicesFuture = TaskMaster.this.fed.getExecutorService().submit(new DiscoverServices(TaskMaster.this.fed, ((TaskMaster)TaskMaster.this).jobState.clientsTemplate, ((TaskMaster)TaskMaster.this).jobState.servicesDiscoveryTimeout));
            Future<ServiceItem[]> discoverAggregatorServicesFuture = ((TaskMaster)TaskMaster.this).jobState.aggregatorsTemplate != null ? TaskMaster.this.fed.getExecutorService().submit(new DiscoverServices(TaskMaster.this.fed, ((TaskMaster)TaskMaster.this).jobState.aggregatorsTemplate, ((TaskMaster)TaskMaster.this).jobState.servicesDiscoveryTimeout)) : null;
            LinkedList<DiscoverServices> tasks = new LinkedList<DiscoverServices>();
            for (ServicesTemplate t : ((TaskMaster)TaskMaster.this).jobState.servicesTemplates) {
                tasks.add(new DiscoverServices(TaskMaster.this.fed, t, ((TaskMaster)TaskMaster.this).jobState.servicesDiscoveryTimeout));
            }
            Future[] futures = TaskMaster.this.fed.getExecutorService().invokeAll(tasks).toArray(new Future[tasks.size()]);
            LinkedList<Throwable> causes = new LinkedList<Throwable>();
            ServiceItem[] clientServiceItems = discoverClientServicesFuture.get();
            if (clientServiceItems.length < ((TaskMaster)TaskMaster.this).jobState.clientsTemplate.minMatches) {
                String msg = "Not enough services to run clients: found=" + clientServiceItems.length + ", required=" + ((TaskMaster)TaskMaster.this).jobState.clientsTemplate.minMatches + ", template=" + ((TaskMaster)TaskMaster.this).jobState.clientsTemplate;
                log.error((Object)msg);
                causes.add(new RuntimeException(msg));
            }
            if (((TaskMaster)TaskMaster.this).jobState.aggregatorsTemplate != null) {
                aggregatorServiceItems = discoverAggregatorServicesFuture.get();
                if (aggregatorServiceItems.length < ((TaskMaster)TaskMaster.this).jobState.aggregatorsTemplate.minMatches) {
                    String msg = "Not enough services to run aggregators: found=" + aggregatorServiceItems.length + ", required=" + ((TaskMaster)TaskMaster.this).jobState.aggregatorsTemplate.minMatches + ", template=" + ((TaskMaster)TaskMaster.this).jobState.aggregatorsTemplate;
                    log.error((Object)msg);
                    causes.add(new RuntimeException(msg));
                }
            } else {
                aggregatorServiceItems = new ServiceItem[]{};
            }
            for (int i = 0; i < futures.length; ++i) {
                Future f = futures[i];
                ServicesTemplate servicesTemplate = ((TaskMaster)TaskMaster.this).jobState.servicesTemplates[i];
                try {
                    ServiceItem[] a = (ServiceItem[])f.get();
                    if (a.length >= servicesTemplate.minMatches) continue;
                    String msg = "Not enough services: found=" + a.length + ", required=" + servicesTemplate.minMatches + ", template=" + servicesTemplate;
                    log.error((Object)msg);
                    causes.add(new RuntimeException(msg));
                    continue;
                }
                catch (Throwable ex) {
                    causes.add(ex);
                }
            }
            if (!causes.isEmpty()) {
                throw new ExecutionExceptions(causes);
            }
            return new DiscoveredServices(clientServiceItems, aggregatorServiceItems);
        }
    }

    public static class DiscoveredServices {
        public final ServiceItem[] clientServiceItems;
        public final ServiceItem[] aggregatorServiceItems;

        public DiscoveredServices(ServiceItem[] clientServiceItems, ServiceItem[] aggregatorServiceItems) {
            if (clientServiceItems == null) {
                throw new IllegalArgumentException();
            }
            if (aggregatorServiceItems == null) {
                throw new IllegalArgumentException();
            }
            this.clientServiceItems = clientServiceItems;
            this.aggregatorServiceItems = aggregatorServiceItems;
        }
    }

    public static class JobState
    implements Serializable {
        private static final long serialVersionUID = -340273551639560974L;
        final transient boolean deleteJob;
        boolean resumedJob = false;
        transient long beginMillis = 0L;
        transient long endMillis = 0L;
        protected transient Map<Integer, Future<?>> futures;
        public final String component;
        public final String jobName;
        public final int nclients;
        public final ServicesTemplate clientsTemplate;
        public final int naggregators;
        public final ServicesTemplate aggregatorsTemplate;
        public final ServicesTemplate[] servicesTemplates;
        public final long servicesDiscoveryTimeout;
        public final boolean forceOverflow;
        public final File indexDumpDir;
        public final String indexDumpNamespace;
        public final ServiceMap clientServiceMap;
        public final ServiceMap aggregatorServiceMap;

        public boolean isResumedJob() {
            return this.resumedJob;
        }

        public long getElapsedMillis() {
            if (this.beginMillis == 0L) {
                return 0L;
            }
            if (this.endMillis == 0L) {
                return System.currentTimeMillis() - this.beginMillis;
            }
            return this.endMillis - this.beginMillis;
        }

        protected void toString(StringBuilder sb) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append("{ resumedJob=" + this.isResumedJob());
            sb.append(", component=" + this.component);
            sb.append(", jobName=" + this.jobName);
            sb.append(", nclients=" + this.nclients);
            sb.append(", clientsTemplate=" + this.clientsTemplate);
            sb.append(", servicesTemplates=" + Arrays.toString(this.servicesTemplates));
            sb.append(", awaitServicesTimeout=" + this.servicesDiscoveryTimeout);
            sb.append(", forceOverflow=" + this.forceOverflow);
            this.toString(sb);
            sb.append("}");
            return sb.toString();
        }

        protected JobState(String component, Configuration config) throws ConfigurationException {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (config == null) {
                throw new IllegalArgumentException();
            }
            this.component = component;
            this.jobName = (String)config.getEntry(component, "jobName", String.class);
            this.deleteJob = (Boolean)config.getEntry(component, "deleteJob", Boolean.TYPE, (Object)Boolean.FALSE);
            this.nclients = (Integer)config.getEntry(component, "nclients", Integer.TYPE);
            this.naggregators = (Integer)config.getEntry(component, "naggregators", Integer.TYPE, (Object)0);
            this.clientsTemplate = (ServicesTemplate)config.getEntry(component, "clientsTemplate", ServicesTemplate.class);
            this.aggregatorsTemplate = (ServicesTemplate)config.getEntry(component, "aggregatorsTemplate", ServicesTemplate.class, null);
            this.servicesTemplates = (ServicesTemplate[])config.getEntry(component, "servicesTemplates", ServicesTemplate[].class);
            this.servicesDiscoveryTimeout = (Long)config.getEntry(component, "awaitServicesTimeout", Long.TYPE);
            this.forceOverflow = (Boolean)config.getEntry(component, "forceOverflow", Boolean.TYPE, (Object)Boolean.FALSE);
            this.indexDumpDir = (File)config.getEntry(component, "indexDumpDir", File.class, null);
            this.indexDumpNamespace = (String)config.getEntry(component, "indexDumpNamespace", String.class, null);
            this.clientServiceMap = new ServiceMap(this.nclients);
            this.aggregatorServiceMap = new ServiceMap(this.naggregators);
        }

        public final String getJobClassZPath(JiniFederation fed) {
            return fed.getZooConfig().zroot + "/" + "jobs" + "/" + this.component;
        }

        public final String getJobZPath(JiniFederation fed) {
            return this.getJobClassZPath(fed) + "/" + this.jobName;
        }

        public final String getClientZPath(JiniFederation fed, int clientNum) {
            return this.getJobZPath(fed) + "/" + "client" + clientNum;
        }

        public final String getLockNodeZPath(JiniFederation fed, int clientNum) {
            return this.getClientZPath(fed, clientNum) + "/" + "locknode";
        }
    }

    public static interface ConfigurationOptions {
        public static final String FORCE_OVERFLOW = "forceOverflow";
        public static final String INDEX_DUMP_DIR = "indexDumpDir";
        public static final String INDEX_DUMP_NAMESPACE = "indexDumpNamespace";
        public static final String DELETE_JOB = "deleteJob";
        public static final String NCLIENTS = "nclients";
        public static final String CLIENTS_TEMPLATE = "clientsTemplate";
        public static final String NAGGREGATORS = "naggregators";
        public static final String AGGREGATORS_TEMPLATE = "aggregatorsTemplate";
        public static final String SERVICES_TEMPLATES = "servicesTemplates";
        public static final String SERVICES_DISCOVERY_TIMEOUT = "awaitServicesTimeout";
        public static final String JOB_NAME = "jobName";
    }
}

