/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.jini.start.IServicesManagerService;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ILoadBalancerService;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.config.NicUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.lookup.ServiceItemFilter;
import org.apache.log4j.Logger;

public class BroadcastSighup {
    protected static final Logger log = Logger.getLogger(BroadcastSighup.class);
    protected static final String COMPONENT = BroadcastSighup.class.getName();

    public static void main(String[] args) {
        try {
            BroadcastSighup.main2(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn((Object)"Unexpected exception", (Throwable)e);
        }
    }

    private static void main2(String[] args) throws InterruptedException, ConfigurationException, UnknownHostException, IOException {
        JiniClient client = JiniClient.newInstance(args);
        IBigdataFederation fed = client.connect();
        Configuration config = client.getConfiguration();
        long discoveryDelay = (Long)config.getEntry(COMPONENT, "discoveryDelay", Long.TYPE, (Object)5000L);
        boolean pushConfig = (Boolean)config.getEntry(COMPONENT, "pushConfig", Boolean.TYPE, (Object)true);
        String localOrAll = (String)config.getEntry(COMPONENT, "localOrAll", String.class, (Object)"all");
        String signalTarget = (String)config.getEntry(COMPONENT, "signalTarget", String.class, (Object)"servicesManager");
        boolean restartServices = (Boolean)config.getEntry(COMPONENT, "restartServices", Boolean.TYPE, (Object)true);
        Class iface = null;
        if (signalTarget.equals("servicesManager")) {
            iface = IServicesManagerService.class;
        } else if (signalTarget.equals("loadBalancer")) {
            iface = ILoadBalancerService.class;
        } else {
            log.warn((Object)("Unexpected target for signal: " + signalTarget));
            System.exit(1);
        }
        final String hostname = NicUtil.getIpAddress("default.nic", "default", false);
        ServiceTemplate template = new ServiceTemplate(null, new Class[]{iface}, null);
        ServiceItemFilter thisHostFilter = null;
        if (localOrAll.equals("local")) {
            thisHostFilter = new ServiceItemFilter(){

                public boolean check(ServiceItem item) {
                    for (Entry entry : item.attributeSets) {
                        if (!(entry instanceof Hostname) || !((Hostname)entry).hostname.equals(hostname)) continue;
                        return true;
                    }
                    return false;
                }
            };
        } else if (!localOrAll.equals("all")) {
            log.warn((Object)("Unexpected option for signal: " + localOrAll));
            System.exit(1);
        }
        System.out.println("Waiting " + discoveryDelay + "ms for service discovery.");
        ServiceItem[] items = ((JiniFederation)fed).getServiceDiscoveryManager().lookup(template, Integer.MAX_VALUE, Integer.MAX_VALUE, thisHostFilter, discoveryDelay);
        int n = 0;
        for (ServiceItem item : items) {
            try {
                if (signalTarget.equals("servicesManager")) {
                    ((IServicesManagerService)item.service).sighup(pushConfig, restartServices);
                    ++n;
                    continue;
                }
                if (signalTarget.equals("loadBalancer")) {
                    ((ILoadBalancerService)item.service).sighup();
                    ++n;
                    continue;
                }
                log.warn((Object)("Unexpected target for signal: " + signalTarget));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn((Object)("Unexpected target for signal: " + signalTarget));
            }
        }
        System.out.println("Signal sent to " + n + " of " + items.length + " instances of " + signalTarget + ".");
    }
}

