/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;

public class CreateKB {
    private static final Logger log = Logger.getLogger(CreateKB.class);
    protected static final String COMPONENT = CreateKB.class.getName();
    private final JiniFederation<?> fed;

    private CreateKB(JiniFederation<?> fed) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
    }

    protected boolean createTripleStore() throws ConfigurationException {
        Properties properties = ((JiniClient)this.fed.getClient()).getProperties(COMPONENT);
        String namespace = (String)((JiniClient)this.fed.getClient()).getConfiguration().getEntry(COMPONENT, "namespace", String.class);
        System.out.println("KB namespace=" + namespace);
        AbstractTripleStore tripleStore = (AbstractTripleStore)((DefaultResourceLocator)this.fed.getResourceLocator()).locate(namespace, 0L);
        if (tripleStore != null) {
            System.out.println("exists: " + namespace);
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating KB instance: namespace=" + namespace));
            log.info((Object)("Properties=" + properties.toString()));
        }
        tripleStore = new ScaleOutTripleStore(this.fed, namespace, 0L, properties);
        tripleStore.create();
        System.out.println("Created tripleStore: " + namespace);
        System.out.println("axiomCount=" + tripleStore.getStatementCount());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, ConfigurationException, IOException, ExecutionException {
        IBigdataFederation fed = JiniClient.newInstance(args).connect();
        Runtime.getRuntime().addShutdownHook(new Thread((JiniFederation)fed){
            final /* synthetic */ JiniFederation val$fed;
            {
                this.val$fed = jiniFederation;
            }

            @Override
            public void run() {
                this.val$fed.shutdownNow();
            }
        });
        try {
            new CreateKB((JiniFederation<?>)fed).createTripleStore();
        }
        finally {
            ((JiniFederation)fed).shutdown();
        }
    }

    public static interface ConfigurationOptions {
        public static final String NAMESPACE = "namespace";
        public static final String PROPERTIES = "properties";
    }
}

