/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.btree.BTree;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.resources.ResourceManager;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.DataService;
import com.bigdata.service.DataServiceCallable;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.ListIndicesTask;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.InnerCause;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.ConfigurationException;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;
import org.apache.log4j.Logger;

public class DumpFederation {
    protected static final Logger log = Logger.getLogger(DumpFederation.class);
    public static final String COMPONENT = DumpFederation.class.getName();
    private final JiniFederation<?> fed;
    private final long ts;
    private final FormatRecord formatter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException, TimeoutException, ConfigurationException {
        if (args.length == 0) {
            System.err.println("usage: <client-config-file>");
            System.exit(1);
        }
        JiniClient client = JiniClient.newInstance(args);
        IBigdataFederation fed = client.connect();
        long discoveryDelay = (Long)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "discoveryDelay", Long.TYPE, (Object)5000L);
        String namespace = (String)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "namespace", String.class, (Object)"");
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Waiting up to " + discoveryDelay + "ms for metadata service discovery."));
            }
            ((AbstractScaleOutFederation)fed).awaitServices(1, discoveryDelay);
            long tx = ((JiniFederation)fed).getTransactionService().newTx(-1L);
            try {
                FormatCSVTable formatter = new FormatCSVTable(System.out);
                DumpFederation dumper = new DumpFederation((JiniFederation<?>)fed, tx, formatter);
                formatter.writeHeaders();
                dumper.dumpIndices(namespace);
                formatter.flush();
            }
            finally {
                ((JiniFederation)fed).getTransactionService().abort(tx);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Done");
            }
        }
        finally {
            client.disconnect(false);
        }
    }

    public DumpFederation(JiniFederation<?> fed, long tx, FormatRecord formatter) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (formatter == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.ts = tx;
        this.formatter = formatter;
    }

    public String[] getIndexNames(String namespace) throws InterruptedException, ExecutionException, IOException {
        IMetadataService mds;
        if (namespace.length() != 0) {
            namespace = "metadata-" + namespace;
        }
        if ((mds = this.fed.getMetadataService()) == null) {
            throw new RuntimeException("Could not discover the metadata service");
        }
        return (String[])mds.submit(new ListIndicesTask(this.ts, namespace)).get();
    }

    public void dumpIndices(String namespace) throws InterruptedException, ExecutionException, IOException {
        Object[] names = this.getIndexNames(namespace);
        if (log.isInfoEnabled()) {
            log.info((Object)("Found " + names.length + " indices: " + Arrays.toString(names)));
        }
        for (Object name : names) {
            String scaleOutIndexName = ((String)name).substring("metadata-".length());
            this.dumpIndex(scaleOutIndexName);
        }
    }

    public void dumpIndex(String indexName) throws InterruptedException {
        IMetadataIndex metadataIndex;
        try {
            metadataIndex = this.fed.getMetadataIndex(indexName, this.ts);
        }
        catch (Throwable t) {
            Throwable t2 = InnerCause.getInnerCause(t, ClassNotFoundException.class);
            if (t2 != null) {
                log.error((Object)"CODEBASE/CLASSPATH problem:", t2);
                return;
            }
            throw new RuntimeException(t);
        }
        this.dumpIndexLocators(indexName, metadataIndex);
    }

    protected void dumpIndexLocators(final String indexName, IMetadataIndex metadataIndex) throws InterruptedException {
        ITupleIterator itr = metadataIndex.rangeIterator();
        LinkedList<1> tasks = new LinkedList<1>();
        while (itr.hasNext()) {
            final PartitionLocator locator = (PartitionLocator)itr.next().getObject();
            tasks.add(new Callable<IndexPartitionRecord>(){

                @Override
                public IndexPartitionRecord call() throws Exception {
                    return new IndexPartitionRecord(DumpFederation.this.fed, DumpFederation.this.ts, indexName, locator);
                }
            });
        }
        List futures = this.fed.getExecutorService().invokeAll(tasks);
        LinkedList results = new LinkedList();
        for (Future f : futures) {
            try {
                results.add(f.get());
            }
            catch (ExecutionException ex) {
                log.error((Object)indexName, (Throwable)ex);
            }
        }
        PartitionLocator lastLocator = null;
        for (IndexPartitionRecord rec : results) {
            PartitionLocator locator = rec.locator;
            if (lastLocator == null) {
                if (locator.getLeftSeparatorKey() == null || locator.getLeftSeparatorKey().length != 0) {
                    log.error((Object)("name=" + indexName + " : Left separator should be [] for 1st index partition: " + locator));
                }
            } else {
                int cmp = BytesUtil.compareBytes(lastLocator.getRightSeparatorKey(), locator.getLeftSeparatorKey());
                if (cmp < 0) {
                    log.error((Object)("name=" + indexName + " : Gap between index partitions: lastLocator=" + lastLocator + ", thisLocator=" + locator));
                } else if (cmp > 0) {
                    log.error((Object)("name=" + indexName + " : Index partitions overlap: lastLocator=" + lastLocator + ", thisLocator=" + locator));
                }
            }
            lastLocator = locator;
            this.formatter.writeRecord(rec);
        }
        if (lastLocator != null && lastLocator.getRightSeparatorKey() != null) {
            log.error((Object)("name=" + indexName + " : Right separator of last index partition is not null: " + lastLocator));
        }
    }

    public static class ServiceMetadata {
        private final UUID uuid;
        private final String hostname;
        private final String name;
        private final int code;
        private static Map<UUID, Integer> codes = new HashMap<UUID, Integer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ServiceMetadata getServiceMetadata(JiniFederation<?> fed, UUID uuid) {
            if (fed == null) {
                throw new IllegalArgumentException();
            }
            if (uuid == null) {
                throw new IllegalArgumentException();
            }
            ServiceItem serviceItem = fed.getDataServicesClient().getServiceItem(uuid);
            if (serviceItem == null) {
                throw new RuntimeException("No such (Meta)DataService? uuid=" + uuid);
            }
            String hostname = null;
            String name = null;
            for (Entry e : serviceItem.attributeSets) {
                if (e instanceof Hostname && hostname == null) {
                    hostname = ((Hostname)e).hostname;
                    continue;
                }
                if (!(e instanceof Name) || name != null) continue;
                name = ((Name)e).name;
            }
            if (hostname == null) {
                log.warn((Object)("No hostname? : " + serviceItem));
                hostname = "Unknown(" + uuid + ")";
            }
            if (name == null) {
                log.warn((Object)("No name? : " + serviceItem));
                name = "Unknown(" + uuid + ")";
            }
            Integer code = null;
            Map<UUID, Integer> map = codes;
            synchronized (map) {
                code = codes.get(uuid);
                if (code == null) {
                    code = codes.size();
                    codes.put(uuid, code);
                }
            }
            return new ServiceMetadata(uuid, hostname, name, code);
        }

        public ServiceMetadata(UUID uuid, String hostname, String name, int code) {
            if (uuid == null) {
                throw new IllegalArgumentException();
            }
            if (hostname == null) {
                throw new IllegalArgumentException();
            }
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.uuid = uuid;
            this.hostname = hostname;
            this.name = name;
            this.code = code;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class FetchIndexPartitionByteCountRecordTask
    extends DataServiceCallable<IndexPartitionDetailRecord> {
        private static final long serialVersionUID = 1656089893655069298L;
        private final long timestamp;
        private final String name;

        public FetchIndexPartitionByteCountRecordTask(long timestamp, String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.timestamp = timestamp;
            this.name = name;
        }

        @Override
        public IndexPartitionDetailRecord call() throws Exception {
            ResourceManager resourceManager = this.getDataService().getResourceManager();
            return new IndexPartitionDetailRecord(resourceManager, this.timestamp, this.name);
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    public static class IndexPartitionDetailRecord
    implements Serializable {
        private static final long serialVersionUID = 6275468354120307662L;
        public final String indexPartitionName;
        public final IndexMetadata indexMetadata;
        public final LocalPartitionMetadata pmd;
        public SourceDetailRecord[] sources;
        public final int sourceCount;
        public final int journalSourceCount;
        public final int segmentSourceCount;
        public final long dataDirFreeSpace;
        public final long bytesUnderManagement;
        public final long journalBytesUnderManagement;
        public final long segmentBytesUnderManagement;
        public final long managedJournalCount;
        public final long managedSegmentCount;
        public final long asynchronousOverflowCount;

        public IndexPartitionDetailRecord(ResourceManager resourceManager, long timestamp, String name) {
            if (resourceManager == null) {
                throw new IllegalArgumentException();
            }
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.indexPartitionName = name;
            AbstractJournal store = resourceManager.getJournal(timestamp);
            if (store == null) {
                throw new RuntimeException("No journal? : timestamp=" + timestamp);
            }
            BTree btree = (BTree)resourceManager.getIndexOnStore(name, timestamp, store);
            if (btree == null) {
                throw new RuntimeException("No index partition on journal? : timestamp=" + timestamp + ", name=" + name);
            }
            this.indexMetadata = btree.getIndexMetadata();
            this.pmd = this.indexMetadata.getPartitionMetadata();
            if (this.pmd == null) {
                this.sources = new SourceDetailRecord[]{new SourceDetailRecord(btree.getEntryCount(), btree.getNodeCount(), btree.getLeafCount(), 0L, 0L, 0L)};
                this.sourceCount = 1;
                this.journalSourceCount = 1;
                this.segmentSourceCount = 0;
            } else {
                int sourceCount = 0;
                int journalSourceCount = 0;
                int segmentSourceCount = 0;
                IResourceMetadata[] resources = this.pmd.getResources();
                this.sources = new SourceDetailRecord[resources.length];
                for (int i = 0; i < resources.length; ++i) {
                    IResourceMetadata x = resources[i];
                    ++sourceCount;
                    IRawStore store2 = resourceManager.openStore(x.getUUID());
                    if (store2 == null) {
                        throw new RuntimeException("Store not found? : " + x);
                    }
                    if (x.isJournal()) {
                        ++journalSourceCount;
                        BTree tmp = (BTree)resourceManager.getIndexOnStore(name, timestamp, store2);
                        if (tmp == null) {
                            throw new RuntimeException("No index partition on journal? : timestamp=" + timestamp + ", name=" + name);
                        }
                        this.sources[i] = new SourceDetailRecord(tmp.getEntryCount(), tmp.getNodeCount(), tmp.getLeafCount(), 0L, 0L, 0L);
                        continue;
                    }
                    ++segmentSourceCount;
                    IndexSegmentStore segStore = (IndexSegmentStore)store2;
                    long entryCount = segStore.getCheckpoint().nentries;
                    long nodeCount = segStore.getCheckpoint().nnodes;
                    long leafCount = segStore.getCheckpoint().nleaves;
                    this.sources[i] = new SourceDetailRecord(entryCount, nodeCount, leafCount, segStore.size(), segStore.getCheckpoint().extentNodes, segStore.getCheckpoint().extentLeaves);
                }
                this.sourceCount = sourceCount;
                this.journalSourceCount = journalSourceCount;
                this.segmentSourceCount = segmentSourceCount;
            }
            this.dataDirFreeSpace = resourceManager.getDataDirFreeSpace();
            this.bytesUnderManagement = resourceManager.getBytesUnderManagement();
            this.journalBytesUnderManagement = resourceManager.getJournalBytesUnderManagement();
            this.segmentBytesUnderManagement = resourceManager.getSegmentBytesUnderManagement();
            this.managedJournalCount = resourceManager.getManagedJournalCount();
            this.managedSegmentCount = resourceManager.getManagedSegmentCount();
            this.asynchronousOverflowCount = resourceManager.getAsynchronousOverflowCount();
        }
    }

    public static class SourceDetailRecord
    implements Serializable {
        private static final long serialVersionUID = -2064727234836478585L;
        public final long entryCount;
        public final long nodeCount;
        public final long leafCount;
        public final long segmentByteCount;
        public final long segmentNodeByteCount;
        public final long segmentLeafByteCount;

        public SourceDetailRecord(long entryCount, long nodeCount, long leafCount, long segmentByteCount, long segmentNodeByteCount, long segmentLeafByteCount) {
            this.entryCount = entryCount;
            this.nodeCount = nodeCount;
            this.leafCount = leafCount;
            this.segmentByteCount = segmentByteCount;
            this.segmentNodeByteCount = segmentNodeByteCount;
            this.segmentLeafByteCount = segmentLeafByteCount;
        }

        public SourceDetailRecord(SourceDetailRecord[] a) {
            if (a == null) {
                throw new IllegalArgumentException();
            }
            long entryCount = 0L;
            long nodeCount = 0L;
            long leafCount = 0L;
            long segmentByteCount = 0L;
            long nodeByteCount = 0L;
            long leafByteCount = 0L;
            for (SourceDetailRecord t : a) {
                entryCount += t.entryCount;
                nodeCount += t.nodeCount;
                leafCount += t.leafCount;
                segmentByteCount += t.segmentByteCount;
                nodeByteCount += t.segmentNodeByteCount;
                leafByteCount += t.segmentLeafByteCount;
            }
            this.entryCount = entryCount;
            this.nodeCount = nodeCount;
            this.leafCount = leafCount;
            this.segmentByteCount = segmentByteCount;
            this.segmentNodeByteCount = nodeByteCount;
            this.segmentLeafByteCount = leafByteCount;
        }
    }

    public static class IndexPartitionRecord {
        public final long ts;
        public final String indexName;
        public final PartitionLocator locator;
        public final ServiceMetadata smd;
        public final IndexPartitionDetailRecord detailRec;

        public IndexPartitionRecord(JiniFederation<?> fed, long ts, String indexName, PartitionLocator locator) throws InterruptedException {
            if (fed == null) {
                throw new IllegalArgumentException();
            }
            if (indexName == null) {
                throw new IllegalArgumentException();
            }
            if (locator == null) {
                throw new IllegalArgumentException();
            }
            this.ts = ts;
            this.indexName = indexName;
            this.locator = locator;
            this.smd = ServiceMetadata.getServiceMetadata(fed, locator.getDataServiceUUID());
            IDataService dataService = fed.getDataService(locator.getDataServiceUUID());
            if (dataService == null) {
                throw new RuntimeException("Could not discover dataService: " + dataService);
            }
            IndexPartitionDetailRecord detailRec = null;
            try {
                detailRec = (IndexPartitionDetailRecord)dataService.submit(new FetchIndexPartitionByteCountRecordTask(ts, DataService.getIndexPartitionName(indexName, locator.getPartitionId()))).get();
            }
            catch (InterruptedException t) {
                throw t;
            }
            catch (Exception t) {
                log.warn((Object)("name=" + indexName), (Throwable)t);
            }
            this.detailRec = detailRec;
        }
    }

    public static class FormatCSVTable
    implements FormatRecord {
        private final PrintWriter out;

        public FormatCSVTable(PrintWriter w) {
            if (w == null) {
                throw new IllegalArgumentException();
            }
            this.out = w;
        }

        public FormatCSVTable(Writer w) {
            this(new PrintWriter(w));
        }

        public FormatCSVTable(PrintStream w) {
            this(new PrintWriter(w));
        }

        @Override
        public void writeHeaders() {
            String s = "Timestamp,IndexName,IndexPartitionName,PartitionId,ServiceUUID,ServiceName,Hostname,ServiceCode,SourceCount,SourceJournalCount,SourceSegmentCount,SumEntryCounts,SumNodeCounts,SumLeafCounts,SumSegmentBytes,SumSegmentNodeBytes,SumSegmentLeafBytes,DataDirFreeSpace,BytesUnderManagement,JournalBytesUnderManagement,IndexSegmentBytesUnderManagement,ManagedJournalCount,ManagedSegmentCount,AsynchronousOverflowCount,LeftSeparator,RightSeparator,View,Cause,IndexMetadata";
            this.out.println("Timestamp,IndexName,IndexPartitionName,PartitionId,ServiceUUID,ServiceName,Hostname,ServiceCode,SourceCount,SourceJournalCount,SourceSegmentCount,SumEntryCounts,SumNodeCounts,SumLeafCounts,SumSegmentBytes,SumSegmentNodeBytes,SumSegmentLeafBytes,DataDirFreeSpace,BytesUnderManagement,JournalBytesUnderManagement,IndexSegmentBytesUnderManagement,ManagedJournalCount,ManagedSegmentCount,AsynchronousOverflowCount,LeftSeparator,RightSeparator,View,Cause,IndexMetadata");
        }

        @Override
        public void writeRecord(IndexPartitionRecord rec) {
            StringBuilder sb = new StringBuilder();
            sb.append(rec.ts);
            sb.append("," + rec.indexName);
            sb.append("," + DataService.getIndexPartitionName(rec.indexName, rec.locator.getPartitionId()));
            sb.append("," + rec.locator.getPartitionId());
            sb.append("," + rec.locator.getDataServiceUUID());
            sb.append("," + rec.smd.getName());
            sb.append("," + rec.smd.getHostname());
            sb.append(",DS" + rec.smd.getCode());
            if (rec.detailRec != null) {
                SourceDetailRecord sourceDetailRec = new SourceDetailRecord(rec.detailRec.sources);
                sb.append("," + rec.detailRec.sourceCount);
                sb.append("," + rec.detailRec.journalSourceCount);
                sb.append("," + rec.detailRec.segmentSourceCount);
                sb.append("," + sourceDetailRec.entryCount);
                sb.append("," + sourceDetailRec.nodeCount);
                sb.append("," + sourceDetailRec.leafCount);
                sb.append("," + sourceDetailRec.segmentByteCount);
                sb.append("," + sourceDetailRec.segmentNodeByteCount);
                sb.append("," + sourceDetailRec.segmentLeafByteCount);
                sb.append("," + rec.detailRec.dataDirFreeSpace);
                sb.append("," + rec.detailRec.bytesUnderManagement);
                sb.append("," + rec.detailRec.journalBytesUnderManagement);
                sb.append("," + rec.detailRec.segmentBytesUnderManagement);
                sb.append("," + rec.detailRec.managedJournalCount);
                sb.append("," + rec.detailRec.managedSegmentCount);
                sb.append("," + rec.detailRec.asynchronousOverflowCount);
            } else {
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
            }
            sb.append("," + BytesUtil.toString(rec.locator.getLeftSeparatorKey()).replace(',', ' '));
            sb.append("," + BytesUtil.toString(rec.locator.getRightSeparatorKey()).replace(',', ' '));
            if (rec.detailRec != null && rec.detailRec.pmd != null) {
                sb.append(",\"" + Arrays.toString(rec.detailRec.pmd.getResources()).replace(',', ';') + "\"");
                sb.append(",\"" + rec.detailRec.pmd.getIndexPartitionCause().toString().replace(',', ';') + "\"");
                sb.append(",\"" + rec.detailRec.indexMetadata.toString().replace(',', ';') + "\"");
            } else {
                sb.append(",N/A");
                sb.append(",N/A");
                sb.append(",N/A");
            }
            this.out.println(sb.toString());
        }

        @Override
        public void flush() {
            this.out.flush();
        }
    }

    public static class FormatTabTable
    implements FormatRecord {
        private final PrintWriter out;

        public FormatTabTable(PrintWriter w) {
            if (w == null) {
                throw new IllegalArgumentException();
            }
            this.out = w;
        }

        public FormatTabTable(Writer w) {
            this(new PrintWriter(w));
        }

        public FormatTabTable(PrintStream w) {
            this(new PrintWriter(w));
        }

        @Override
        public void writeHeaders() {
            String s = "Timestamp\tIndexName\tIndexPartitionName\tPartitionId\tServiceUUID\tServiceName\tHostname\tServiceCode\tSourceCount\tSourceJournalCount\tSourceSegmentCount\tSumEntryCounts\tSumNodeCounts\tSumLeafCounts\tSumSegmentBytes\tSumSegmentNodeBytes\tSumSegmentLeafBytes\tDataDirFreeSpace\tBytesUnderManagement\tJournalBytesUnderManagement\tIndexSegmentBytesUnderManagement\tManagedJournalCount\tManagedSegmentCount\tAsynchronousOverflowCount\tLeftSeparator\tRightSeparator\tView\tCause\tIndexMetadata";
            this.out.println("Timestamp\tIndexName\tIndexPartitionName\tPartitionId\tServiceUUID\tServiceName\tHostname\tServiceCode\tSourceCount\tSourceJournalCount\tSourceSegmentCount\tSumEntryCounts\tSumNodeCounts\tSumLeafCounts\tSumSegmentBytes\tSumSegmentNodeBytes\tSumSegmentLeafBytes\tDataDirFreeSpace\tBytesUnderManagement\tJournalBytesUnderManagement\tIndexSegmentBytesUnderManagement\tManagedJournalCount\tManagedSegmentCount\tAsynchronousOverflowCount\tLeftSeparator\tRightSeparator\tView\tCause\tIndexMetadata");
        }

        @Override
        public void writeRecord(IndexPartitionRecord rec) {
            StringBuilder sb = new StringBuilder();
            sb.append(rec.ts);
            sb.append("\t" + rec.indexName);
            sb.append("\t" + DataService.getIndexPartitionName(rec.indexName, rec.locator.getPartitionId()));
            sb.append("\t" + rec.locator.getPartitionId());
            sb.append("\t" + rec.locator.getDataServiceUUID());
            sb.append("\t" + rec.smd.getName());
            sb.append("\t" + rec.smd.getHostname());
            sb.append("\tDS" + rec.smd.getCode());
            if (rec.detailRec != null) {
                SourceDetailRecord sourceDetailRec = new SourceDetailRecord(rec.detailRec.sources);
                sb.append("\t" + rec.detailRec.sourceCount);
                sb.append("\t" + rec.detailRec.journalSourceCount);
                sb.append("\t" + rec.detailRec.segmentSourceCount);
                sb.append("\t" + sourceDetailRec.entryCount);
                sb.append("\t" + sourceDetailRec.nodeCount);
                sb.append("\t" + sourceDetailRec.leafCount);
                sb.append("\t" + sourceDetailRec.segmentByteCount);
                sb.append("\t" + sourceDetailRec.segmentNodeByteCount);
                sb.append("\t" + sourceDetailRec.segmentLeafByteCount);
                sb.append("\t" + rec.detailRec.dataDirFreeSpace);
                sb.append("\t" + rec.detailRec.bytesUnderManagement);
                sb.append("\t" + rec.detailRec.journalBytesUnderManagement);
                sb.append("\t" + rec.detailRec.segmentBytesUnderManagement);
                sb.append("\t" + rec.detailRec.managedJournalCount);
                sb.append("\t" + rec.detailRec.managedSegmentCount);
                sb.append("\t" + rec.detailRec.asynchronousOverflowCount);
            } else {
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
            }
            sb.append("\t" + BytesUtil.toString(rec.locator.getLeftSeparatorKey()));
            sb.append("\t" + BytesUtil.toString(rec.locator.getRightSeparatorKey()));
            if (rec.detailRec != null && rec.detailRec.pmd != null) {
                sb.append("\t\"" + Arrays.toString(rec.detailRec.pmd.getResources()) + "\"");
                sb.append("\t\"" + rec.detailRec.pmd.getIndexPartitionCause() + "\"");
                sb.append("\t\"" + rec.detailRec.indexMetadata + "\"");
            } else {
                sb.append("\tN/A");
                sb.append("\tN/A");
                sb.append("\tN/A");
            }
            this.out.println(sb.toString());
        }

        @Override
        public void flush() {
            this.out.flush();
        }
    }

    public static interface FormatRecord {
        public void writeHeaders();

        public void writeRecord(IndexPartitionRecord var1);

        public void flush();
    }

    public static class ScheduledDumpTask
    implements Runnable {
        final JiniFederation<?> fed;
        final String namespace;
        final File path;
        final String basename;
        final int nruns;
        final TimeUnit unit;
        final long startTime = System.nanoTime();
        private int run = 0;

        public ScheduledDumpTask(JiniFederation<?> fed, String namespace, int nruns, File path, String basename, TimeUnit unit) {
            if (fed == null) {
                throw new IllegalArgumentException();
            }
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            if (path == null) {
                throw new IllegalArgumentException();
            }
            if (basename == null) {
                throw new IllegalArgumentException();
            }
            if (nruns < 0) {
                throw new IllegalArgumentException();
            }
            if (unit == null) {
                throw new IllegalArgumentException();
            }
            this.fed = fed;
            this.namespace = namespace;
            this.path = path;
            this.basename = basename;
            this.nruns = nruns;
            this.unit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.nruns != 0 && this.run >= this.nruns) {
                throw new RuntimeException("Finished");
            }
            long elapsed = System.nanoTime() - this.startTime;
            long elapsedUnits = this.unit.convert(elapsed, TimeUnit.NANOSECONDS);
            File file = new File(this.path, this.basename + "-" + (Object)((Object)this.unit) + "-t" + elapsedUnits + ".txt");
            if (!this.path.exists()) {
                this.path.mkdirs();
            }
            FileWriter w = null;
            try {
                w = new FileWriter(file);
                FormatTabTable formatter = new FormatTabTable(w);
                formatter.writeHeaders();
                long tx = this.fed.getTransactionService().newTx(-1L);
                try {
                    DumpFederation dumper = new DumpFederation(this.fed, tx, formatter);
                    dumper.dumpIndices(this.namespace);
                    formatter.flush();
                }
                finally {
                    this.fed.getTransactionService().abort(tx);
                }
            }
            catch (InterruptedException t) {
                return;
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
            finally {
                ++this.run;
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        log.error((Object)file, (Throwable)e);
                    }
                }
            }
        }
    }

    public static interface ConfigurationOptions {
        public static final String NAMESPACE = "namespace";
        public static final String DISCOVERY_DELAY = "discoveryDelay";
    }
}

