/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.util.config.ConfigurationUtil;
import com.bigdata.util.config.LogUtil;
import com.bigdata.util.config.NicUtil;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import java.rmi.RMISecurityManager;
import java.util.HashSet;
import net.jini.admin.Administrable;
import net.jini.config.AbstractConfiguration;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LookupStarter
extends Thread {
    private static final Logger logger = LogUtil.getLog4jLogger(LookupStarter.class);
    private String pSep = System.getProperty("path.separator");
    private String fSep = System.getProperty("file.separator");
    private String userDir = System.getProperty("user.dir");
    private String appHome = System.getProperty("app.home");
    private String jiniLib = System.getProperty("jini.lib");
    private String jiniLibDl = System.getProperty("jini.lib.dl");
    private String localPolicy = System.getProperty("java.security.policy");
    private static String thisHost = null;
    private static String defaultGroup = null;
    private static String defaultCodebasePort;
    private static String group;
    private static String codebasePortStr;
    private static int codebasePort;
    private static String[] groups;
    private static String overrideGroups;
    private static LookupLocator[] locators;
    private static DiscoveryManagement ldm;
    private static String jskCodebase;
    private static String lookupServerCodebase;
    private static String lookupCodebase;
    private String lookupClasspath = this.jiniLib + this.fSep + "reggie.jar";
    private String lookupImplName = "com.sun.jini.reggie.TransientRegistrarImpl";
    private String lookupConfig = this.appHome + this.fSep + "bigdata-jini" + this.fSep + "src" + this.fSep + "java" + this.fSep + "com" + this.fSep + "bigdata" + this.fSep + "service" + this.fSep + "jini" + this.fSep + "util" + this.fSep + "config" + this.fSep + "lookup.config";
    private static HashSet<ServiceRegistrar> proxySet;
    private static HashSet<NonActivatableServiceDescriptor.Created> implRefSet;

    public static void main(String[] args) {
        boolean stop = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                System.out.println("usage: java -jar lookupstarter.jar [-help|-stop]");
                return;
            }
            if (!arg.equals("-stop")) continue;
            stop = true;
        }
        try {
            if (stop) {
                LookupStarter.stopLookupService();
            } else {
                new LookupStarter().start();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        new LookupStartThread().start();
    }

    private static void setupDiscovery() throws Exception {
        StringBuffer strBuf = null;
        strBuf = groups[0].compareTo("") == 0 ? new StringBuffer("{\"\"") : new StringBuffer("{\"" + groups[0] + "\"");
        for (int i = 1; i < groups.length; ++i) {
            if (groups[i].compareTo("") == 0) {
                strBuf.append(", \"\"");
                continue;
            }
            strBuf.append(", ").append("\"" + groups[i] + "\"");
        }
        strBuf.append("}");
        overrideGroups = strBuf.toString();
        ldm = new LookupDiscoveryManager(groups, locators, null);
        logger.log((Priority)Level.INFO, (Object)("groups=" + LookupStarter.writeGroupArrayToString(groups) + ", locators=" + LookupStarter.writeArrayElementsToString(locators)));
        jskCodebase = ConfigurationUtil.computeCodebase(thisHost, "jsk-dl.jar", codebasePort);
        lookupServerCodebase = ConfigurationUtil.computeCodebase(thisHost, "reggie-dl.jar", codebasePort);
        lookupCodebase = lookupServerCodebase + " " + jskCodebase;
        ldm.addDiscoveryListener((DiscoveryListener)new LookupDiscoveryListener());
    }

    private void startLookupService() throws Exception {
        String joinGroupsOverride = "com.sun.jini.reggie.initialLookupGroups=new String[] " + overrideGroups;
        String memberGroupsOverride = "com.sun.jini.reggie.initialMemberGroups=new String[] " + overrideGroups;
        logger.log((Priority)Level.INFO, (Object)("Start lookup service [" + memberGroupsOverride + "]"));
        String[] lookupArgsArray = new String[]{this.lookupConfig, joinGroupsOverride, memberGroupsOverride};
        NonActivatableServiceDescriptor lookupDescriptor = new NonActivatableServiceDescriptor(lookupCodebase, this.localPolicy, this.lookupClasspath, this.lookupImplName, lookupArgsArray);
        ServiceStarterConfig starterConfig = new ServiceStarterConfig((ProxyPreparer)new BasicProxyPreparer());
        implRefSet.add((NonActivatableServiceDescriptor.Created)lookupDescriptor.create((Configuration)starterConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopLookupService() throws Exception {
        HashSet proxySetClone;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        LookupStarter.setupDiscovery();
        if (!LookupStarter.waitForLookupServiceDiscovery()) {
            System.out.println("FAILED to discover lookup service");
            System.exit(0);
        }
        HashSet<ServiceRegistrar> hashSet = proxySet;
        synchronized (hashSet) {
            proxySetClone = (HashSet)proxySet.clone();
        }
        for (ServiceRegistrar srvcReg : proxySetClone) {
            if (srvcReg == null) continue;
            if (srvcReg instanceof Administrable) {
                try {
                    Object srvcRegAdmin = ((Administrable)srvcReg).getAdmin();
                    if (srvcRegAdmin instanceof DestroyAdmin) {
                        try {
                            ((DestroyAdmin)srvcRegAdmin).destroy();
                            logger.log((Priority)Level.INFO, (Object)"destroyed lookup service");
                        }
                        catch (Throwable t) {
                            logger.log((Priority)Level.WARN, (Object)"exception on lookup service destroy", t);
                        }
                        continue;
                    }
                    logger.log((Priority)Level.WARN, (Object)"on shutdown - lookup service admin not instance of DestroyAdmin");
                }
                catch (Throwable t) {
                    logger.log((Priority)Level.WARN, (Object)("getAdmin exception on lookup service shutdown [" + t + "]"), t);
                }
                continue;
            }
            logger.log((Priority)Level.WARN, (Object)"on shutdown - lookup service not instance of Administrable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForLookupServiceDiscovery() throws Exception {
        HashSet<ServiceRegistrar> hashSet;
        ServiceRegistrar[] regs = ldm.getRegistrars();
        if (regs.length > 0) {
            for (int i = 0; i < regs.length; ++i) {
                HashSet<ServiceRegistrar> hashSet2 = proxySet;
                synchronized (hashSet2) {
                    proxySet.add(regs[i]);
                    continue;
                }
            }
        }
        int nSecs = 30;
        int nExpected = 1;
        logger.log((Priority)Level.INFO, (Object)("waiting " + nSecs + " seconds for lookup " + "service discovery"));
        for (int i = 0; i < nSecs; ++i) {
            LookupStarter.delayMS(1000L);
            hashSet = proxySet;
            synchronized (hashSet) {
                if (proxySet.size() < nExpected) {
                    continue;
                }
            }
            return true;
        }
        int nLus = 0;
        hashSet = proxySet;
        synchronized (hashSet) {
            nLus = proxySet.size();
        }
        boolean retVal = true;
        if (nLus >= nExpected) {
            logger.log((Priority)Level.INFO, (Object)("discovered = " + nLus + " lookup service(s)"));
        } else if (nLus > 0) {
            logger.log((Priority)Level.WARN, (Object)("discovered less than expected number of lookup services [discovered=" + nLus + ", " + "expected=" + nExpected + "]"));
            retVal = false;
        } else {
            logger.log((Priority)Level.WARN, (Object)"NO lookup services discovered");
            retVal = false;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForLookupServiceShutdown() {
        int nSecs = 30;
        for (int i = 0; i < nSecs; ++i) {
            LookupStarter.delayMS(1000L);
            HashSet<ServiceRegistrar> hashSet = proxySet;
            synchronized (hashSet) {
                if (proxySet.size() > 0) {
                    continue;
                }
            }
            return true;
        }
        return false;
    }

    private static void delayMS(long nMS) {
        try {
            Thread.sleep(nMS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String writeGroupArrayToString(String[] groups) {
        if (groups == null) {
            return new String("[ALL_GROUPS]");
        }
        if (groups.length <= 0) {
            return new String("[]");
        }
        StringBuffer strBuf = null;
        strBuf = groups[0].compareTo("") == 0 ? new StringBuffer("[The PUBLIC Group") : new StringBuffer("[" + groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            if (groups[i].compareTo("") == 0) {
                strBuf.append(", The PUBLIC Group");
                continue;
            }
            strBuf.append(", ").append(groups[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    public static String writeArrayElementsToString(Object[] arr) {
        if (arr == null) {
            return new String("[]");
        }
        if (arr.length <= 0) {
            return new String("[]");
        }
        StringBuffer strBuf = new StringBuffer("[" + arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            strBuf.append(", ").append(arr[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    static {
        try {
            thisHost = NicUtil.getIpAddress("default.nic", "default", true);
            defaultGroup = System.getProperty("bigdata.fedname", "bigdata.test.group-" + thisHost);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        defaultCodebasePort = "23333";
        group = System.getProperty("bigdata.fedname", defaultGroup);
        codebasePortStr = System.getProperty("codebase.port", defaultCodebasePort);
        codebasePort = Integer.parseInt(codebasePortStr);
        groups = new String[]{group};
        locators = new LookupLocator[0];
        proxySet = new HashSet();
        implRefSet = new HashSet();
    }

    private class ServiceStarterConfig
    extends AbstractConfiguration {
        private String sdComponent = "com.sun.jini.start";
        private String sdEntryName = "servicePreparer";
        private Class sdType = ProxyPreparer.class;
        private ProxyPreparer proxyPreparer;

        ServiceStarterConfig(ProxyPreparer proxyPreparer) {
            this.proxyPreparer = proxyPreparer;
        }

        protected Object getEntryInternal(String component, String name, Class type, Object data) throws ConfigurationException {
            if (component == null || name == null || type == null) {
                throw new NullPointerException("component, name and type cannot be null");
            }
            if (this.sdComponent.equals(component) && this.sdEntryName.equals(name) && this.sdType.isAssignableFrom(type)) {
                return this.proxyPreparer;
            }
            throw new ConfigurationException("entry not found for component " + component + ", name " + name);
        }
    }

    private static class LookupDiscoveryListener
    implements DiscoveryListener {
        private LookupDiscoveryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent evnt) {
            logger.log((Priority)Level.INFO, (Object)"discovery event ...");
            ServiceRegistrar[] regs = evnt.getRegistrars();
            for (int i = 0; i < regs.length; ++i) {
                try {
                    LookupLocator loc = regs[i].getLocator();
                    String[] groups = regs[i].getGroups();
                    logger.log((Priority)Level.INFO, (Object)("discovered locator   = " + loc));
                    for (int j = 0; j < groups.length; ++j) {
                        logger.log((Priority)Level.INFO, (Object)("discovered groups[" + j + "] = " + groups[j]));
                    }
                    HashSet hashSet = proxySet;
                    synchronized (hashSet) {
                        proxySet.add(regs[i]);
                        continue;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent evnt) {
            logger.log((Priority)Level.INFO, (Object)"discarded event ...");
            ServiceRegistrar[] regs = evnt.getRegistrars();
            for (int i = 0; i < regs.length; ++i) {
                HashSet hashSet = proxySet;
                synchronized (hashSet) {
                    proxySet.remove(regs[i]);
                    continue;
                }
            }
        }
    }

    private class LookupStartThread
    extends Thread {
        public LookupStartThread() {
            super("LookupStartThread");
            this.setDaemon(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LookupStarter.setupDiscovery();
                LookupStarter.this.startLookupService();
                boolean lookupDiscovered = LookupStarter.waitForLookupServiceDiscovery();
                if (!lookupDiscovered) {
                    System.out.println("FAILED to start lookup service");
                    System.exit(-1);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-2);
            }
            HashSet hashSet = proxySet;
            synchronized (hashSet) {
                if (proxySet.size() > 0) {
                    System.out.println("lookup service started");
                }
            }
            while (!LookupStarter.this.waitForLookupServiceShutdown()) {
                LookupStarter.delayMS(3000L);
            }
            System.exit(0);
        }
    }
}

