/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.counters.CAT;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.channels.ClosedByInterruptException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;

public class MessageTest {
    protected static final Logger log = Logger.getLogger(MessageTest.class);
    public static final String COMPONENT = MessageTest.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException, TimeoutException, ConfigurationException {
        if (args.length == 0) {
            System.err.println("usage: <client-config-file>");
            System.exit(1);
        }
        JiniClient client = JiniClient.newInstance(args);
        IBigdataFederation fed = client.connect();
        long discoveryDelay = (Long)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "discoveryDelay", Long.TYPE, (Object)5000L);
        long duration = (Long)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "duration", Long.class, (Object)5000L);
        long messages = (Long)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "messages", Long.class, (Object)10000L);
        int parallel = (Integer)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "parallel", Integer.class, (Object)50);
        int payload = (Integer)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "payload", Integer.class, (Object)0);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Waiting up to " + discoveryDelay + "ms for metadata service discovery."));
            }
            ((AbstractScaleOutFederation)fed).awaitServices(2, discoveryDelay);
            UUID[] uuids = ((JiniFederation)fed).getDataServiceUUIDs(0);
            IDataService[] dataServices = new IDataService[uuids.length];
            for (int i = 0; i < uuids.length; ++i) {
                dataServices[i] = ((JiniFederation)fed).getDataService(uuids[i]);
            }
            ArrayList<MessageTask> tasks = new ArrayList<MessageTask>(dataServices.length);
            for (int i = 0; i < dataServices.length; ++i) {
                tasks.add(new MessageTask(duration, messages, parallel, payload, dataServices));
            }
            long begin = System.currentTimeMillis();
            List futures = ((AbstractFederation)fed).getExecutorService().invokeAll(tasks, duration, TimeUnit.MILLISECONDS);
            long nmessages = 0L;
            int failedServices = 0;
            for (Future future : futures) {
                try {
                    nmessages += ((Long)future.get()).longValue();
                }
                catch (ExecutionException ex) {
                    ++failedServices;
                    log.error((Object)("Failure: " + ex), (Throwable)ex);
                }
            }
            long elapsed = System.currentTimeMillis() - begin;
            System.out.println("#services=" + dataServices.length + ", elapsedMillis=" + elapsed + ", #messagesOk=" + nmessages + ", #failedServices=" + failedServices + ", rate=" + (elapsed == 0L ? 0.0 : (double)nmessages / (double)elapsed));
        }
        finally {
            client.disconnect(false);
        }
    }

    public static class NOpTask
    implements Callable<Void>,
    Externalizable {
        private int payload;

        public NOpTask() {
        }

        public NOpTask(int payload) {
            if (payload < 0) {
                throw new IllegalArgumentException();
            }
            this.payload = payload;
        }

        @Override
        public Void call() throws Exception {
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.payload);
            for (int i = 0; i < this.payload; ++i) {
                out.writeByte(i);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.payload = in.readInt();
            if (this.payload < 0) {
                throw new IOException();
            }
            for (int i = 0; i < this.payload; ++i) {
                in.readByte();
            }
        }
    }

    public static class MessageTask
    implements Callable<Long> {
        private final long duration;
        private final long messages;
        private final int parallel;
        private final int payload;
        private final IDataService[] dataServices;

        public MessageTask(long duration, long messages, int parallel, int payload, IDataService[] dataServices) {
            if (duration <= 0L) {
                throw new IllegalArgumentException();
            }
            if (messages <= 0L) {
                throw new IllegalArgumentException();
            }
            if (parallel <= 0) {
                throw new IllegalArgumentException();
            }
            if (payload < 0) {
                throw new IllegalArgumentException();
            }
            if (dataServices == null) {
                throw new IllegalArgumentException();
            }
            if (dataServices.length < 2) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < dataServices.length; ++i) {
                if (dataServices[i] != null) continue;
                throw new IllegalArgumentException();
            }
            this.duration = duration;
            this.messages = messages;
            this.parallel = parallel;
            this.payload = payload;
            this.dataServices = dataServices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            ExecutorService service = Executors.newFixedThreadPool(this.parallel, new DaemonThreadFactory("MessageTest"));
            try {
                long elapsed;
                long begin = System.currentTimeMillis();
                final CAT nsent = new CAT();
                final CAT ndone = new CAT();
                final CAT nerrors = new CAT();
                final AtomicBoolean running = new AtomicBoolean(true);
                while (running.get() && (elapsed = System.currentTimeMillis() - begin) < this.duration && nsent.estimate_get() < this.messages) {
                    for (int i = 0; i < this.dataServices.length; ++i) {
                        final IDataService ds = this.dataServices[i];
                        service.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Future<? extends Object> f = ds.submit(new NOpTask(MessageTask.this.payload));
                                    nsent.increment();
                                    f.get();
                                    ndone.increment();
                                }
                                catch (RemoteException e) {
                                    if (InnerCause.isInnerCause(e, RejectedExecutionException.class) || InnerCause.isInnerCause(e, InterruptedException.class) || InnerCause.isInnerCause(e, ClosedByInterruptException.class)) {
                                        if (running.compareAndSet(false, true)) {
                                            log.warn((Object)"Interrupted - will halt.");
                                        }
                                    } else {
                                        nerrors.increment();
                                        log.error((Object)e, (Throwable)e);
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (running.compareAndSet(false, true)) {
                                        log.warn((Object)"Interrupted - will halt.");
                                    }
                                }
                                catch (ExecutionException e) {
                                    if (InnerCause.isInnerCause(e, RejectedExecutionException.class) || InnerCause.isInnerCause(e, InterruptedException.class) || InnerCause.isInnerCause(e, ClosedByInterruptException.class)) {
                                        if (running.compareAndSet(false, true)) {
                                            log.warn((Object)"Interrupted - will halt.");
                                        }
                                    }
                                    nerrors.increment();
                                    log.error((Object)e, (Throwable)e);
                                }
                            }
                        });
                    }
                }
                Long l = ndone.get();
                return l;
            }
            finally {
                service.shutdownNow();
            }
        }
    }

    public static interface ConfigurationOptions {
        public static final String DISCOVERY_DELAY = "discoveryDelay";
        public static final long DEFAULT_DISCOVERY_DELAY = 5000L;
        public static final String DURATION = "duration";
        public static final long DEFAULT_DURATION = 5000L;
        public static final String MESSAGES = "messages";
        public static final long DEFAULT_MESSAGES = 10000L;
        public static final String PARALLEL = "parallel";
        public static final int DEFAULT_PARALLEL = 50;
        public static final String PAYLOAD = "payload";
        public static final int DEFAULT_PAYLOAD = 0;
    }
}

