/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.AsynchronousIndexWriteConfiguration;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.BatchContains;
import com.bigdata.btree.proc.BatchInsert;
import com.bigdata.btree.proc.BatchLookup;
import com.bigdata.btree.proc.BatchRemove;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.btree.proc.RangeCountProcedure;
import com.bigdata.counters.CounterSet;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IDataService;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.IdentityHandler;
import com.bigdata.service.ndx.PartitionedTupleIterator;
import com.bigdata.service.ndx.pipeline.IDuplicateRemover;
import com.bigdata.service.ndx.pipeline.IndexAsyncWriteStats;
import com.bigdata.service.ndx.pipeline.IndexPartitionWriteStats;
import com.bigdata.service.ndx.pipeline.IndexWriteTask;
import cutthecrap.utils.striterators.IFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractScaleOutClientIndexView
implements IScaleOutClientIndex {
    protected static final transient Logger log = Logger.getLogger(AbstractScaleOutClientIndexView.class);
    protected final boolean WARN = log.getEffectiveLevel().toInt() <= Level.WARN.toInt();
    protected static final transient String ERR_NEW_TX = "Could not start transaction";
    protected static final transient String ERR_ABORT_TX = "Could not abort transaction: tx=";
    protected final AbstractScaleOutFederation fed;
    protected final long taskTimeout;
    protected static final String NON_BATCH_API = "Non-batch API";
    protected final boolean batchOnly;
    private final int capacity;
    protected final long timestamp;
    protected final String name;
    private final IMetadataIndex metadataIndex;
    private final MetadataIndex.MetadataIndexMetadata metadataIndexMetadata;
    protected final boolean readConsistent;
    private volatile ITupleSerializer tupleSer = null;

    @Override
    public AbstractScaleOutFederation getFederation() {
        return this.fed;
    }

    protected ThreadPoolExecutor getThreadPool() {
        return (ThreadPoolExecutor)this.fed.getExecutorService();
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final IMetadataService getMetadataService() {
        return this.fed.getMetadataService();
    }

    protected final IMetadataIndex getMetadataIndex() {
        return this.metadataIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ name=" + this.name);
        sb.append(", timestamp=" + this.timestamp);
        sb.append(", readConsistent=" + this.readConsistent);
        sb.append("}");
        return sb.toString();
    }

    public AbstractScaleOutClientIndexView(AbstractScaleOutFederation fed, String name, long timestamp, IMetadataIndex metadataIndex) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (metadataIndex == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.name = name;
        this.timestamp = timestamp;
        this.metadataIndex = metadataIndex;
        this.metadataIndexMetadata = metadataIndex.getIndexMetadata();
        IBigdataClient client = fed.getClient();
        this.capacity = ((AbstractClient)client).getDefaultRangeQueryCapacity();
        this.batchOnly = ((AbstractClient)client).getBatchApiOnly();
        this.taskTimeout = ((AbstractClient)client).getTaskTimeout();
        this.readConsistent = ((AbstractClient)client).isReadConsistent();
    }

    public MetadataIndex.MetadataIndexMetadata getMetadataIndexMetadata() {
        return this.metadataIndexMetadata;
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.metadataIndexMetadata.getManagedIndexMetadata();
    }

    @Override
    public IDataService getDataService(PartitionLocator pmd) {
        return this.fed.getDataService(pmd.getDataServiceUUID());
    }

    @Override
    public Iterator<PartitionLocator> locatorScan(long ts, byte[] fromKey, byte[] toKey, boolean reverseScan) {
        return this.fed.locatorScan(this.name, ts, fromKey, toKey, reverseScan);
    }

    @Override
    public IResourceMetadata[] getResourceMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICounter getCounter() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITupleSerializer getTupleSerializer() {
        if (this.tupleSer == null) {
            AbstractScaleOutClientIndexView abstractScaleOutClientIndexView = this;
            synchronized (abstractScaleOutClientIndexView) {
                if (this.tupleSer == null) {
                    this.tupleSer = this.getIndexMetadata().getTupleSerializer();
                }
            }
        }
        return this.tupleSer;
    }

    @Override
    public boolean contains(Object key) {
        key = this.getTupleSerializer().serializeKey(key);
        return this.contains((byte[])key);
    }

    @Override
    public boolean contains(byte[] key) {
        if (this.batchOnly) {
            log.error((Object)NON_BATCH_API, (Throwable)new RuntimeException());
        } else if (this.WARN) {
            log.warn((Object)NON_BATCH_API);
        }
        byte[][] keys = new byte[][]{key};
        IdentityHandler resultHandler = new IdentityHandler();
        this.submit(0, 1, keys, null, BatchContains.BatchContainsConstructor.INSTANCE, resultHandler);
        return ((AbstractKeyArrayIndexProcedure.ResultBitBuffer)resultHandler.getResult()).getResult()[0];
    }

    @Override
    public Object insert(Object key, Object val) {
        ITupleSerializer tupleSer = this.getTupleSerializer();
        key = tupleSer.serializeKey(key);
        val = tupleSer.serializeKey(val);
        byte[] oldval = this.insert((byte[])key, (byte[])val);
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] insert(byte[] key, byte[] value) {
        if (this.batchOnly) {
            log.error((Object)NON_BATCH_API, (Throwable)new RuntimeException());
        } else if (this.WARN) {
            log.warn((Object)NON_BATCH_API);
        }
        byte[][] keys = new byte[][]{key};
        byte[][] vals = new byte[][]{value};
        IdentityHandler resultHandler = new IdentityHandler();
        this.submit(0, 1, keys, vals, BatchInsert.BatchInsertConstructor.RETURN_OLD_VALUES, resultHandler);
        return ((AbstractKeyArrayIndexProcedure.ResultBuffer)resultHandler.getResult()).getResult(0);
    }

    @Override
    public Object lookup(Object key) {
        key = this.getTupleSerializer().serializeKey(key);
        byte[] val = this.lookup((byte[])key);
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] lookup(byte[] key) {
        if (this.batchOnly) {
            log.error((Object)NON_BATCH_API, (Throwable)new RuntimeException());
        } else if (this.WARN) {
            log.warn((Object)NON_BATCH_API);
        }
        byte[][] keys = new byte[][]{key};
        IdentityHandler resultHandler = new IdentityHandler();
        this.submit(0, 1, keys, null, BatchLookup.BatchLookupConstructor.INSTANCE, resultHandler);
        return ((AbstractKeyArrayIndexProcedure.ResultBuffer)resultHandler.getResult()).getResult(0);
    }

    @Override
    public Object remove(Object key) {
        key = this.getTupleSerializer().serializeKey(key);
        byte[] oldval = this.remove((byte[])key);
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] remove(byte[] key) {
        if (this.batchOnly) {
            log.error((Object)NON_BATCH_API, (Throwable)new RuntimeException());
        } else if (this.WARN) {
            log.warn((Object)NON_BATCH_API);
        }
        byte[][] keys = new byte[][]{key};
        IdentityHandler resultHandler = new IdentityHandler();
        this.submit(0, 1, keys, null, BatchRemove.BatchRemoveConstructor.RETURN_OLD_VALUES, resultHandler);
        return ((AbstractKeyArrayIndexProcedure.ResultBuffer)resultHandler.getResult()).getValues().get(0);
    }

    @Override
    public long rangeCount() {
        return this.rangeCount(null, null);
    }

    @Override
    public long rangeCount(byte[] fromKey, byte[] toKey) {
        LongAggregator handler = new LongAggregator();
        RangeCountProcedure proc = new RangeCountProcedure(false, false, fromKey, toKey);
        this.submit(fromKey, toKey, proc, handler);
        return handler.getResult();
    }

    @Override
    public final long rangeCountExact(byte[] fromKey, byte[] toKey) {
        LongAggregator handler = new LongAggregator();
        RangeCountProcedure proc = new RangeCountProcedure(true, false, fromKey, toKey);
        this.submit(fromKey, toKey, proc, handler);
        return handler.getResult();
    }

    @Override
    public final long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        LongAggregator handler = new LongAggregator();
        RangeCountProcedure proc = new RangeCountProcedure(true, true, fromKey, toKey);
        this.submit(fromKey, toKey, proc, handler);
        return handler.getResult();
    }

    @Override
    public final ITupleIterator rangeIterator() {
        return this.rangeIterator(null, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.rangeIterator(fromKey, toKey, this.capacity, 3, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        boolean isReadConsistentTx;
        long ts;
        boolean readOnly;
        if (capacity == 0) {
            capacity = this.capacity;
        }
        boolean bl = readOnly = (flags & 8) != 0;
        if (readOnly && (flags & 0x10) != 0) {
            throw new IllegalArgumentException();
        }
        if (this.timestamp == 0L && readOnly || this.timestamp == -1L && this.readConsistent) {
            try {
                ts = this.fed.getTransactionService().newTx(-1L);
            }
            catch (IOException ex) {
                throw new RuntimeException(ERR_NEW_TX, ex);
            }
            isReadConsistentTx = true;
        } else {
            ts = this.timestamp;
            isReadConsistentTx = false;
        }
        return new PartitionedTupleIterator(this, ts, isReadConsistentTx, fromKey, toKey, capacity, flags, filter);
    }

    @Override
    public LinkedList<Split> splitKeys(long ts, int fromIndex, int toIndex, byte[][] keys) {
        assert (keys != null);
        assert (fromIndex >= 0);
        assert (fromIndex < toIndex);
        assert (toIndex <= keys.length);
        LinkedList<Split> splits = new LinkedList<Split>();
        int currentIndex = fromIndex;
        while (currentIndex < toIndex) {
            PartitionLocator locator = this.fed.getMetadataIndex(this.name, ts).find(keys[currentIndex]);
            if (locator == null) {
                throw new RuntimeException("No index partitions?: name=" + this.name);
            }
            byte[] rightSeparatorKey = locator.getRightSeparatorKey();
            if (rightSeparatorKey == null) {
                assert (this.isValidSplit(locator, currentIndex, toIndex, keys));
                splits.add(new Split(locator, currentIndex, toIndex));
                currentIndex = toIndex;
                continue;
            }
            int pos = BytesUtil.binarySearch(keys, currentIndex, toIndex - currentIndex, rightSeparatorKey);
            if (pos >= 0) {
                while (pos > currentIndex && BytesUtil.bytesEqual(keys[pos - 1], rightSeparatorKey)) {
                    --pos;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exact match on rightSeparator: pos=" + pos + ", key=" + BytesUtil.toString(keys[pos])));
                }
            } else if (pos < 0) {
                pos = -pos - 1;
                assert (pos > currentIndex && pos <= toIndex) : "Expected pos in [" + currentIndex + ":" + toIndex + ") but pos=" + pos;
            }
            splits.add(new Split(locator, currentIndex, pos));
            currentIndex = pos;
        }
        return splits;
    }

    @Override
    public LinkedList<Split> splitKeys(long ts, int fromIndex, int toIndex, KVO[] a) {
        byte[][] keys = new byte[a.length][];
        for (int i = 0; i < a.length; ++i) {
            keys[i] = a[i].key;
        }
        return this.splitKeys(ts, fromIndex, toIndex, keys);
    }

    private boolean isValidSplit(PartitionLocator locator, int fromIndex, int toIndex, byte[][] keys) {
        assert (fromIndex <= toIndex) : "fromIndex=" + fromIndex + ", toIndex=" + toIndex;
        assert (fromIndex >= 0) : "fromIndex=" + fromIndex;
        assert (toIndex <= keys.length) : "toIndex=" + toIndex + ", keys.length=" + keys.length;
        byte[] lastKey = locator.getLeftSeparatorKey();
        assert (lastKey != null);
        for (int i = fromIndex; i < toIndex; ++i) {
            byte[] key = keys[i];
            assert (key != null);
            if (lastKey != null) {
                int ret = BytesUtil.compareBytes(lastKey, key);
                assert (ret <= 0) : "keys out of order: i=" + i + ", lastKey=" + BytesUtil.toString(lastKey) + ", key=" + BytesUtil.toString(key) + ", keys=" + BytesUtil.toString(keys);
            }
            lastKey = key;
        }
        byte[] key = locator.getRightSeparatorKey();
        if (key != null) {
            int ret = BytesUtil.compareBytes(lastKey, key);
            assert (ret < 0) : "keys out of order: lastKey=" + BytesUtil.toString(lastKey) + ", rightSeparator=" + BytesUtil.toString(key) + ", keys=" + BytesUtil.toString(keys);
        }
        return true;
    }

    @Override
    public void staleLocator(long ts, PartitionLocator locator, StaleLocatorException cause) {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        if (ts != 0L && ts != -1L) {
            throw new RuntimeException("Stale locator, but views should be consistent? timestamp=" + TimestampUtility.toString(ts));
        }
        this.fed.getMetadataIndex(this.name, this.timestamp).staleLocator(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object submit(byte[] key, ISimpleIndexProcedure proc) {
        if (this.readConsistent && proc.isReadOnly() && TimestampUtility.isReadCommittedOrUnisolated(this.getTimestamp())) {
            long tx;
            try {
                tx = this.fed.getTransactionService().newTx(-1L);
            }
            catch (IOException ex) {
                throw new RuntimeException(ERR_NEW_TX, ex);
            }
            try {
                Object object = this.submit(tx, key, proc);
                return object;
            }
            finally {
                try {
                    this.fed.getTransactionService().abort(tx);
                }
                catch (IOException ex) {
                    log.error((Object)(ERR_ABORT_TX + tx), (Throwable)ex);
                }
            }
        }
        return this.submit(this.timestamp, key, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(byte[] fromKey, byte[] toKey, IKeyRangeIndexProcedure proc, IResultHandler resultHandler) {
        if (proc == null) {
            throw new IllegalArgumentException();
        }
        if (this.readConsistent && proc.isReadOnly() && TimestampUtility.isReadCommittedOrUnisolated(this.getTimestamp())) {
            long tx;
            try {
                tx = this.fed.getTransactionService().newTx(-1L);
            }
            catch (IOException ex) {
                throw new RuntimeException(ERR_NEW_TX, ex);
            }
            try {
                this.submit(tx, fromKey, toKey, proc, resultHandler);
            }
            finally {
                try {
                    this.fed.getTransactionService().abort(tx);
                }
                catch (IOException ex) {
                    log.error((Object)(ERR_ABORT_TX + tx), (Throwable)ex);
                }
            }
        }
        this.submit(this.timestamp, fromKey, toKey, proc, resultHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(int fromIndex, int toIndex, byte[][] keys, byte[][] vals, AbstractKeyArrayIndexProcedureConstructor ctor, IResultHandler aggregator) {
        long ts;
        boolean isTx;
        if (ctor == null) {
            throw new IllegalArgumentException();
        }
        Object proc = ctor.newInstance(this, fromIndex, toIndex, keys, vals);
        if (this.readConsistent && proc.isReadOnly() && TimestampUtility.isReadCommittedOrUnisolated(this.getTimestamp())) {
            isTx = true;
            try {
                ts = this.fed.getTransactionService().newTx(-1L);
            }
            catch (IOException e) {
                throw new RuntimeException(ERR_NEW_TX, e);
            }
        } else {
            isTx = false;
            ts = this.getTimestamp();
        }
        try {
            this.submit(ts, fromIndex, toIndex, keys, vals, ctor, aggregator);
        }
        finally {
            if (isTx) {
                try {
                    this.fed.getTransactionService().abort(ts);
                }
                catch (IOException e) {
                    log.error((Object)("Could not abort transaction: tx=: " + ts), (Throwable)e);
                }
            }
        }
    }

    protected abstract Object submit(long var1, byte[] var3, ISimpleIndexProcedure var4);

    protected abstract void submit(long var1, byte[] var3, byte[] var4, IKeyRangeIndexProcedure var5, IResultHandler var6);

    protected abstract void submit(long var1, int var3, int var4, byte[][] var5, byte[][] var6, AbstractKeyArrayIndexProcedureConstructor var7, IResultHandler var8);

    public <T extends IKeyArrayIndexProcedure, O, R, A> BlockingBuffer<KVO<O>[]> newWriteBuffer(IResultHandler<R, A> resultHandler, IDuplicateRemover<O> duplicateRemover, AbstractKeyArrayIndexProcedureConstructor<T> ctor) {
        AsynchronousIndexWriteConfiguration conf = this.getIndexMetadata().getAsynchronousIndexWriteConfiguration();
        BlockingBuffer<KVO<O>[]> writeBuffer = new BlockingBuffer<KVO<O>[]>(new ArrayBlockingQueue(conf.getMasterQueueCapacity()), conf.getMasterChunkSize(), conf.getMasterChunkTimeoutNanos(), TimeUnit.NANOSECONDS, true);
        IndexWriteTask.M<T, O, R, A> task = new IndexWriteTask.M<T, O, R, A>((IScaleOutClientIndex)this, conf.getSinkIdleTimeoutNanos(), conf.getSinkPollTimeoutNanos(), conf.getSinkQueueCapacity(), conf.getSinkChunkSize(), conf.getSinkChunkTimeoutNanos(), duplicateRemover, ctor, resultHandler, this.fed.getIndexCounters((String)this.name).asynchronousStats, writeBuffer);
        FutureTask<IndexAsyncWriteStats<PartitionLocator, IndexPartitionWriteStats>> ft = new FutureTask<IndexAsyncWriteStats<PartitionLocator, IndexPartitionWriteStats>>(task);
        writeBuffer.setFuture(ft);
        this.fed.getExecutorService().submit(ft);
        return task.getBuffer();
    }

    @Override
    public CounterSet getCounters() {
        return this.getFederation().getIndexCounters(this.name).getCounters();
    }
}

