/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.keys.KVO;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.ISplitter;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class AbstractSplitter
implements ISplitter {
    protected static final transient Logger log = Logger.getLogger(AbstractSplitter.class);

    protected abstract IMetadataIndex getMetadataIndex(long var1);

    @Override
    public LinkedList<Split> splitKeys(long ts, int fromIndex, int toIndex, byte[][] keys) {
        if (keys == null) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= toIndex) {
            throw new IllegalArgumentException();
        }
        if (toIndex > keys.length) {
            throw new IllegalArgumentException();
        }
        LinkedList<Split> splits = new LinkedList<Split>();
        int currentIndex = fromIndex;
        byte[] lastKey = null;
        while (currentIndex < toIndex) {
            byte[] key = keys[currentIndex];
            if (key == null) {
                throw new IllegalArgumentException("null @ index=" + currentIndex);
            }
            if (lastKey != null && BytesUtil.compareBytes(lastKey, key) > 0) {
                throw new IllegalArgumentException("keys out of order @ index=" + currentIndex + " : lastKey=" + BytesUtil.toString(lastKey) + ", thisKey=" + BytesUtil.toString(key));
            }
            lastKey = key;
            PartitionLocator locator = this.getMetadataIndex(ts).find(key);
            if (locator == null) {
                throw new RuntimeException("No index partitions?");
            }
            byte[] rightSeparatorKey = locator.getRightSeparatorKey();
            if (rightSeparatorKey == null) {
                this.isValidSplit(locator, currentIndex, toIndex, keys);
                splits.add(new Split(locator, currentIndex, toIndex));
                currentIndex = toIndex;
                continue;
            }
            int pos = BytesUtil.binarySearch(keys, currentIndex, toIndex - currentIndex, rightSeparatorKey);
            if (pos >= 0) {
                while (pos > currentIndex && BytesUtil.bytesEqual(keys[pos - 1], rightSeparatorKey)) {
                    --pos;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exact match on rightSeparator: pos=" + pos + ", key=" + BytesUtil.toString(keys[pos])));
                }
            } else if (pos < 0) {
                pos = -pos - 1;
                assert (pos > currentIndex && pos <= toIndex) : "Expected pos in [" + currentIndex + ":" + toIndex + ") but pos=" + pos;
            }
            splits.add(new Split(locator, currentIndex, pos));
            currentIndex = pos;
        }
        return splits;
    }

    @Override
    public LinkedList<Split> splitKeys(long ts, int fromIndex, int toIndex, KVO[] a) {
        byte[][] keys = new byte[a.length][];
        for (int i = 0; i < a.length; ++i) {
            keys[i] = a[i].key;
        }
        return this.splitKeys(ts, fromIndex, toIndex, keys);
    }

    private boolean isValidSplit(PartitionLocator locator, int fromIndex, int toIndex, byte[][] keys) {
        int ret;
        assert (fromIndex <= toIndex) : "fromIndex=" + fromIndex + ", toIndex=" + toIndex;
        assert (fromIndex >= 0) : "fromIndex=" + fromIndex;
        assert (toIndex <= keys.length) : "toIndex=" + toIndex + ", keys.length=" + keys.length;
        byte[] lastKey = locator.getLeftSeparatorKey();
        assert (lastKey != null);
        for (int i = fromIndex; i < toIndex; ++i) {
            int ret2;
            byte[] key = keys[i];
            assert (key != null);
            if (lastKey != null && (ret2 = BytesUtil.compareBytes(lastKey, key)) > 0) {
                throw new IllegalArgumentException("keys out of order: i=" + i + ", lastKey=" + BytesUtil.toString(lastKey) + ", key=" + BytesUtil.toString(key));
            }
            lastKey = key;
        }
        byte[] key = locator.getRightSeparatorKey();
        if (key != null && (ret = BytesUtil.compareBytes(lastKey, key)) >= 0) {
            throw new IllegalArgumentException("keys out of order: lastKey=" + BytesUtil.toString(lastKey) + ", rightSeparator=" + BytesUtil.toString(key));
        }
        return true;
    }
}

