/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.BigdataStatics;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.INotifyOutcome;
import com.bigdata.service.ndx.pipeline.AbstractMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetMasterStats;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetSubtask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractPendingSetMasterTask<H extends AbstractPendingSetMasterStats<L, ? extends AbstractSubtaskStats>, E, S extends AbstractPendingSetSubtask, L>
extends AbstractMasterTask<H, E, S, L>
implements INotifyOutcome<E, L> {
    protected static final transient Logger log = Logger.getLogger(AbstractPendingSetMasterTask.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final JiniFederation<?> fed;
    protected final INotifyOutcome<E, L> masterProxy;

    public JiniFederation<?> getFederation() {
        return this.fed;
    }

    protected abstract Map<E, Collection<L>> getPendingMap();

    public AbstractPendingSetMasterTask(JiniFederation<?> fed, H stats, BlockingBuffer<E[]> buffer, long sinkIdleTimeoutNanos, long sinkPollTimeoutNanos) {
        super(stats, buffer, sinkIdleTimeoutNanos, sinkPollTimeoutNanos);
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.masterProxy = fed.getProxy(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean nothingPending() {
        this.lock.lock();
        try {
            boolean bl = this.getPendingMap().isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPendingSetSize() {
        this.lock.lock();
        try {
            int n = this.getPendingMap().size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addPending(E e, AbstractPendingSetSubtask sink, L locator) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (sink == null) {
            throw new IllegalArgumentException();
        }
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            boolean modifiedMap;
            Collection<L> locators = this.getPendingMap().remove(e);
            if (locators == null) {
                locators = new LinkedHashSet<L>();
                locators.add(locator);
                this.getPendingMap().put(e, locators);
                sink.getPendingSet().add(e);
                modifiedMap = true;
            } else {
                locators.add(locator);
                this.getPendingMap().put(e, locators);
                sink.getPendingSet().add(e);
                modifiedMap = false;
            }
            if (BigdataStatics.debug || log.isDebugEnabled()) {
                String msg = "Added pending: size=" + this.getPendingSetSize() + ", resource=" + e + ", locator=" + locator + ", sinkSize=" + sink.getPendingSetSize();
                if (BigdataStatics.debug) {
                    System.err.println(msg);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
            }
            boolean bl = modifiedMap;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removePending(E e, L locator, Throwable cause) {
        int sizeUnderLock6;
        Collection<L> locators;
        boolean notify;
        block73: {
            int sizeUnderLock2;
            AbstractPendingSetSubtask sink;
            block71: {
                int sizeUnderLock3;
                block67: {
                    int sizeUnderLock4;
                    boolean i$;
                    Collection<L> locators2;
                    block68: {
                        int sizeUnderLock5;
                        if (e == null) {
                            throw new IllegalArgumentException();
                        }
                        if (locator == null) {
                            throw new IllegalArgumentException();
                        }
                        notify = false;
                        this.lock.lock();
                        if (cause != null) break block67;
                        locators2 = this.getPendingMap().remove(e);
                        if (locators2 != null) break block68;
                        boolean bl = false;
                        try {
                            sizeUnderLock5 = this.getPendingMap().size();
                        }
                        finally {
                            this.lock.unlock();
                        }
                        if (notify) {
                            if (cause == null) {
                                this.didSucceed(e);
                            } else {
                                this.didFail(e, cause);
                            }
                        }
                        if (BigdataStatics.debug || log.isDebugEnabled()) {
                            String msg = "resource=" + e + ", notify=" + notify + ", pendingSetSize=" + sizeUnderLock5 + ", locator=" + locator + (cause == null ? "" : "cause=" + cause);
                            if (BigdataStatics.debug) {
                                System.err.println(msg);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)msg);
                            }
                        }
                        return bl;
                    }
                    try {
                        for (L t : locators2) {
                            AbstractPendingSetSubtask sink2;
                            try {
                                sink2 = (AbstractPendingSetSubtask)super.getSink(t, false);
                            }
                            catch (InterruptedException ex) {
                                this.halt(ex);
                                throw new RuntimeException(ex);
                            }
                            sink2.removePending(e);
                        }
                        notify = locators2 != null;
                        i$ = true;
                    }
                    catch (Throwable throwable) {
                        int sizeUnderLock6;
                        try {
                            sizeUnderLock6 = this.getPendingMap().size();
                        }
                        finally {
                            this.lock.unlock();
                        }
                        if (notify) {
                            if (cause == null) {
                                this.didSucceed(e);
                            } else {
                                this.didFail(e, cause);
                            }
                        }
                        if (BigdataStatics.debug || log.isDebugEnabled()) {
                            String msg = "resource=" + e + ", notify=" + notify + ", pendingSetSize=" + sizeUnderLock6 + ", locator=" + locator + (cause == null ? "" : "cause=" + cause);
                            if (BigdataStatics.debug) {
                                System.err.println(msg);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)msg);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        sizeUnderLock4 = this.getPendingMap().size();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    if (notify) {
                        if (cause == null) {
                            this.didSucceed(e);
                        } else {
                            this.didFail(e, cause);
                        }
                    }
                    if (BigdataStatics.debug || log.isDebugEnabled()) {
                        String msg = "resource=" + e + ", notify=" + notify + ", pendingSetSize=" + sizeUnderLock4 + ", locator=" + locator + (cause == null ? "" : "cause=" + cause);
                        if (BigdataStatics.debug) {
                            System.err.println(msg);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)msg);
                        }
                    }
                    return i$;
                }
                locators = this.getPendingMap().get(e);
                if (locators != null) break block71;
                boolean i$ = false;
                try {
                    sizeUnderLock3 = this.getPendingMap().size();
                }
                finally {
                    this.lock.unlock();
                }
                if (notify) {
                    if (cause == null) {
                        this.didSucceed(e);
                    } else {
                        this.didFail(e, cause);
                    }
                }
                if (BigdataStatics.debug || log.isDebugEnabled()) {
                    String msg = "resource=" + e + ", notify=" + notify + ", pendingSetSize=" + sizeUnderLock3 + ", locator=" + locator + (cause == null ? "" : "cause=" + cause);
                    if (BigdataStatics.debug) {
                        System.err.println(msg);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg);
                    }
                }
                return i$;
            }
            locators.remove(locator);
            try {
                sink = (AbstractPendingSetSubtask)super.getSink(locator, false);
            }
            catch (InterruptedException ex) {
                this.halt(ex);
                throw new RuntimeException(ex);
            }
            sink.removePending(e);
            if (!locators.isEmpty()) break block73;
            this.getPendingMap().remove(e);
            notify = true;
            boolean bl = true;
            try {
                sizeUnderLock2 = this.getPendingMap().size();
            }
            finally {
                this.lock.unlock();
            }
            if (notify) {
                if (cause == null) {
                    this.didSucceed(e);
                } else {
                    this.didFail(e, cause);
                }
            }
            if (BigdataStatics.debug || log.isDebugEnabled()) {
                String msg = "resource=" + e + ", notify=" + notify + ", pendingSetSize=" + sizeUnderLock2 + ", locator=" + locator + (cause == null ? "" : "cause=" + cause);
                if (BigdataStatics.debug) {
                    System.err.println(msg);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
            }
            return bl;
        }
        this.getPendingMap().put(e, locators);
        boolean bl = false;
        try {
            sizeUnderLock6 = this.getPendingMap().size();
        }
        finally {
            this.lock.unlock();
        }
        if (notify) {
            if (cause == null) {
                this.didSucceed(e);
            } else {
                this.didFail(e, cause);
            }
        }
        if (BigdataStatics.debug || log.isDebugEnabled()) {
            String msg = "resource=" + e + ", notify=" + notify + ", pendingSetSize=" + sizeUnderLock6 + ", locator=" + locator + (cause == null ? "" : "cause=" + cause);
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
        }
        return bl;
    }

    protected abstract Map<E, Collection<L>> newPendingMap();

    @Override
    public final void success(E e, L locator) {
        this.removePending(e, locator, null);
    }

    @Override
    public final void error(E resource, L locator, Throwable cause) {
        this.removePending(resource, locator, null);
    }

    protected void didSucceed(E e) {
        if (log.isInfoEnabled()) {
            log.info((Object)e.toString());
        }
    }

    protected void didFail(E resource, Throwable cause) {
        log.error(resource, cause);
    }
}

