/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.btree.proc.AbstractIndexProcedure;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.sparse.INameFilter;
import com.bigdata.sparse.IRowStoreConstants;
import com.bigdata.sparse.ITPV;
import com.bigdata.sparse.KeyDecoder;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.SingleColumnFilter;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.sparse.TPS;
import com.bigdata.sparse.ValueType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public abstract class AbstractAtomicRowReadOrWrite
extends AbstractIndexProcedure<TPS>
implements ISimpleIndexProcedure<TPS>,
IRowStoreConstants,
Externalizable {
    private static final Logger log = Logger.getLogger(AbstractAtomicRowReadOrWrite.class);
    protected Schema schema;
    protected Object primaryKey;
    protected long fromTime;
    protected long toTime;
    protected INameFilter filter;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    protected AbstractAtomicRowReadOrWrite() {
    }

    protected AbstractAtomicRowReadOrWrite(Schema schema, Object primaryKey, long fromTime, long toTime, INameFilter filter) {
        SparseRowStore.assertArgs(schema, primaryKey, fromTime, toTime);
        this.schema = schema;
        this.primaryKey = primaryKey;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.filter = filter;
    }

    protected static TPS atomicRead(IIndex ndx, Schema schema, Object primaryKey, long fromTime, long toTime, long writeTime, INameFilter filter) {
        byte[] fromKey = schema.getPrefix(ndx.getIndexMetadata().getKeyBuilder(), primaryKey);
        TPS tps = AbstractAtomicRowReadOrWrite.atomicRead(ndx, fromKey, schema, fromTime, toTime, filter, new TPS(schema, writeTime));
        if (tps == null && log.isInfoEnabled()) {
            log.info((Object)("No data for primaryKey: " + primaryKey));
        }
        return tps;
    }

    protected static TPS atomicRead(IIndex ndx, byte[] fromKey, Schema schema, long fromTime, long toTime, INameFilter filter, TPS tps) {
        assert (ndx != null);
        assert (schema != null);
        assert (fromKey != null);
        assert (tps != null);
        byte[] toKey = SuccessorUtil.successor((byte[])fromKey.clone());
        if (log.isInfoEnabled()) {
            log.info((Object)("read: fromKey=" + BytesUtil.toString(fromKey) + "\n" + "read:   toKey=" + BytesUtil.toString(toKey)));
        }
        int flags = 11;
        ITupleIterator itr = ndx.rangeIterator(fromKey, toKey, 0, 11, null);
        int nscanned = 0;
        while (itr.hasNext()) {
            ITuple tuple = itr.next();
            byte[] key = tuple.getKey();
            ++nscanned;
            KeyDecoder keyDecoder = new KeyDecoder(key);
            String col = keyDecoder.getColumnName();
            if (filter != null && !filter.accept(col)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping property: name=" + col + " (filtered)"));
                continue;
            }
            long columnValueTimestamp = keyDecoder.getTimestamp();
            if (columnValueTimestamp < fromTime) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ignoring earlier revision: col=" + col + ", fromTime=" + fromTime + ", timestamp=" + columnValueTimestamp));
                continue;
            }
            if (toTime != Long.MIN_VALUE && columnValueTimestamp >= toTime) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ignoring later revision: col=" + col + ", toTime=" + toTime + ", timestamp=" + columnValueTimestamp));
                continue;
            }
            byte[] val = tuple.getValue();
            Object v = ValueType.decode(val);
            tps.set(col, columnValueTimestamp, v);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Accept: name=" + col + ", timestamp=" + columnValueTimestamp + ", value=" + v));
        }
        if (nscanned == 0) {
            return null;
        }
        if (toTime == Long.MIN_VALUE) {
            return tps.currentRow();
        }
        return tps;
    }

    protected static ITPV getCurrentValue(IIndex ndx, Schema schema, Object primaryKey, String name) {
        TPS tps = AbstractAtomicRowReadOrWrite.atomicRead(ndx, schema, primaryKey, 1L, Long.MIN_VALUE, 0L, new SingleColumnFilter(name));
        if (tps == null) {
            return null;
        }
        ITPV tpv = tps.get(name);
        if (tpv.getValue() == null) {
            return null;
        }
        return tpv;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        this.schema = (Schema)in.readObject();
        this.primaryKey = in.readObject();
        this.fromTime = in.readLong();
        this.toTime = in.readLong();
        this.filter = (INameFilter)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this.schema);
        out.writeObject(this.primaryKey);
        out.writeLong(this.fromTime);
        out.writeLong(this.toTime);
        out.writeObject(this.filter);
    }
}

