/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.relation.AbstractRelation;
import com.bigdata.sparse.LogicalRowSplitHandler;
import com.bigdata.sparse.SparseRowStore;
import java.util.UUID;
import org.apache.log4j.Logger;

public class GlobalRowStoreHelper {
    public static final transient String GLOBAL_ROW_STORE_INDEX = "__globalRowStore";
    private final IIndexManager indexManager;
    protected static final transient Logger log = Logger.getLogger(GlobalRowStoreHelper.class);

    public GlobalRowStoreHelper(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.indexManager = indexManager;
    }

    public synchronized SparseRowStore getGlobalRowStore() {
        IIndex ndx;
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        if ((ndx = AbstractRelation.getIndex(this.indexManager, GLOBAL_ROW_STORE_INDEX, 0L)) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Global row store does not exist - will try to register now");
            }
            try {
                IndexMetadata indexMetadata = new IndexMetadata(GLOBAL_ROW_STORE_INDEX, UUID.randomUUID());
                indexMetadata.setSplitHandler(LogicalRowSplitHandler.INSTANCE);
                this.indexManager.registerIndex(indexMetadata);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ndx = AbstractRelation.getIndex(this.indexManager, GLOBAL_ROW_STORE_INDEX, 0L);
            if (ndx == null) {
                throw new RuntimeException("Could not find index?");
            }
        }
        SparseRowStore globalRowStore = new SparseRowStore(ndx);
        return globalRowStore;
    }

    public SparseRowStore get(long timestamp) {
        if (log.isInfoEnabled()) {
            log.info((Object)TimestampUtility.toString(timestamp));
        }
        if (timestamp == 0L) {
            return this.getGlobalRowStore();
        }
        IIndex ndx = AbstractRelation.getIndex(this.indexManager, GLOBAL_ROW_STORE_INDEX, TimestampUtility.asHistoricalRead(timestamp));
        if (ndx == null) {
            return null;
        }
        return new SparseRowStore(ndx);
    }
}

