/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ChunkedArrayIterator<E>
implements IChunkedOrderedIterator<E> {
    private boolean open = true;
    private E[] buffer;
    private int bufferCount;
    private final IKeyOrder<E> keyOrder;
    private int i = 0;

    public int getBufferCount() {
        return this.bufferCount;
    }

    public ChunkedArrayIterator(E[] a) {
        this(a.length, a, null);
    }

    public ChunkedArrayIterator(int n, E[] a, IKeyOrder<E> keyOrder) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > a.length) {
            throw new IllegalArgumentException();
        }
        this.buffer = a;
        this.bufferCount = n;
        this.keyOrder = keyOrder;
    }

    @Override
    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        assert (this.i <= this.bufferCount);
        return this.i != this.bufferCount;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buffer[this.i++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public E[] array() {
        this.assertOpen();
        return this.buffer;
    }

    @Override
    public E[] nextChunk() {
        Object[] ret;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.i == 0 && this.bufferCount == this.buffer.length) {
            ret = this.buffer;
        } else {
            int remaining = this.bufferCount - this.i;
            ret = (Object[])Array.newInstance(this.buffer.getClass().getComponentType(), remaining);
            System.arraycopy(this.buffer, this.i, ret, 0, remaining);
        }
        this.i = this.bufferCount;
        return ret;
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public E[] nextChunk(IKeyOrder<E> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.getKeyOrder())) {
            Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
        }
        return chunk;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.buffer = null;
        this.bufferCount = 0;
        this.i = 0;
    }

    private final void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException();
        }
    }
}

