/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Chunkerator<E>
implements ICloseableIterator<E[]> {
    private final IChunkedIterator<E> src;
    private boolean open = true;

    public Chunkerator(Iterator<E> src) {
        this(src, 100);
    }

    public Chunkerator(Iterator<E> src, int chunkSize) {
        this(src, chunkSize, null);
    }

    public Chunkerator(Iterator<E> src, int chunkSize, Class<? extends E> elementClass) {
        this(src, chunkSize, elementClass, null, null);
    }

    public Chunkerator(Iterator<E> src, int chunkSize, Class<? extends E> elementClass, IKeyOrder<E> keyOrder, IElementFilter<E> filter) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = new ChunkedWrappedIterator<E>(src, chunkSize, elementClass, keyOrder, filter);
    }

    @Override
    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        if (!this.src.hasNext()) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public E[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.src.nextChunk();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            if (this.src instanceof ICloseable) {
                this.src.close();
            }
        }
    }
}

