/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import it.unimi.dsi.bits.AbstractBitVector;
import java.nio.ByteBuffer;

public class ByteBufferBitVector
extends AbstractBitVector {
    private final ByteBuffer b;
    private final long len;
    private final long off;

    public final long length() {
        return this.len;
    }

    public ByteBufferBitVector(ByteBuffer b) {
        this(b, 0L, b == null ? 0L : (long)(b.capacity() * 8));
    }

    public ByteBufferBitVector(ByteBuffer b, long off, long len) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        if (len < 0L) {
            throw new IllegalArgumentException();
        }
        if (len < 0L) {
            throw new IllegalArgumentException();
        }
        if (off + len > (long)b.capacity() * 8L) {
            throw new IllegalArgumentException();
        }
        this.b = b;
        this.len = len;
        this.off = off;
    }

    protected final int byteIndexForBit(long bitIndex) {
        return (int)((bitIndex + this.off) / 8L);
    }

    protected final int withinByteIndexForBit(long bitIndex) {
        return (int)((bitIndex + this.off) % 8L);
    }

    public boolean getBoolean(long index) {
        if (index < 0L || index >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return (this.b.get(this.byteIndexForBit(index)) & 1 << this.withinByteIndexForBit(index)) != 0;
    }
}

