/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import com.bigdata.util.config.ConfigDeployUtil;
import com.bigdata.util.config.LogUtil;
import com.sun.jini.config.Config;
import com.sun.jini.thread.InterruptedStatusThread;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Util {
    public static <T extends Comparable<T>> T max(T ... elements) {
        T max = elements[0];
        for (T element : elements) {
            if (0 >= element.compareTo(max)) continue;
            max = element;
        }
        return max;
    }

    public static <T extends Comparable<T>> T min(T ... elements) {
        T min = elements[0];
        for (T element : elements) {
            if (0 <= element.compareTo(min)) continue;
            min = element;
        }
        return min;
    }

    public static void cleanupOnExit(Object innerProxy, Exporter serverExporter, JoinManager joinManager, DiscoveryManagement discoveryManager) {
        Util.cleanupOnExit(innerProxy, serverExporter, joinManager, null, discoveryManager);
    }

    public static void cleanupOnExit(ServiceDiscoveryManager serviceDiscoveryManager, DiscoveryManagement discoveryManager) {
        Util.cleanupOnExit(null, null, null, serviceDiscoveryManager, discoveryManager);
    }

    public static void cleanupOnExit(Object innerProxy, Exporter serverExporter, JoinManager joinManager, ServiceDiscoveryManager serviceDiscoveryManager, DiscoveryManagement discoveryManager) {
        if (innerProxy != null) {
            try {
                if (serverExporter != null) {
                    serverExporter.unexport(true);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (joinManager != null) {
            try {
                joinManager.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (serviceDiscoveryManager != null) {
            try {
                serviceDiscoveryManager.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (discoveryManager != null) {
            try {
                discoveryManager.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static boolean unexportRemoteObject(Exporter exporter) {
        if (exporter == null) {
            return false;
        }
        long endTime = System.currentTimeMillis() + 60000L;
        boolean unexported = false;
        try {
            while (!unexported && System.currentTimeMillis() < endTime) {
                unexported = exporter.unexport(false);
                if (unexported) continue;
                Thread.yield();
            }
            if (!unexported) {
                unexported = exporter.unexport(true);
            }
        }
        catch (IllegalStateException e) {
            return false;
        }
        return unexported;
    }

    public static void handleInitThrowable(Throwable t, Logger logger) throws IOException, ConfigurationException {
        if (logger != null) {
            logger.log((Priority)Level.FATAL, (Object)"initialization failure ... ", t);
        } else {
            System.err.println("FATAL: initialization failure ... " + t);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ConfigurationException) {
            throw (ConfigurationException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static String writeGroupArrayToString(String[] groups) {
        if (groups == null) {
            return new String("[ALL_GROUPS]");
        }
        if (groups.length <= 0) {
            return new String("[]");
        }
        StringBuffer strBuf = null;
        strBuf = groups[0].compareTo("") == 0 ? new StringBuffer("[The PUBLIC Group") : new StringBuffer("[" + groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            if (groups[i].compareTo("") == 0) {
                strBuf.append(", The PUBLIC Group");
                continue;
            }
            strBuf.append(", ").append(groups[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    public static String writeArrayElementsToString(Object[] arr) {
        if (arr == null) {
            return new String("[]");
        }
        if (arr.length <= 0) {
            return new String("[]");
        }
        StringBuffer strBuf = new StringBuffer("[" + arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            strBuf.append(", ").append(arr[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    public static <T extends Throwable> T initCause(T t, Throwable cause) {
        t.initCause(cause);
        return t;
    }

    public static void checkElementTypes(Collection<?> c, Class<?> type) {
        for (Object elt : c) {
            if (type.isInstance(elt)) continue;
            throw new ClassCastException(elt + " not assignable to " + type);
        }
    }

    public static UUID toUUID(ServiceID serviceId) {
        return new UUID(serviceId.getMostSignificantBits(), serviceId.getLeastSignificantBits());
    }

    public static String eventToString(ServiceDiscoveryEvent event) {
        return "ServiceDiscoveryEvent[source=" + event.getSource() + ",preEventItem=" + event.getPreEventServiceItem() + ",postEventItem=" + event.getPostEventServiceItem() + "]";
    }

    public static DiscoveryManagement getDiscoveryManager(Configuration config, String componentName, String entryName) throws ConfigurationException, IOException {
        DiscoveryManagement dMgr;
        try {
            dMgr = (DiscoveryManagement)Config.getNonNullEntry((Configuration)config, (String)componentName, (String)entryName, DiscoveryManagement.class);
            if (!(dMgr instanceof DiscoveryGroupManagement)) {
                throw new ConfigurationException(entryName + " entry must " + "implement DiscoveryGroupManagment");
            }
            if (!(dMgr instanceof DiscoveryLocatorManagement)) {
                throw new ConfigurationException(entryName + " entry must " + "implement DiscoveryLocatorManagement");
            }
        }
        catch (NoSuchEntryException e) {
            return new LookupDiscoveryManager(ConfigDeployUtil.getGroupsToDiscover(), ConfigDeployUtil.getLocatorsToDiscover(), null, config);
        }
        return dMgr;
    }

    public static DiscoveryManagement getDiscoveryManager(Configuration config, String componentName) throws ConfigurationException, IOException {
        return Util.getDiscoveryManager(config, componentName, "discoveryManager");
    }

    public static class WaitOnInterruptThread
    extends InterruptedStatusThread {
        private Logger logger;

        public WaitOnInterruptThread(Logger logger) {
            super("WaitOnInterruptThread");
            this.setDaemon(true);
            this.logger = logger == null ? LogUtil.getLog4jLogger(((Object)((Object)this)).getClass().getName()) : logger;
        }

        public void run() {
            while (!this.hasBeenInterrupted()) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.log((Priority)Level.DEBUG, (Object)"Util.WaitOnInterruptThread: interrupt received");
                }
            }
        }
    }
}

