/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;
    private final String basename;
    private int counter = 0;
    private static ThreadFactory _default = new DaemonThreadFactory();

    public static final ThreadFactory defaultThreadFactory() {
        return _default;
    }

    public DaemonThreadFactory() {
        this(Executors.defaultThreadFactory(), null);
    }

    public DaemonThreadFactory(String basename) {
        this(Executors.defaultThreadFactory(), basename);
    }

    public DaemonThreadFactory(ThreadFactory delegate, String basename) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.basename = basename;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.delegate.newThread(r);
        if (this.basename != null) {
            ++this.counter;
            t.setName(this.basename + this.counter);
        }
        t.setDaemon(true);
        return t;
    }
}

