/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.bop.engine.QueryTimeoutException;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.IHaltable;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Haltable<V>
implements IHaltable<V> {
    private static final transient Logger log = Logger.getLogger(Haltable.class);
    private final Lock lock = new ReentrantLock();
    private final Condition halted = this.lock.newCondition();
    private V result = null;
    private volatile Throwable firstCause = null;
    private volatile boolean error = false;
    private volatile boolean deadline = false;
    private volatile boolean halt = false;
    private volatile boolean cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void halt(V v) {
        this.lock.lock();
        try {
            if (this.halt) {
                return;
            }
            try {
                this.halted.signalAll();
                this.result = v;
            }
            finally {
                this.halt = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends Throwable> T halt(T cause) {
        boolean didHalt;
        block8: {
            this.lock.lock();
            try {
                didHalt = !this.halt;
                if (!didHalt) break block8;
                this.firstCause = cause != null ? cause : new IllegalArgumentException();
                this.error = !this.isNormalTerminationCause(this.firstCause);
                this.deadline = this.isDeadlineTerminationCause(this.firstCause);
                try {
                    this.halted.signalAll();
                }
                finally {
                    this.halt = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        try {
            this.logCause(didHalt, cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cause;
    }

    public final void halted() {
        if (this.halt) {
            if (this.firstCause == null) {
                throw new RuntimeException("Halted");
            }
            throw new RuntimeException(this.firstCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.lock.lock();
        try {
            InterruptedException t = new InterruptedException();
            this.halt((Throwable)t);
            if (this.firstCause == t) {
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.halt) {
                this.halted.await();
            }
            if (this.cancelled) {
                CancellationException t = new CancellationException();
                t.initCause(this.firstCause);
                throw t;
            }
            if (this.error) {
                throw new ExecutionException(this.firstCause);
            }
            V v = this.result;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long begin = System.nanoTime();
        long nanos = unit.toNanos(timeout);
        long remaining = nanos;
        if (this.lock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            try {
                remaining = nanos - (System.nanoTime() - begin);
                while (!this.halt) {
                    if (remaining > 0L) {
                        remaining = this.halted.awaitNanos(remaining);
                        continue;
                    }
                    throw new TimeoutException();
                }
                if (this.error) {
                    throw new ExecutionException(this.firstCause);
                }
                V v = this.result;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new TimeoutException();
    }

    @Override
    public final boolean isDone() {
        return this.halt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isError() {
        this.lock.lock();
        try {
            boolean bl = this.halt && this.error;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.halt && this.cancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Throwable getCause() {
        this.lock.lock();
        try {
            if (!this.halt) {
                Throwable throwable = null;
                return throwable;
            }
            if (!this.error) {
                Throwable throwable = null;
                return throwable;
            }
            Throwable throwable = this.firstCause;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final Throwable getAsThrownCause() {
        return this.firstCause;
    }

    protected boolean isNormalTerminationCause(Throwable cause) {
        if (Haltable.isTerminationByInterrupt(cause)) {
            return true;
        }
        return InnerCause.isInnerCause(cause, RejectedExecutionException.class);
    }

    protected boolean isDeadlineTerminationCause(Throwable cause) {
        return InnerCause.isInnerCause(cause, QueryTimeoutException.class);
    }

    public static boolean isTerminationByInterrupt(Throwable cause) {
        if (InnerCause.isInnerCause(cause, InterruptedException.class)) {
            return true;
        }
        if (InnerCause.isInnerCause(cause, CancellationException.class)) {
            return true;
        }
        if (InnerCause.isInnerCause(cause, ClosedByInterruptException.class)) {
            return true;
        }
        return InnerCause.isInnerCause(cause, BufferClosedException.class);
    }

    private void logCause(boolean isFirstCause, Throwable cause) {
        if (isFirstCause) {
            if (this.deadline) {
                log.warn((Object)(this + " : isFirstCause=" + isFirstCause + " : " + cause), cause);
            } else if (this.error) {
                log.error((Object)(this + " : isFirstCause=" + isFirstCause + " : " + cause), cause);
            }
        } else if (log.isEnabledFor((Priority)Level.WARN)) {
            if (!this.deadline && this.error) {
                log.warn((Object)(this + " : isFirstCause=" + isFirstCause + " : " + cause), cause);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)(this + " : isFirstCause=" + isFirstCause + " : " + cause), cause);
        }
    }
}

