/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.httpd;

import com.bigdata.service.IServiceShutdown;
import com.bigdata.util.CaseInsensitiveStringComparator;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import com.bigdata.util.httpd.MIMEType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class NanoHTTPD
implements IServiceShutdown {
    private static final Logger log = Logger.getLogger(NanoHTTPD.class);
    private final ServerSocket ss;
    private volatile boolean open = false;
    private static final String EOL = "\r\n";
    public static final String UTF8 = "UTF-8";
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    protected static final String ERR_BAD_REQUEST = "BAD REQUEST: Syntax error. Usage: GET /example/file.html";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String DATE = "Date";
    public static final String httpDefaultCharacterEncoding = "ISO-8859-1";
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_METHOD_NOT_ALLOWED = "405 Method Not Allowed";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_TEXT_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    public static final String MIME_APPLICATION_XML = "application/xml";
    public static final String MIME_TEXT_JAVASCRIPT = "text/javascript";
    public static final String MIME_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
    private final ExecutorService acceptService = Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.getClass().getName() + ".acceptService"));
    private final ExecutorService requestService;
    private final int myTcpPort;
    private static Hashtable<String, String> theMimeTypes = new Hashtable();
    private static SimpleDateFormat gmtFrmt;

    protected Response serve(Request req) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(req.method + " '" + req.uri + "' "));
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, String> entry : req.headers.entrySet()) {
                log.debug((Object)("  HDR: '" + entry.getKey() + "' = '" + entry.getValue() + "'"));
            }
            for (Map.Entry<String, Vector<String>> entry : req.params.entrySet()) {
                log.debug((Object)("  PRM: '" + entry.getKey() + "' = '" + entry.getValue() + "'"));
            }
        }
        return this.serveFile(req.uri, req.headers, new File("."), true);
    }

    public NanoHTTPD(int port) throws IOException {
        if (port != 0) {
            this.myTcpPort = port;
            this.ss = new ServerSocket(this.myTcpPort);
        } else {
            this.ss = new ServerSocket(0);
            this.myTcpPort = this.ss.getLocalPort();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Running on port=" + this.myTcpPort));
        }
        boolean requestServicePoolSize = false;
        this.requestService = (ThreadPoolExecutor)Executors.newCachedThreadPool(new DaemonThreadFactory(this.getClass().getName() + ".requestService"));
        this.open = true;
        this.acceptService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (NanoHTTPD.this.open) {
                        NanoHTTPD.this.requestService.submit(new HTTPSession(NanoHTTPD.this.ss.accept()));
                    }
                }
                catch (IOException ioe) {
                    if (!NanoHTTPD.this.open) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"closed.");
                        }
                        return;
                    }
                    log.error((Object)ioe, (Throwable)ioe);
                }
            }
        });
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.open) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        long begin = System.currentTimeMillis();
        long shutdownTimeout = 1000L;
        TimeUnit unit = TimeUnit.MILLISECONDS;
        this.open = false;
        this.acceptService.shutdownNow();
        this.requestService.shutdown();
        try {
            long elapsed;
            if (log.isInfoEnabled()) {
                log.info((Object)"Awaiting request service termination");
            }
            if (!this.requestService.awaitTermination(1000L - (elapsed = System.currentTimeMillis() - begin), unit)) {
                log.warn((Object)"Request service termination: timeout");
            }
        }
        catch (InterruptedException ex) {
            log.warn((Object)"Interrupted awaiting request service termination.", (Throwable)ex);
        }
        try {
            this.ss.close();
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.open) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.open = false;
        this.acceptService.shutdownNow();
        this.requestService.shutdownNow();
        try {
            this.ss.close();
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        System.out.println("NanoHTTPD 1.1 (C) 2001,2005-2007 Jarno Elonen\n(Command line options: [port])\n");
        int port = 80;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        try {
            new NanoHTTPD(port);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't start server:\n" + ioe);
            System.exit(-1);
        }
        System.out.println("Now serving files in port " + port + " from \"" + new File("").getAbsolutePath() + "\"");
        System.out.println("Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String encodeUri(String uri) {
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        StringBuilder newUri = new StringBuilder("");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                newUri.append("/");
                continue;
            }
            if (tok.equals(" ")) {
                newUri.append("%20");
                continue;
            }
            try {
                newUri.append(URLEncoder.encode(tok, UTF8));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }
        return newUri.toString();
    }

    public int getPort() {
        return this.myTcpPort;
    }

    protected Response serveFile(String uri, Map<String, String> header, File homeDir, boolean allowDirectoryListing) {
        if (!homeDir.isDirectory()) {
            return new Response(HTTP_INTERNALERROR, MIME_TEXT_PLAIN, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
        }
        if ((uri = uri.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        if (uri.startsWith("..") || uri.endsWith("..") || uri.indexOf("../") >= 0) {
            return new Response(HTTP_FORBIDDEN, MIME_TEXT_PLAIN, "FORBIDDEN: Won't serve ../ for security reasons.");
        }
        File f = new File(homeDir, uri);
        if (!f.exists()) {
            return new Response(HTTP_NOTFOUND, MIME_TEXT_PLAIN, "Error 404, file not found.");
        }
        if (f.isDirectory()) {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
                Response r = new Response(HTTP_REDIRECT, MIME_TEXT_HTML, "<html><body>Redirected: <a href=\"" + uri + "\">" + uri + "</a></body></html>");
                r.addHeader("Location", uri);
                return r;
            }
            if (new File(f, "index.html").exists()) {
                f = new File(homeDir, uri + "/index.html");
            } else if (new File(f, "index.htm").exists()) {
                f = new File(homeDir, uri + "/index.htm");
            } else {
                if (allowDirectoryListing) {
                    String u;
                    int slash;
                    String[] files = f.list();
                    String msg = "<html><body><h1>Directory " + uri + "</h1><br/>";
                    if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
                        msg = msg + "<b><a href=\"" + uri.substring(0, slash + 1) + "\">..</a></b><br/>";
                    }
                    for (int i = 0; i < files.length; ++i) {
                        File curFile = new File(f, files[i]);
                        boolean dir = curFile.isDirectory();
                        if (dir) {
                            msg = msg + "<b>";
                            int n = i;
                            files[n] = files[n] + "/";
                        }
                        msg = msg + "<a href=\"" + NanoHTTPD.encodeUri(uri + files[i]) + "\">" + files[i] + "</a>";
                        if (curFile.isFile()) {
                            long len = curFile.length();
                            msg = msg + " &nbsp;<font size=2>(";
                            msg = len < 1024L ? msg + curFile.length() + " bytes" : (len < 0x100000L ? msg + curFile.length() / 1024L + "." + curFile.length() % 1024L / 10L % 100L + " KB" : msg + curFile.length() / 0x100000L + "." + curFile.length() % 0x100000L / 10L % 100L + " MB");
                            msg = msg + ")</font>";
                        }
                        msg = msg + "<br/>";
                        if (!dir) continue;
                        msg = msg + "</b>";
                    }
                    return new Response(HTTP_OK, MIME_TEXT_HTML, msg);
                }
                return new Response(HTTP_FORBIDDEN, MIME_TEXT_PLAIN, "FORBIDDEN: No directory listing.");
            }
        }
        try {
            String mime = null;
            int dot = f.getCanonicalPath().lastIndexOf(46);
            if (dot >= 0) {
                mime = theMimeTypes.get(f.getCanonicalPath().substring(dot + 1).toLowerCase());
            }
            if (mime == null) {
                mime = MIME_DEFAULT_BINARY;
            }
            long startFrom = 0L;
            String range = header.get("Range");
            if (range != null && range.startsWith("bytes=")) {
                int minus = (range = range.substring("bytes=".length())).indexOf(45);
                if (minus > 0) {
                    range = range.substring(0, minus);
                }
                try {
                    startFrom = Long.parseLong(range);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            FileInputStream fis = new FileInputStream(f);
            fis.skip(startFrom);
            Response r = new Response(HTTP_OK, mime, fis);
            r.addHeader("Content-length", "" + (f.length() - startFrom));
            r.addHeader("Content-range", "" + startFrom + "-" + (f.length() - 1L) + "/" + f.length());
            return r;
        }
        catch (IOException ioe) {
            return new Response(HTTP_FORBIDDEN, MIME_TEXT_PLAIN, "FORBIDDEN: Reading file failed.");
        }
    }

    public static LinkedHashMap<String, Vector<String>> decodeParams(String parms, LinkedHashMap<String, Vector<String>> p) throws UnsupportedEncodingException {
        if (parms == null) {
            throw new IllegalArgumentException();
        }
        if (p == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer st = new StringTokenizer(parms, "&");
        while (st.hasMoreTokens()) {
            Vector<String> vals;
            String val;
            String name;
            String e = st.nextToken();
            int sep = e.indexOf(61);
            if (sep != -1) {
                name = NanoHTTPD.decodePercent(e.substring(0, sep)).trim();
                val = NanoHTTPD.decodePercent(e.substring(sep + 1));
            } else {
                name = NanoHTTPD.decodePercent(e).trim();
                val = null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(name + ": " + val));
            }
            if ((vals = p.get(name)) == null) {
                vals = new Vector();
                p.put(name, vals);
            }
            if (val == null) continue;
            vals.add(val);
        }
        return p;
    }

    private static String decodePercent(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str, UTF8);
    }

    public static StringBuilder encodeParams(LinkedHashMap<String, Vector<String>> expected) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Vector<String>> e : expected.entrySet()) {
            String k = e.getKey();
            Vector<String> vec = e.getValue();
            for (String v : vec) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(k, UTF8));
                sb.append("=");
                sb.append(URLEncoder.encode(v, UTF8));
            }
        }
        return sb;
    }

    static {
        StringTokenizer st = new StringTokenizer("htm\t\ttext/html html\t\ttext/html txt\t\ttext/plain asc\t\ttext/plain gif\t\timage/gif jpg\t\timage/jpeg jpeg\t\timage/jpeg png\t\timage/png mp3\t\taudio/mpeg m3u\t\taudio/mpeg-url pdf\t\tapplication/pdf doc\t\tapplication/msword ogg\t\tapplication/x-ogg zip\t\tapplication/octet-stream exe\t\tapplication/octet-stream class\t\tapplication/octet-stream ");
        while (st.hasMoreTokens()) {
            theMimeTypes.put(st.nextToken(), st.nextToken());
        }
        gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class Request {
        public final String uri;
        public final String method;
        public final Map<String, String> headers;
        public final LinkedHashMap<String, Vector<String>> params;
        private final InputStream is;

        public InputStream getInputStream() {
            return this.is;
        }

        private Request(String uri, String method, Map<String, String> headers, LinkedHashMap<String, Vector<String>> params, InputStream is) {
            this.uri = uri;
            this.method = method;
            this.headers = headers;
            this.params = params;
            this.is = is;
        }

        public int getContentLength() {
            String s = this.headers.get(NanoHTTPD.CONTENT_LENGTH);
            if (s == null) {
                return -1;
            }
            return Long.valueOf(s).intValue();
        }

        public String getContentType() {
            return this.headers.get(NanoHTTPD.CONTENT_TYPE);
        }

        public byte[] getBinaryContent() throws IOException {
            int ch;
            int contentLength = this.getContentLength();
            if (log.isDebugEnabled()) {
                log.debug((Object)("contentLength=" + contentLength + " : reading request body..."));
            }
            ByteArrayOutputStream baos = contentLength == -1 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(contentLength);
            int len = 0;
            while ((ch = this.is.read()) != -1) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Read ch=" + ch + ", len=" + len + ", contentLength=" + contentLength));
                }
                baos.write(ch);
                if (contentLength == -1 || ++len != contentLength) continue;
                break;
            }
            return baos.toByteArray();
        }

        public String getStringContent() throws IOException {
            String s = this.headers.get(NanoHTTPD.CONTENT_TYPE);
            MIMEType mt = new MIMEType(s);
            byte[] b = this.getBinaryContent();
            String charset = mt.getParamValue("charset");
            if (charset == null) {
                charset = NanoHTTPD.httpDefaultCharacterEncoding;
            }
            return new String(b, charset);
        }
    }

    private class HTTPSession
    implements Runnable {
        private final Socket mySocket;
        private final ByteArrayOutputStream _baos = new ByteArrayOutputStream(256);

        public HTTPSession(Socket s) {
            this.mySocket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)("Handling request: localPort=" + this.mySocket.getLocalPort()));
            }
            InputStream is = null;
            try {
                is = this.mySocket.getInputStream();
                if (is == null) {
                    return;
                }
                int bufSize = 1024;
                Request req = this.parseRequest(new BufferedInputStream(is, 1024));
                try {
                    Response r = NanoHTTPD.this.serve(req);
                    if (r == null) {
                        this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                    } else {
                        this.sendResponse(r.status, r.mimeType, r.header, r.data);
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, ex.getMessage());
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            catch (InterruptedException ie) {
            }
            catch (Throwable t) {
                try {
                    log.error((Object)t.getMessage(), t);
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: " + t.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }

        private Request parseRequest(BufferedInputStream bis) throws InterruptedException, IOException {
            String requestURI;
            String uriString;
            int qmi;
            StringTokenizer st;
            TreeMap<String, String> headers = new TreeMap<String, String>(new CaseInsensitiveStringComparator());
            LinkedHashMap<String, Vector<String>> params = new LinkedHashMap<String, Vector<String>>();
            String requestLine = this.readLine(bis);
            if (requestLine == null) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, NanoHTTPD.ERR_BAD_REQUEST);
            }
            if (!(st = new StringTokenizer(requestLine)).hasMoreTokens()) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, NanoHTTPD.ERR_BAD_REQUEST);
            }
            String method = st.nextToken();
            if (!st.hasMoreTokens()) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, NanoHTTPD.ERR_BAD_REQUEST);
            }
            if ((qmi = (uriString = (requestURI = st.nextToken())).indexOf(63)) != -1) {
                NanoHTTPD.decodeParams(uriString.substring(qmi + 1), params);
                uriString = NanoHTTPD.decodePercent(uriString.substring(0, qmi));
            } else {
                uriString = NanoHTTPD.decodePercent(uriString);
            }
            String uri = uriString;
            String version = st.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)("method=" + method + ", requestURI=[" + requestURI + "], version=" + version));
            }
            String line = this.readLine(bis);
            while (line != null && line.length() > 0) {
                int p = line.indexOf(58);
                String name = line.substring(0, p).trim();
                String value = line.substring(p + 1).trim();
                headers.put(name, value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("name=[" + name + "], value=[" + value + "]"));
                }
                line = this.readLine(bis);
            }
            String contentType = (String)headers.get(NanoHTTPD.CONTENT_TYPE);
            if (NanoHTTPD.MIME_APPLICATION_URL_ENCODED.equals(contentType)) {
                long size = Long.MAX_VALUE;
                String contentLength = (String)headers.get(NanoHTTPD.CONTENT_LENGTH);
                if (contentLength != null) {
                    try {
                        size = Integer.parseInt(contentLength);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if (size > 0L) {
                    String s;
                    while ((s = this.readLine(bis)) != null) {
                        NanoHTTPD.decodeParams(s, params);
                    }
                }
            }
            return new Request(uri, method, headers, params, bis);
        }

        private String readLine(InputStream is) throws IOException {
            int thisChar;
            this._baos.reset();
            int lastChar = -1;
            int nread = 0;
            while ((thisChar = is.read()) != -1) {
                ++nread;
                this._baos.write(thisChar);
                if (lastChar == 13 && thisChar == 10) {
                    String s = new String(this._baos.toByteArray(), 0, nread -= 2, NanoHTTPD.UTF8);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("[" + s + "]"));
                    }
                    return s;
                }
                lastChar = thisChar;
            }
            if (thisChar == -1 && nread == 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"EOF");
                }
                return null;
            }
            throw new IOException("End of input stream?");
        }

        private void sendError(String status, String msg) throws InterruptedException {
            this.sendResponse(status, NanoHTTPD.MIME_TEXT_PLAIN, null, new ByteArrayInputStream(msg.getBytes()));
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendResponse(String status, String mime, Map<String, String> header, InputStream data) {
            try {
                if (status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("status: [HTTP/1.0 " + status + "]" + (mime == null ? "" : "[Content-Type: " + mime + "]")));
                }
                OutputStream out = this.mySocket.getOutputStream();
                PrintWriter pw = new PrintWriter(out);
                pw.print("HTTP/1.0 ");
                pw.print(status);
                pw.print(" ");
                pw.print(NanoHTTPD.EOL);
                if (mime != null) {
                    pw.print(NanoHTTPD.CONTENT_TYPE);
                    pw.print(": ");
                    pw.print(mime);
                    pw.print(NanoHTTPD.EOL);
                }
                if (header == null || header.get(NanoHTTPD.DATE) == null) {
                    pw.print(NanoHTTPD.DATE);
                    pw.print(": ");
                    pw.print(gmtFrmt.format(new Date()));
                    pw.print(NanoHTTPD.EOL);
                }
                if (header != null) {
                    for (Map.Entry<String, String> e : header.entrySet()) {
                        String key = e.getKey();
                        String value = e.getValue();
                        pw.print(key);
                        pw.print(": ");
                        pw.print(value);
                        pw.print(NanoHTTPD.EOL);
                    }
                }
                pw.print(NanoHTTPD.EOL);
                pw.flush();
                if (data != null) {
                    int read;
                    byte[] buff = new byte[2048];
                    while ((read = data.read(buff, 0, buff.length)) > 0) {
                        out.write(buff, 0, read);
                    }
                }
                out.flush();
                out.close();
            }
            catch (IOException ioe) {
                try {
                    this.mySocket.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                log.error((Object)ioe, (Throwable)ioe);
            }
            finally {
                if (data != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    public static class Response {
        final String status;
        final String mimeType;
        final InputStream data;
        Map<String, String> header = null;

        public Response() {
            this.status = NanoHTTPD.HTTP_OK;
            this.mimeType = null;
            this.data = null;
        }

        public Response(String status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(String status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = new ByteArrayInputStream(txt == null ? new byte[]{} : txt.getBytes());
        }

        public void addHeader(String name, String value) {
            if (this.header == null) {
                this.header = new TreeMap<String, String>(new CaseInsensitiveStringComparator());
            }
            this.header.put(name, value);
        }
    }
}

