/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.zookeeper.HierarchicalZNodeWatcherFlags;
import com.bigdata.zookeeper.UnknownChildrenWatcher;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public abstract class HierarchicalZNodeWatcher
implements Watcher,
HierarchicalZNodeWatcherFlags {
    protected static final Logger log = Logger.getLogger(UnknownChildrenWatcher.class);
    private ZooKeeper zookeeper;
    protected final String zroot;
    private volatile boolean cancelled = false;
    private volatile boolean pumpMockEvents = true;
    public final BlockingQueue<WatchedEvent> queue = new LinkedBlockingQueue<WatchedEvent>();
    private final LinkedHashMap<String, Integer> watched = new LinkedHashMap();

    public HierarchicalZNodeWatcher(ZooKeeper zookeeper, String zroot, int flags) throws InterruptedException, KeeperException {
        this(zookeeper, zroot, flags, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HierarchicalZNodeWatcher(ZooKeeper zookeeper, String zroot, int flags, boolean pumpMockEventsDuringStartup) throws InterruptedException, KeeperException {
        if (zookeeper == null) {
            throw new IllegalArgumentException();
        }
        if (zroot == null) {
            throw new IllegalArgumentException();
        }
        flags |= 5;
        this.zookeeper = zookeeper;
        this.zroot = zroot;
        if (log.isInfoEnabled()) {
            log.info((Object)("zroot=" + zroot + ", flags=" + HierarchicalZNodeWatcher.flagString(flags)));
        }
        this.pumpMockEvents = pumpMockEventsDuringStartup;
        HierarchicalZNodeWatcher hierarchicalZNodeWatcher = this;
        synchronized (hierarchicalZNodeWatcher) {
            if (this.pumpMockEvents) {
                this.placeMockEventInQueue(zroot, flags);
            }
            this.setWatch(zroot, flags);
            this.addedWatch(zroot, flags);
        }
        this.pumpMockEvents = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void process(WatchedEvent event) {
        if (this.cancelled) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)event.toString());
        }
        this.queue.add(event);
        switch (event.getState()) {
            case Disconnected: {
                return;
            }
        }
        String path = event.getPath();
        switch (event.getType()) {
            case NodeCreated: {
                try {
                    this.zookeeper.exists(path, (Watcher)this);
                    return;
                }
                catch (KeeperException e1) {
                    log.error((Object)("path=" + path), (Throwable)e1);
                    return;
                }
                catch (InterruptedException e1) {
                    if (!log.isInfoEnabled()) return;
                    log.info((Object)("path=" + path));
                }
                return;
            }
            case NodeDeleted: {
                if (this.zroot.equals(path)) {
                    try {
                        this.zookeeper.exists(path, (Watcher)this);
                        return;
                    }
                    catch (KeeperException e1) {
                        log.error((Object)("path=" + path), (Throwable)e1);
                        return;
                    }
                    catch (InterruptedException e1) {
                        if (!log.isInfoEnabled()) return;
                        log.info((Object)("path=" + path));
                    }
                    return;
                } else {
                    this.watched.remove(path);
                    this.removedWatch(path);
                }
                return;
            }
            case NodeDataChanged: {
                try {
                    this.zookeeper.getData(path, (Watcher)this, new Stat());
                    return;
                }
                catch (KeeperException e1) {
                    log.error((Object)("path=" + path), (Throwable)e1);
                    return;
                }
                catch (InterruptedException e1) {
                    if (!log.isInfoEnabled()) return;
                    log.info((Object)("path=" + path));
                }
                return;
            }
            case NodeChildrenChanged: {
                try {
                    this.acceptChildren(path, this.zookeeper.getChildren(event.getPath(), (Watcher)this));
                    return;
                }
                catch (KeeperException e) {
                    log.error((Object)this, (Throwable)e);
                    return;
                }
                catch (InterruptedException e1) {
                    if (!log.isInfoEnabled()) return;
                    log.info((Object)("path=" + path));
                }
                return;
            }
        }
    }

    protected void setWatch(String path, int flags) throws KeeperException, InterruptedException {
        block6: {
            if (log.isInfoEnabled()) {
                log.info((Object)("zpath=" + path + ", flags=" + HierarchicalZNodeWatcher.flagString(flags)));
            }
            this.watched.put(path, flags);
            if ((flags & 1) != 0) {
                this.zookeeper.exists(path, (Watcher)this);
            }
            if ((flags & 2) != 0) {
                this.zookeeper.getData(path, (Watcher)this, new Stat());
            }
            if ((flags & 4) != 0) {
                try {
                    this.acceptChildren(path, this.zookeeper.getChildren(path, (Watcher)this));
                }
                catch (KeeperException.NoNodeException ex) {
                    if (!log.isInfoEnabled()) break block6;
                    log.info((Object)("No children: " + path));
                }
            }
        }
    }

    public synchronized boolean isWatched(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        return this.watched.containsKey(path);
    }

    public synchronized int getFlags(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Integer flags = this.watched.get(path);
        if (flags == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("path=" + path + " : Not watched"));
            }
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("path=" + path + " : " + HierarchicalZNodeWatcher.flagString(flags)));
        }
        return flags;
    }

    public synchronized String[] getWatchedNodes() {
        return this.watched.keySet().toArray(new String[0]);
    }

    private void clearWatch(String path, int flags) throws KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("zpath=" + path + ", flags=" + HierarchicalZNodeWatcher.flagString(flags)));
        }
        if ((flags & 1) != 0) {
            this.zookeeper.exists(path, false);
        }
        if ((flags & 2) != 0) {
            this.zookeeper.getData(path, false, new Stat());
        }
        if ((flags & 4) != 0) {
            this.zookeeper.getChildren(path, false);
        }
        this.removedWatch(path);
    }

    private void acceptChildren(String path, List<String> children) throws KeeperException, InterruptedException {
        for (String child : children) {
            String zpath = path + "/" + child;
            if (this.isWatched(zpath)) continue;
            int flags = this.watch(path, child);
            if (log.isInfoEnabled()) {
                log.info((Object)("watch? " + zpath + " : flags=" + HierarchicalZNodeWatcher.flagString(flags)));
            }
            if (flags == 0) continue;
            if (this.pumpMockEvents) {
                this.placeMockEventInQueue(zpath, flags);
            }
            this.setWatch(zpath, flags);
            this.addedWatch(zpath, flags);
        }
    }

    protected void addedWatch(String zpath, int flags) {
    }

    protected void placeMockEventInQueue(String path, int flags) {
        if (!this.pumpMockEvents) {
            throw new IllegalStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("path=" + path + ", flags=" + HierarchicalZNodeWatcher.flagString(flags)));
        }
        if ((flags & 1) != 0) {
            this.queue.add(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.Unknown, path));
        }
        if ((flags & 2) != 0) {
            this.queue.add(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.Unknown, path));
        }
        if ((flags & 4) != 0) {
            this.queue.add(new MockWatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.Unknown, path));
        }
    }

    protected void removedWatch(String zpath) {
    }

    protected abstract int watch(String var1, String var2);

    public synchronized void cancel() throws InterruptedException {
        this.cancelled = true;
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancelling watches: #watched=" + this.watched.size()));
        }
        Iterator<Map.Entry<String, Integer>> itr = this.watched.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Integer> entry = itr.next();
            String path = entry.getKey();
            int flags = entry.getValue();
            try {
                this.clearWatch(path, flags);
            }
            catch (KeeperException.ConnectionLossException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("path=" + path + " : " + (Object)((Object)e)));
                }
            }
            catch (KeeperException.SessionExpiredException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("path=" + path + " : " + (Object)((Object)e)));
                }
            }
            catch (KeeperException e) {
                log.error((Object)("path=" + path + " : " + (Object)((Object)e)));
            }
            itr.remove();
        }
    }

    public String toString() {
        return this.getClass().getName() + "{zroot=" + this.zroot + ", watchedSize=" + this.getWatchedSize() + "}";
    }

    public int getWatchedSize() {
        return this.watched.size();
    }

    public static String flagString(int flags) {
        StringBuilder sb = new StringBuilder();
        int onCount = 0;
        sb.append("[");
        if ((flags & 1) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("EXISTS");
        }
        if ((flags & 2) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("DATA");
        }
        if ((flags & 4) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("CHILDREN");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class MockWatchedEvent
    extends WatchedEvent {
        public MockWatchedEvent(Watcher.Event.EventType eventType, Watcher.Event.KeeperState keeperState, String path) {
            super(eventType, keeperState, path);
        }
    }
}

