/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class UnknownChildrenWatcher
implements Watcher {
    protected static final Logger log = Logger.getLogger(UnknownChildrenWatcher.class);
    private final ZooKeeper zookeeper;
    private final String zpath;
    private boolean cancelled = false;
    private final LinkedHashSet<String> known = new LinkedHashSet();
    public final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    public UnknownChildrenWatcher(ZooKeeper zookeeper, String zpath) throws KeeperException, InterruptedException {
        if (zookeeper == null) {
            throw new IllegalArgumentException();
        }
        if (zpath == null) {
            throw new IllegalArgumentException();
        }
        this.zookeeper = zookeeper;
        this.zpath = zpath;
        if (log.isInfoEnabled()) {
            log.info((Object)("watching: " + zpath));
        }
        while (true) {
            try {
                this.acceptChildren(zookeeper.getChildren(zpath, (Watcher)this));
            }
            catch (InterruptedException t) {
                this.cancelled = true;
                throw t;
            }
            catch (Throwable t) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("will retry: " + this + " : " + t));
                }
                Thread.sleep(500L);
                continue;
            }
            break;
        }
    }

    public synchronized void process(WatchedEvent event) {
        if (this.cancelled) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)event.toString());
        }
        switch (event.getState()) {
            case Disconnected: {
                return;
            }
        }
        switch (event.getType()) {
            case NodeChildrenChanged: {
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.acceptChildren(this.zookeeper.getChildren(this.zpath, (Watcher)this));
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            return;
        }
    }

    private void acceptChildren(List<String> children) {
        int nadded = 0;
        for (String child : children) {
            if (this.known.contains(child)) continue;
            this.known.add(child);
            this.queue.add(child);
            ++nadded;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("added " + nadded + " : known=" + this.known.size()));
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
        try {
            this.zookeeper.getChildren(this.zpath, false);
        }
        catch (KeeperException.SessionExpiredException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.toString() + ":" + (Object)((Object)ex)));
            }
        }
        catch (KeeperException.ConnectionLossException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.toString() + ":" + (Object)((Object)ex)));
            }
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int knownSize;
        UnknownChildrenWatcher unknownChildrenWatcher = this;
        synchronized (unknownChildrenWatcher) {
            knownSize = this.known.size();
        }
        return this.getClass().getName() + "{zpath=" + this.zpath + ", queueSize=" + this.queue.size() + ", knownSize=" + knownSize + "}";
    }
}

