/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.zookeeper.ZLock;
import com.bigdata.zookeeper.ZLockNodeInvalidatedException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class ZLockImpl
implements ZLock {
    protected static final Logger log = Logger.getLogger(ZLockImpl.class);
    public static final transient String INVALID = "_INVALID";
    private static final transient String ERR_INTERRUPT_IN_EVENT_THREAD = "Interrupt in event thread";
    private final ZooKeeper zookeeper;
    protected final String zpath;
    protected final List<ACL> acl;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile ZLockWatcher watcher = null;

    public static ZLockImpl getLock(ZooKeeper zookeeper, String zpath, List<ACL> acl) {
        return new ZLockImpl(zookeeper, zpath, acl);
    }

    public ZooKeeper getZooKeeper() {
        return this.zookeeper;
    }

    public String toString() {
        ZLockWatcher w = this.watcher;
        return "ZLock{ zpath=" + this.zpath + (w == null ? "" : w.toString()) + "}";
    }

    public final String getZPath() {
        return this.zpath;
    }

    protected ZLockImpl(ZooKeeper zookeeper, String zpath, List<ACL> acl) {
        if (zookeeper == null) {
            throw new IllegalArgumentException();
        }
        if (zpath == null) {
            throw new IllegalArgumentException();
        }
        if (acl == null) {
            throw new IllegalArgumentException();
        }
        this.zookeeper = zookeeper;
        this.zpath = zpath;
        this.acl = acl;
    }

    private void validateLockNode() throws InterruptedException, KeeperException {
        if (this.zookeeper.exists(this.zpath + INVALID, false) != null) {
            throw new ZLockNodeInvalidatedException(this.zpath);
        }
        try {
            this.zookeeper.create(this.zpath, new byte[0], this.acl, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockRequestZNode() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            String string = this.watcher == null ? null : this.watcher.zchild;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLockHeld() throws InterruptedException, KeeperException {
        this.lock.lockInterruptibly();
        try {
            if (this.watcher != null && this.watcher.expired) {
                log.error((Object)"Caller's ZooKeeper session has expired.");
                throw new KeeperException.SessionExpiredException();
            }
            if (this.watcher == null || !this.watcher.zlockGranted || this.watcher.cancelled) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Caller does not hold lock.");
                }
                boolean bl = false;
                return bl;
            }
            if (!this.watcher.isConditionSatisified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Caller does not hold lock.");
                }
                boolean bl = false;
                return bl;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Caller holds lock.");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void lock() throws KeeperException, InterruptedException {
        try {
            this.lock(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void lock(long timeout, TimeUnit unit) throws KeeperException, InterruptedException, TimeoutException {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.toString());
        }
        this.lock.lockInterruptibly();
        try {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = unit.toNanos(timeout);
            this.validateLockNode();
            String s = this.zookeeper.create(this.zpath + "/lock", new byte[0], this.acl, CreateMode.EPHEMERAL_SEQUENTIAL);
            String zchild = s.substring(s.lastIndexOf(47) + 1);
            if (log.isInfoEnabled()) {
                log.info((Object)("Seeking lock: zpath=" + this.zpath + ", zchild=" + zchild));
            }
            this.watcher = new ZLockWatcher(zchild);
            remaining = nanos - (System.nanoTime() - begin);
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will await zlock: " + this));
                }
                if (!this.watcher.awaitZLockNanos(remaining)) {
                    throw new TimeoutException();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("ZLock granted: zpath=" + this.zpath + ", zchild=" + zchild));
                }
                return;
            }
            catch (Throwable t) {
                try {
                    if (!this.watcher.knownDeleted) {
                        this.zookeeper.delete(this.zpath + "/" + zchild, -1);
                        this.watcher.knownDeleted = true;
                    }
                }
                catch (KeeperException.NoNodeException ex) {
                    this.watcher.knownDeleted = true;
                }
                catch (Throwable t2) {
                    log.warn((Object)("Problem deleting our child: zpath=" + this.zpath + ", zchild=" + zchild), t2);
                }
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                if (t instanceof TimeoutException) {
                    throw (TimeoutException)t;
                }
                if (t instanceof KeeperException) {
                    throw (KeeperException)t;
                }
                throw new RuntimeException(t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() throws KeeperException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.watcher == null) {
                throw new IllegalStateException("Lock not held.");
            }
            if (this.watcher.expired) {
                log.warn((Object)"Lock has been asynchronously cancelled (session expired)");
                return;
            }
            if (this.watcher.cancelled) {
                log.warn((Object)"Lock has been asynchronously cancelled.");
            }
            ZLockWatcher watcher = this.watcher;
            this.watcher = null;
            watcher.cancelled = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)this.toString());
            }
            String zchild = watcher.zchild;
            try {
                this.zookeeper.delete(this.zpath + "/" + zchild, -1);
                watcher.knownDeleted = true;
                if (log.isInfoEnabled()) {
                    log.info((Object)("released lock: " + watcher));
                }
            }
            catch (KeeperException.NoNodeException ex) {
                log.warn((Object)("Child already deleted: zpath=" + this.zpath + ", child=" + zchild));
                watcher.knownDeleted = true;
            }
            catch (KeeperException.SessionExpiredException ex) {
                log.warn((Object)("Session expired: zpath=" + this.zpath + ", child=" + zchild + " : " + (Object)((Object)ex)));
                watcher.knownDeleted = true;
            }
            catch (KeeperException.ConnectionLossException ex) {
                log.warn((Object)("Not connected: zpath=" + this.zpath + ", child=" + zchild + " : " + (Object)((Object)ex)));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyLock() throws KeeperException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (!this.isLockHeld()) {
                throw new IllegalStateException("Lock not held.");
            }
            boolean markerZNodeExists = false;
            try {
                this.zookeeper.create(this.zpath + INVALID, new byte[0], this.acl, CreateMode.EPHEMERAL);
                markerZNodeExists = true;
                boolean queueEmpty = false;
                while (!queueEmpty) {
                    try {
                        List children = this.zookeeper.getChildren(this.zpath, false);
                        queueEmpty = children.isEmpty();
                        if (queueEmpty) break;
                        Object[] a = children.toArray(new String[0]);
                        Arrays.sort(a);
                        for (int i = a.length - 1; i >= 0; --i) {
                            Object child = a[i];
                            try {
                                this.zookeeper.delete(this.zpath + "/" + (String)child, -1);
                                continue;
                            }
                            catch (KeeperException.NoNodeException ex) {
                                // empty catch block
                            }
                        }
                    }
                    catch (KeeperException.ConnectionLossException ex) {
                        Thread.sleep(100L);
                    }
                }
                while (true) {
                    try {
                        this.zookeeper.delete(this.zpath, -1);
                    }
                    catch (KeeperException.NoNodeException ex) {
                    }
                    catch (KeeperException.ConnectionLossException ex) {
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            finally {
                while (markerZNodeExists) {
                    try {
                        this.zookeeper.delete(this.zpath + INVALID, -1);
                        markerZNodeExists = false;
                    }
                    catch (KeeperException.NoNodeException ex) {
                        markerZNodeExists = false;
                    }
                    catch (KeeperException.SessionExpiredException ex) {
                        markerZNodeExists = false;
                        log.error((Object)("While trying to delete marker znode: " + this), (Throwable)ex);
                    }
                    catch (KeeperException.ConnectionLossException ex) {
                        log.warn((Object)("While trying to delete marker znode: " + this), (Throwable)ex);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException t) {
                            log.error((Object)("Giving up: will not delete marker znode" + this), (Throwable)t);
                            break;
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)("Giving up: will not delete marker znode" + this), t);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String[] getQueue() throws KeeperException, InterruptedException {
        List children = this.zookeeper.getChildren(this.zpath, false);
        Object[] a = children.toArray(new String[0]);
        Arrays.sort(a);
        return a;
    }

    protected class ZLockWatcher
    implements Watcher {
        private final String zchild;
        private volatile String priorChildZNode = null;
        private final Condition zlock = ZLockImpl.access$000(ZLockImpl.this).newCondition();
        private volatile boolean zlockGranted = false;
        private volatile boolean cancelled = false;
        private volatile boolean knownDeleted = false;
        private volatile boolean disconnected = false;
        private volatile boolean expired = false;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append("{ zpath=" + ZLockImpl.this.zpath);
            sb.append(", conditionSatisified=" + this.zlockGranted);
            sb.append(", disconnected=" + this.disconnected);
            sb.append(", expired=" + this.expired);
            sb.append(", knownDeleted=" + this.knownDeleted);
            sb.append(", cancelled=" + this.cancelled);
            sb.append(", zchild=" + this.zchild);
            sb.append(", priorChild=" + this.priorChildZNode);
            sb.append("}");
            return sb.toString();
        }

        protected ZLockWatcher(String zchild) {
            if (zchild == null) {
                throw new IllegalArgumentException();
            }
            this.zchild = zchild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (log.isInfoEnabled()) {
                log.info((Object)event.toString());
            }
            switch (event.getState()) {
                case Expired: {
                    this.expired = true;
                    this.disconnected = true;
                    this.knownDeleted = true;
                    this.cancelled = true;
                    log.error((Object)("Session expired: " + event + " : zxid=" + Long.toHexString(ZLockImpl.this.zookeeper.getSessionId()) + ", zpath=" + ZLockImpl.this.zpath));
                    return;
                }
                case Disconnected: {
                    this.disconnected = true;
                    return;
                }
                case NoSyncConnected: 
                case SyncConnected: {
                    if (!this.disconnected) break;
                    this.disconnected = false;
                    if (!log.isInfoEnabled()) break;
                    log.info((Object)("Reconnect: " + this));
                }
            }
            if (this.disconnected) {
                return;
            }
            if (this.cancelled) {
                if (!this.knownDeleted) {
                    try {
                        ZLockImpl.this.zookeeper.delete(ZLockImpl.this.zpath + "/" + this.zchild, -1);
                        this.knownDeleted = true;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("released lock: " + this));
                        }
                    }
                    catch (KeeperException.NoNodeException ex) {
                        this.knownDeleted = true;
                    }
                    catch (KeeperException ex) {
                        log.warn((Object)this, (Throwable)ex);
                    }
                    catch (InterruptedException ex) {
                        log.warn((Object)("Interrupt in event thread : " + this));
                    }
                }
                return;
            }
            try {
                ZLockImpl.this.lock.lockInterruptibly();
            }
            catch (InterruptedException ex) {
                this.cancelled = true;
                log.warn((Object)("Interrupt in event thread : " + this));
                return;
            }
            try {
                if (this.isConditionSatisified()) {
                    this.zlockGranted = true;
                    this.zlock.signal();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"ZLock granted.");
                    }
                    return;
                }
                if (this.cancelled) {
                    this.zlock.signal();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"ZLock request cancelled.");
                    }
                    return;
                }
            }
            catch (KeeperException e) {
                log.warn((Object)this, (Throwable)e);
                return;
            }
            catch (InterruptedException e) {
                this.cancelled = true;
                log.warn((Object)("Interrupt in event thread : " + this));
                return;
            }
            finally {
                ZLockImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean awaitZLockNanos(long nanos) throws InterruptedException, KeeperException.SessionExpiredException {
            long begin = System.nanoTime();
            long remaining = nanos;
            ZLockImpl.this.lock.lockInterruptibly();
            try {
                while ((remaining = nanos - (System.nanoTime() - begin)) > 0L && !this.zlockGranted && !this.cancelled) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("remaining=" + TimeUnit.NANOSECONDS.toMillis(remaining) + "ms"));
                    }
                    try {
                        if (this.isConditionSatisified()) {
                            this.zlockGranted = true;
                            if (!log.isDebugEnabled()) break;
                            log.debug((Object)"Condition satisified.");
                            break;
                        }
                    }
                    catch (KeeperException.SessionExpiredException ex) {
                        throw ex;
                    }
                    catch (KeeperException ex) {
                        log.warn((Object)this, (Throwable)ex);
                    }
                    remaining = nanos - (System.nanoTime() - begin);
                    this.zlock.awaitNanos(remaining);
                }
                if (this.cancelled) {
                    throw new InterruptedException();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("nanos remaining=" + remaining));
                }
                boolean bl = remaining > 0L;
                return bl;
            }
            finally {
                ZLockImpl.this.lock.unlock();
            }
        }

        protected boolean isConditionSatisified() throws KeeperException, InterruptedException {
            List<Object> children;
            if (this.cancelled) {
                return true;
            }
            if (ZLockImpl.this.zookeeper.exists(ZLockImpl.this.zpath + ZLockImpl.INVALID, (Watcher)this) != null) {
                this.cancelled = true;
                this.priorChildZNode = null;
                log.warn((Object)("Lock node invalidated: " + this));
                return false;
            }
            if (this.zlockGranted) {
                if (ZLockImpl.this.zookeeper.exists(ZLockImpl.this.zpath + "/" + this.zchild, (Watcher)this) == null) {
                    this.cancelled = true;
                    log.warn((Object)("Lost zlock: " + this));
                    return false;
                }
                return true;
            }
            try {
                Object[] a = ZLockImpl.this.zookeeper.getChildren(ZLockImpl.this.zpath, false).toArray(new String[0]);
                Arrays.sort(a);
                children = Arrays.asList(a);
            }
            catch (KeeperException.NoNodeException ex) {
                this.cancelled = true;
                this.priorChildZNode = null;
                log.warn((Object)("Lock node destroyed: " + this));
                return true;
            }
            int pos = children.indexOf(this.zchild);
            if (pos == -1) {
                this.cancelled = true;
                this.priorChildZNode = null;
                log.warn((Object)("Watch cancelled (child not in queue): " + this));
                return true;
            }
            if (pos == 0) {
                this.priorChildZNode = null;
                if (log.isInfoEnabled()) {
                    log.info((Object)("ZLock granted: " + this));
                }
                return true;
            }
            this.priorChildZNode = (String)children.get(pos - 1);
            if (ZLockImpl.this.zookeeper.exists(ZLockImpl.this.zpath + "/" + this.priorChildZNode, (Watcher)this) == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Prior child was asynchronously deleted: " + this));
                }
                return this.isConditionSatisified();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Process in queue: pos=" + pos + " out of " + children.size() + " children, " + this + (log.isDebugEnabled() ? " : children=" + children.toString() : "")));
            }
            return false;
        }
    }
}

