/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperAccessor {
    private static final Logger log = Logger.getLogger(ZooKeeperAccessor.class);
    private volatile ZooKeeper zookeeper;
    public final String hosts;
    public final int sessionTimeout;
    private volatile boolean open = true;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition event = this.lock.newCondition();
    private final CopyOnWriteArrayList<Watcher> watchers = new CopyOnWriteArrayList();

    public ZooKeeperAccessor(String hosts, int sessionTimeout) throws InterruptedException {
        if (hosts == null) {
            throw new IllegalArgumentException();
        }
        this.hosts = hosts;
        this.sessionTimeout = sessionTimeout;
        this.getZookeeper();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public synchronized ZooKeeper getZookeeper() throws InterruptedException {
        try {
            return new AwaitConnectedTask().call();
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ZooKeeper getZookeeperNoBlock() {
        return this.zookeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws InterruptedException {
        if (!this.open) {
            return;
        }
        this.lock.lockInterruptibly();
        try {
            if (this.zookeeper != null) {
                this.zookeeper.close();
                this.zookeeper = null;
            }
            this.open = false;
            this.event.signalAll();
            log.warn((Object)"Closed.");
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitZookeeperConnected(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos;
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        ZooKeeper.States state = null;
        block7: while ((remaining = nanos - (System.nanoTime() - begin)) > 0L) {
            state = this.getZookeeper().getState();
            switch (state) {
                case CONNECTED: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("connected: elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin)));
                    }
                    return true;
                }
                case AUTH_FAILED: {
                    log.error((Object)"Zookeeper authorization failure.");
                    continue block7;
                }
            }
            this.lock.lockInterruptibly();
            try {
                remaining = nanos - (System.nanoTime() - begin);
                this.event.awaitNanos(remaining);
            }
            finally {
                this.lock.unlock();
            }
        }
        long elapsed = System.nanoTime() - begin;
        log.warn((Object)("Zookeeper: not connected: state=" + state + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed)));
        return false;
    }

    public void addWatcher(Watcher w) {
        if (w == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("watcher=" + w));
        }
        this.watchers.add(w);
    }

    public void removeWatcher(Watcher w) {
        if (w == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("watcher=" + w));
        }
        this.watchers.remove(w);
    }

    static /* synthetic */ CopyOnWriteArrayList access$700(ZooKeeperAccessor x0) {
        return x0.watchers;
    }

    private class ZooAliveWatcher
    implements Watcher {
        private boolean connected = false;

        private ZooAliveWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void process(WatchedEvent e) {
            System.err.println("event: " + e);
            if (!ZooKeeperAccessor.access$100(ZooKeeperAccessor.this)) {
                return;
            }
            if (ZooKeeperAccessor.access$400().isInfoEnabled()) {
                ZooKeeperAccessor.access$400().info((Object)e.toString());
            }
            ZooKeeperAccessor.access$200(ZooKeeperAccessor.this).lock();
            try {
                if (!ZooKeeperAccessor.access$100(ZooKeeperAccessor.this)) {
                    return;
                }
                switch (1.$SwitchMap$org$apache$zookeeper$Watcher$Event$KeeperState[e.getState().ordinal()]) {
                    case 1: {
                        ZooKeeperAccessor.access$400().warn((Object)e);
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        if (!this.connected) ** break;
                        this.connected = false;
                        ZooKeeperAccessor.access$600(ZooKeeperAccessor.this).signalAll();
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    case 3: 
                    case 4: {
                        if (this.connected) ** break;
                        this.connected = true;
                        ZooKeeperAccessor.access$600(ZooKeeperAccessor.this).signalAll();
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        ZooKeeperAccessor.access$302(ZooKeeperAccessor.this, null);
                        ZooKeeperAccessor.access$600(ZooKeeperAccessor.this).signalAll();
                        break;
                    }
                    ** default:
lbl33:
                    // 1 sources

                    break;
                }
            }
            finally {
                ZooKeeperAccessor.access$200(ZooKeeperAccessor.this).unlock();
            }
            for (Watcher w : ZooKeeperAccessor.access$700(ZooKeeperAccessor.this)) {
                System.err.println("send event: " + e);
                w.process(e);
            }
        }
    }

    private class AwaitConnectedTask
    implements Callable<ZooKeeper> {
        private AwaitConnectedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZooKeeper call() throws Exception {
            long begin = System.nanoTime();
            int ntries = 1;
            while (true) {
                if (!ZooKeeperAccessor.this.open) {
                    throw new IllegalStateException("Closed");
                }
                ZooKeeperAccessor.this.lock.lockInterruptibly();
                try {
                    if (ZooKeeperAccessor.this.zookeeper != null && ZooKeeperAccessor.this.zookeeper.getState().isAlive()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("success: ntries=" + ntries + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin)));
                        }
                        ZooKeeper zooKeeper = ZooKeeperAccessor.this.zookeeper;
                        return zooKeeper;
                    }
                    try {
                        log.warn((Object)"Creating new client");
                        ZooKeeperAccessor.this.zookeeper = new ZooKeeper(ZooKeeperAccessor.this.hosts, ZooKeeperAccessor.this.sessionTimeout, (Watcher)new ZooAliveWatcher());
                        ZooKeeperAccessor.this.event.signalAll();
                    }
                    catch (IOException ex) {
                        log.error((Object)("Could not connect: ntries=" + ntries), (Throwable)ex);
                        ++ntries;
                    }
                }
                finally {
                    ZooKeeperAccessor.this.lock.unlock();
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Waking up with interrupt.");
                    continue;
                }
                break;
            }
        }
    }
}

