/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;

public class IndexTestSuite
extends TestSuite {
    public IndexTestSuite() {
    }

    public IndexTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testPutGetRemoveVertex() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue()) {
            this.stopWatch();
            Index index = graph.createIndex("basic", Vertex.class, new Parameter[0]);
            IndexTestSuite.printPerformance(graph.toString(), 1, "manual index created", this.stopWatch());
            Vertex v1 = graph.addVertex(null);
            Vertex v2 = graph.addVertex(null);
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                IndexTestSuite.assertEquals((int)IndexTestSuite.count(graph.getVertices()), (int)2);
            }
            this.stopWatch();
            index.put("dog", (Object)"puppy", (Element)v1);
            index.put("dog", (Object)"mama", (Element)v2);
            IndexTestSuite.printPerformance(graph.toString(), 2, "vertices manually index", this.stopWatch());
            IndexTestSuite.assertEquals((Object)v1, index.get("dog", (Object)"puppy").iterator().next());
            IndexTestSuite.assertEquals((Object)v2, index.get("dog", (Object)"mama").iterator().next());
            IndexTestSuite.assertEquals((long)1L, (long)index.count("dog", (Object)"puppy"));
            v1.removeProperty("dog");
            IndexTestSuite.assertEquals((Object)v1, index.get("dog", (Object)"puppy").iterator().next());
            IndexTestSuite.assertEquals((Object)v2, index.get("dog", (Object)"mama").iterator().next());
            this.stopWatch();
            graph.removeVertex(v1);
            IndexTestSuite.printPerformance(graph.toString(), 1, "vertex removed and automatically removed from index", this.stopWatch());
            IndexTestSuite.assertEquals((int)IndexTestSuite.count(index.get("dog", (Object)"puppy")), (int)0);
            IndexTestSuite.assertEquals((Object)v2, index.get("dog", (Object)"mama").iterator().next());
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                IndexTestSuite.assertEquals((int)IndexTestSuite.count(graph.getVertices()), (int)1);
            }
            v2.setProperty("dog", (Object)"mama2");
            IndexTestSuite.assertEquals((Object)v2, index.get("dog", (Object)"mama").iterator().next());
            this.stopWatch();
            graph.removeVertex(v2);
            IndexTestSuite.printPerformance(graph.toString(), 1, "vertex removed and automatically removed from index", this.stopWatch());
            IndexTestSuite.assertEquals((int)IndexTestSuite.count(index.get("dog", (Object)"puppy")), (int)0);
            IndexTestSuite.assertEquals((int)IndexTestSuite.count(index.get("dog", (Object)"mama")), (int)0);
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                IndexTestSuite.assertEquals((int)IndexTestSuite.count(graph.getVertices()), (int)0);
            }
        }
        graph.shutdown();
    }

    public void testIndexCount() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue()) {
            Index index = graph.createIndex("basic", Vertex.class, new Parameter[0]);
            for (int i = 0; i < 10; ++i) {
                Vertex v = graph.addVertex(null);
                index.put("dog", (Object)"puppy", (Element)v);
            }
            IndexTestSuite.assertEquals((long)10L, (long)index.count("dog", (Object)"puppy"));
            Vertex v = (Vertex)index.get("dog", (Object)"puppy").iterator().next();
            graph.removeVertex(v);
            index.remove("dog", (Object)"puppy", (Element)v);
            IndexTestSuite.assertEquals((long)9L, (long)index.count("dog", (Object)"puppy"));
        }
        graph.shutdown();
    }

    public void testPutGetRemoveEdge() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIndex.booleanValue()) {
            this.stopWatch();
            Index index = graph.createIndex("basic", Edge.class, new Parameter[0]);
            IndexTestSuite.printPerformance(graph.toString(), 1, "manual index created", this.stopWatch());
            Vertex v1 = graph.addVertex(null);
            Vertex v2 = graph.addVertex(null);
            Edge e1 = graph.addEdge(null, v1, v2, "test1");
            Edge e2 = graph.addEdge(null, v1, v2, "test2");
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                IndexTestSuite.assertEquals((int)IndexTestSuite.count(graph.getEdges()), (int)2);
            }
            this.stopWatch();
            index.put("dog", (Object)"puppy", (Element)e1);
            index.put("dog", (Object)"mama", (Element)e2);
            IndexTestSuite.printPerformance(graph.toString(), 2, "edges manually index", this.stopWatch());
            IndexTestSuite.assertEquals((Object)e1, index.get("dog", (Object)"puppy").iterator().next());
            IndexTestSuite.assertEquals((Object)e2, index.get("dog", (Object)"mama").iterator().next());
            v1.removeProperty("dog");
            IndexTestSuite.assertEquals((Object)e1, index.get("dog", (Object)"puppy").iterator().next());
            IndexTestSuite.assertEquals((Object)e2, index.get("dog", (Object)"mama").iterator().next());
            this.stopWatch();
            graph.removeEdge(e1);
            IndexTestSuite.printPerformance(graph.toString(), 1, "edge removed and automatically removed from index", this.stopWatch());
            IndexTestSuite.assertEquals((int)IndexTestSuite.count(index.get("dog", (Object)"puppy")), (int)0);
            IndexTestSuite.assertEquals((Object)e2, index.get("dog", (Object)"mama").iterator().next());
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                IndexTestSuite.assertEquals((int)IndexTestSuite.count(graph.getEdges()), (int)1);
            }
            v2.setProperty("dog", (Object)"mama2");
            IndexTestSuite.assertEquals((Object)e2, index.get("dog", (Object)"mama").iterator().next());
            this.stopWatch();
            graph.removeEdge(e2);
            IndexTestSuite.printPerformance(graph.toString(), 1, "edge removed and automatically removed from index", this.stopWatch());
            IndexTestSuite.assertEquals((int)IndexTestSuite.count(index.get("dog", (Object)"puppy")), (int)0);
            IndexTestSuite.assertEquals((int)IndexTestSuite.count(index.get("dog", (Object)"mama")), (int)0);
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                IndexTestSuite.assertEquals((int)IndexTestSuite.count(graph.getEdges()), (int)0);
            }
        }
        graph.shutdown();
    }

    public void testCloseableSequence() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue()) {
            Index index = graph.createIndex("basic", Vertex.class, new Parameter[0]);
            for (int i = 0; i < 10; ++i) {
                Vertex v = graph.addVertex(null);
                index.put("dog", (Object)"puppy", (Element)v);
            }
            CloseableIterable hits = index.get("dog", (Object)"puppy");
            int counter = 0;
            for (Vertex v : hits) {
                ++counter;
            }
            IndexTestSuite.assertEquals((int)counter, (int)10);
            hits.close();
        }
        graph.shutdown();
    }
}

