/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import java.util.HashSet;

public class IndexableGraphTestSuite
extends TestSuite {
    public IndexableGraphTestSuite() {
    }

    public IndexableGraphTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testNoIndicesOnStartup() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue()) {
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
            graph.createIndex("myIdx", Vertex.class, new Parameter[0]);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)1);
            Iterable idx = graph.getIndices();
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(idx), (int)1);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(idx), (int)1);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(idx), (int)1);
        }
        graph.shutdown();
    }

    public void testKeyIndicesAreNotIndices() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
        if (!graph.getFeatures().isWrapper.booleanValue() && graph.getFeatures().supportsKeyIndices.booleanValue() && graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
            ((KeyIndexableGraph)graph).createKeyIndex("name", Vertex.class, new Parameter[0]);
            ((KeyIndexableGraph)graph).createKeyIndex("age", Vertex.class, new Parameter[0]);
            IndexableGraphTestSuite.assertEquals((int)((KeyIndexableGraph)graph).getIndexedKeys(Vertex.class).size(), (int)2);
        }
        if (!graph.getFeatures().isWrapper.booleanValue() && graph.getFeatures().supportsKeyIndices.booleanValue() && graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
            ((KeyIndexableGraph)graph).createKeyIndex("weight", Edge.class, new Parameter[0]);
            ((KeyIndexableGraph)graph).createKeyIndex("since", Edge.class, new Parameter[0]);
            IndexableGraphTestSuite.assertEquals((int)((KeyIndexableGraph)graph).getIndexedKeys(Edge.class).size(), (int)2);
        }
        IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
        graph.shutdown();
    }

    public void testCreateDropIndices() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue() && graph.getFeatures().supportsIndices.booleanValue()) {
            int i;
            this.stopWatch();
            for (i = 0; i < 10; ++i) {
                graph.createIndex(i + "blah", Vertex.class, new Parameter[0]);
            }
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)10);
            for (i = 0; i < 10; ++i) {
                graph.dropIndex(i + "blah");
            }
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
            IndexableGraphTestSuite.printPerformance(graph.toString(), 10, "indices created and then dropped", this.stopWatch());
            this.stopWatch();
            Index index1 = graph.createIndex("index1", Vertex.class, new Parameter[0]);
            Index index2 = graph.createIndex("index2", Vertex.class, new Parameter[0]);
            IndexableGraphTestSuite.printPerformance(graph.toString(), 2, "indices created", this.stopWatch());
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)2);
            IndexableGraphTestSuite.assertEquals((String)graph.getIndex("index1", Vertex.class).getIndexName(), (String)"index1");
            IndexableGraphTestSuite.assertEquals((String)graph.getIndex("index2", Vertex.class).getIndexName(), (String)"index2");
            IndexableGraphTestSuite.assertEquals((Object)graph.getIndex("index1", Vertex.class).getIndexClass(), Vertex.class);
            IndexableGraphTestSuite.assertEquals((Object)graph.getIndex("index2", Vertex.class).getIndexClass(), Vertex.class);
            try {
                IndexableGraphTestSuite.assertEquals((Object)graph.getIndex("index1", Edge.class).getIndexClass(), Edge.class);
                IndexableGraphTestSuite.assertFalse((boolean)true);
            }
            catch (RuntimeException e) {
                IndexableGraphTestSuite.assertTrue((boolean)true);
            }
            this.stopWatch();
            graph.dropIndex(index1.getIndexName());
            IndexableGraphTestSuite.assertNull((Object)graph.getIndex("index1", Vertex.class));
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)1);
            for (Index index : graph.getIndices()) {
                IndexableGraphTestSuite.assertEquals((String)index.getIndexName(), (String)index2.getIndexName());
            }
            graph.dropIndex(index2.getIndexName());
            IndexableGraphTestSuite.assertNull((Object)graph.getIndex("index1", Vertex.class));
            IndexableGraphTestSuite.assertNull((Object)graph.getIndex("index2", Vertex.class));
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
            IndexableGraphTestSuite.printPerformance(graph.toString(), 2, "indices dropped and index iterable checked for consistency", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testNonExistentIndices() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue() && graph.getFeatures().supportsEdgeIndex.booleanValue() && graph.getFeatures().supportsIndices.booleanValue()) {
            this.stopWatch();
            IndexableGraphTestSuite.assertNull((Object)graph.getIndex("bloop", Vertex.class));
            IndexableGraphTestSuite.assertNull((Object)graph.getIndex("bam", Edge.class));
            IndexableGraphTestSuite.assertNull((Object)graph.getIndex("blah blah", Edge.class));
            IndexableGraphTestSuite.printPerformance(graph.toString(), 3, "non-existent indices retrieved", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testIndexPersistence() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().isPersistent.booleanValue() && graph.getFeatures().supportsVertexIndex.booleanValue() && graph.getFeatures().supportsElementProperties() && graph.getFeatures().supportsIndices.booleanValue()) {
            this.stopWatch();
            graph.createIndex("testIndex", Vertex.class, new Parameter[0]);
            Index manualIndex = graph.getIndex("testIndex", Vertex.class);
            IndexableGraphTestSuite.assertEquals((String)manualIndex.getIndexName(), (String)"testIndex");
            Vertex vertex = graph.addVertex(null);
            vertex.setProperty("name", (Object)"marko");
            Object id = vertex.getId();
            manualIndex.put("key", (Object)"value", (Element)vertex);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(manualIndex.get("key", (Object)"value")), (int)1);
            IndexableGraphTestSuite.assertEquals((Object)((Vertex)manualIndex.get("key", (Object)"value").iterator().next()).getId(), (Object)id);
            IndexableGraphTestSuite.printPerformance(graph.toString(), 1, "index created and 1 vertex added and checked", this.stopWatch());
            graph.shutdown();
            graph = (IndexableGraph)this.graphTest.generateGraph();
            this.stopWatch();
            manualIndex = graph.getIndex("testIndex", Vertex.class);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(manualIndex.get("key", (Object)"value")), (int)1);
            IndexableGraphTestSuite.assertEquals((Object)((Vertex)manualIndex.get("key", (Object)"value").iterator().next()).getId(), (Object)id);
            IndexableGraphTestSuite.printPerformance(graph.toString(), 1, "index reloaded and 1 vertex checked", this.stopWatch());
            graph.shutdown();
            graph = (IndexableGraph)this.graphTest.generateGraph();
            this.stopWatch();
            manualIndex = graph.getIndex("testIndex", Vertex.class);
            vertex = (Vertex)manualIndex.get("key", (Object)"value").iterator().next();
            IndexableGraphTestSuite.assertEquals((Object)vertex.getId(), (Object)id);
            graph.removeVertex(vertex);
            IndexableGraphTestSuite.assertEquals((int)0, (int)IndexableGraphTestSuite.count(manualIndex.get("key", (Object)"value")));
            IndexableGraphTestSuite.printPerformance(graph.toString(), 1, "index reloaded and 1 vertex checked and then removed", this.stopWatch());
            graph.shutdown();
            graph = (IndexableGraph)this.graphTest.generateGraph();
            this.stopWatch();
            manualIndex = graph.getIndex("testIndex", Vertex.class);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(manualIndex.get("key", (Object)"value")), (int)0);
            IndexableGraphTestSuite.printPerformance(graph.toString(), 1, "index reloaded and checked to ensure empty", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testExceptionOnIndexOverwrite() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsIndices.booleanValue() && graph.getFeatures().supportsVertexIndex.booleanValue()) {
            int loop = 1;
            if (graph.getFeatures().isPersistent.booleanValue()) {
                loop = 5;
            }
            graph.shutdown();
            this.stopWatch();
            String graphName = "";
            for (int i = 0; i < loop; ++i) {
                graph = (IndexableGraph)this.graphTest.generateGraph();
                graph.createIndex(i + "atest", Vertex.class, new Parameter[0]);
                graphName = graph.toString();
                int counter = 0;
                int exceptionCounter = 0;
                for (Index index : graph.getIndices()) {
                    try {
                        ++counter;
                        graph.createIndex(index.getIndexName(), index.getIndexClass(), new Parameter[0]);
                    }
                    catch (RuntimeException e) {
                        ++exceptionCounter;
                    }
                }
                IndexableGraphTestSuite.assertEquals((int)counter, (int)exceptionCounter);
                IndexableGraphTestSuite.assertTrue((counter > 0 ? 1 : 0) != 0);
                graph.shutdown();
            }
            IndexableGraphTestSuite.printPerformance(graphName, loop, "attempt(s) to overwrite existing indices", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testIndexDropPersistence() {
        IndexableGraph graph = (IndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().isPersistent.booleanValue() && graph.getFeatures().supportsIndices.booleanValue() && graph.getFeatures().supportsVertexIndex.booleanValue()) {
            graph.createIndex("blah", Vertex.class, new Parameter[0]);
            graph.createIndex("bleep", Vertex.class, new Parameter[0]);
            HashSet<String> indexNames = new HashSet<String>();
            for (Index index : graph.getIndices()) {
                indexNames.add(index.getIndexName());
            }
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)2);
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)indexNames.size());
            this.stopWatch();
            for (String indexName : indexNames) {
                graph.dropIndex(indexName);
            }
            IndexableGraphTestSuite.printPerformance(graph.toString(), indexNames.size(), "indices dropped", this.stopWatch());
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
            graph.shutdown();
            graph = (IndexableGraph)this.graphTest.generateGraph();
            IndexableGraphTestSuite.assertEquals((int)IndexableGraphTestSuite.count(graph.getIndices()), (int)0);
        }
        graph.shutdown();
    }
}

