/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import java.util.Arrays;
import java.util.List;

public class VertexQueryTestSuite
extends TestSuite {
    Vertex a;
    Vertex b;
    Vertex c;
    Edge aFriendB;
    Edge aFriendC;
    Edge aHateC;
    Edge cHateA;
    Edge cHateB;

    public VertexQueryTestSuite() {
    }

    public VertexQueryTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    private void createGraph(Graph graph) {
        this.a = graph.addVertex(null);
        this.b = graph.addVertex(null);
        this.c = graph.addVertex(null);
        this.aFriendB = graph.addEdge(null, this.a, this.b, this.graphTest.convertLabel("friend"));
        this.aFriendC = graph.addEdge(null, this.a, this.c, this.graphTest.convertLabel("friend"));
        this.aHateC = graph.addEdge(null, this.a, this.c, this.graphTest.convertLabel("hate"));
        this.cHateA = graph.addEdge(null, this.c, this.a, this.graphTest.convertLabel("hate"));
        this.cHateB = graph.addEdge(null, this.c, this.b, this.graphTest.convertLabel("hate"));
        this.aFriendB.setProperty("amount", (Object)1.0);
        this.aFriendB.setProperty("date", (Object)10);
        this.aFriendC.setProperty("amount", (Object)0.5);
        this.aHateC.setProperty("amount", (Object)1.0);
        this.cHateA.setProperty("amount", (Object)1.0);
        this.cHateB.setProperty("amount", (Object)0.4);
    }

    public void testBasicVertexQuery() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            VertexQueryTestSuite.assertEquals((int)VertexQueryTestSuite.count(this.a.query().labels(new String[]{this.graphTest.convertLabel("friend")}).hasNot("date").edges()), (int)1);
            VertexQueryTestSuite.assertEquals((Object)((Edge)this.a.query().labels(new String[]{this.graphTest.convertLabel("friend")}).hasNot("date").edges().iterator().next()).getProperty("amount"), (Object)0.5);
        }
        graph.shutdown();
    }

    public void testDirectionVertexQuery() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            List results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aHateC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).count(), (long)3L);
        }
        graph.shutdown();
    }

    public void testVertexQueryLabels() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            List results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("hate"), this.graphTest.convertLabel("friend")}).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aHateC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("hate"), this.graphTest.convertLabel("friend")}).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("hate"), this.graphTest.convertLabel("friend")}).count(), (long)3L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).count(), (long)2L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.BOTH).labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)4);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aHateC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.cHateA));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.BOTH).labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)4);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertFalse((boolean)results.contains(this.a));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.BOTH).labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).count(), (long)4L);
        }
        graph.shutdown();
    }

    public void testHasVertexQuery() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            List results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Object)1.0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Object)1.0).count(), (long)1L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.NOT_EQUAL, (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.NOT_EQUAL, (Object)1.0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.NOT_EQUAL, (Object)1.0).count(), (long)1L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.LESS_THAN_EQUAL, (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.LESS_THAN_EQUAL, (Object)1.0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.LESS_THAN_EQUAL, (Object)1.0).count(), (long)2L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Predicate)Compare.LESS_THAN, (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Predicate)Compare.LESS_THAN, (Object)1.0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).has("amount", (Predicate)Compare.LESS_THAN, (Object)1.0).count(), (long)1L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Object)0.5).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).has("amount", (Object)0.5).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate"), this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.GREATER_THAN, (Object)0.5).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.cHateA));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate"), this.graphTest.convertLabel("friend")}).has("amount", (Predicate)Compare.GREATER_THAN, (Object)0.5).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN, (Object)0.5).count(), (long)1L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN, (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN, (Object)1.0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN, (Object)1.0).count(), (long)0L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN_EQUAL, (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.cHateA));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN_EQUAL, (Object)1.0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.c));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.IN).labels(new String[]{this.graphTest.convertLabel("hate")}).has("amount", (Predicate)Compare.GREATER_THAN_EQUAL, (Object)1.0).count(), (long)1L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount").edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aHateC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).hasNot("amount").vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).hasNot("date").edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aHateC));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).hasNot("date").vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertEquals(results.get(0), (Object)this.c);
            VertexQueryTestSuite.assertEquals(results.get(0), (Object)this.c);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Predicate)Contains.NOT_IN, Arrays.asList(2.3, 5.6, 234)).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aHateC));
        }
        graph.shutdown();
    }

    public void testContainsQueries() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            List result = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Object)1.0).edges());
            VertexQueryTestSuite.assertEquals((int)result.size(), (int)2);
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aHateC));
            result = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Predicate)Contains.IN, Arrays.asList(1.0, 0.5)).edges());
            VertexQueryTestSuite.assertEquals((int)result.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aHateC));
            result = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Predicate)Contains.IN, Arrays.asList(1.0, 0.5, "marko", 13, Character.valueOf('a'), 32.13)).edges());
            VertexQueryTestSuite.assertEquals((int)result.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aFriendB));
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aFriendC));
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.aHateC));
            result = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).has("amount", (Predicate)Contains.IN, Arrays.asList(1.0, 0.5, "marko", 13, Character.valueOf('a'), 32.13)).vertices());
            VertexQueryTestSuite.assertEquals((int)result.size(), (int)3);
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.b));
            VertexQueryTestSuite.assertTrue((boolean)result.contains(this.c));
        }
        graph.shutdown();
    }

    public void testIntervalVertexQuery() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            List results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10)).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10)).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10)).count(), (long)0L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)).count(), (long)1L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.aFriendB));
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)1);
            VertexQueryTestSuite.assertTrue((boolean)results.contains(this.b));
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).interval("date", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)).count(), (long)1L);
        }
        graph.shutdown();
    }

    public void testLimitVertexQuery() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            this.createGraph(graph);
            List results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).limit(2).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((results.contains(this.aFriendB) || results.contains(this.aHateC) || results.contains(this.aFriendC) ? 1 : 0) != 0);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).limit(2).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)2);
            VertexQueryTestSuite.assertTrue((results.contains(this.b) || results.contains(this.c) ? 1 : 0) != 0);
            VertexQueryTestSuite.assertFalse((boolean)results.contains(this.a));
            VertexQueryTestSuite.assertEquals((long)this.a.query().labels(new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}).limit(2).count(), (long)2L);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).limit(0).edges());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            results = VertexQueryTestSuite.asList(this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).limit(0).vertices());
            VertexQueryTestSuite.assertEquals((int)results.size(), (int)0);
            VertexQueryTestSuite.assertEquals((long)this.a.query().direction(Direction.OUT).labels(new String[]{this.graphTest.convertLabel("friend")}).limit(0).count(), (long)0L);
        }
        graph.shutdown();
    }
}

