/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONReader;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class GraphSONWriterTestSuite
extends TestSuite {
    public GraphSONWriterTestSuite() {
    }

    public GraphSONWriterTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testGratefulGraphNormalized() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && !graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            this.stopWatch();
            String readGraphSON = GraphSONWriterTestSuite.readFile(GraphSONReader.class.getResourceAsStream("graph-example-2-normalized.json"), Charset.forName("UTF-8"));
            new GraphSONReader(graph).inputGraph(GraphSONReader.class.getResourceAsStream("graph-example-2-normalized.json"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new GraphSONWriter(graph).outputGraph((OutputStream)baos, null, null, GraphSONMode.NORMAL, true);
            String writtenGraphSON = new String(baos.toByteArray());
            GraphSONWriterTestSuite.assertEquals((String)readGraphSON, (String)writtenGraphSON);
        }
        graph.shutdown();
    }

    static String readFile(InputStream inputStream, Charset encoding) throws IOException {
        byte[] encoded = GraphSONWriterTestSuite.toByteArray(inputStream);
        return encoding.decode(ByteBuffer.wrap(encoded)).toString();
    }

    static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int reads = is.read();
        while (reads != -1) {
            baos.write(reads);
            reads = is.read();
        }
        return baos.toByteArray();
    }
}

