/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.function.IntObjectProcedure;
import cern.colt.function.IntProcedure;
import cern.colt.list.ByteArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.HashFunctions;

public class OpenIntObjectHashMap
extends AbstractIntObjectMap {
    protected int[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenIntObjectHashMap() {
        this(277);
    }

    public OpenIntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenIntObjectHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        new ObjectArrayList(this.values).fillFromToWith(0, this.state.length - 1, null);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenIntObjectHashMap copy = (OpenIntObjectHashMap)super.clone();
        copy.table = (int[])copy.table.clone();
        copy.values = (Object[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    public boolean containsKey(int key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public boolean forEachKey(IntProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(IntObjectProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public Object get(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(int key) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && tab[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(int key) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(Object value) {
        Object[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int keyOf(Object value) {
        int i = this.indexOfValue(value);
        if (i < 0) {
            return Integer.MIN_VALUE;
        }
        return this.table[i];
    }

    public void keys(IntArrayList list) {
        list.setSize(this.distinct);
        int[] elements = list.elements();
        int[] tab = this.table;
        byte[] stat = this.state;
        int j = 0;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = tab[i];
        }
    }

    public void pairsMatching(IntObjectProcedure condition, IntArrayList keyList, ObjectArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    public boolean put(int key, Object value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        int[] oldTable = this.table;
        Object[] oldValues = this.values;
        byte[] oldState = this.state;
        int[] newTable = new int[newCapacity];
        Object[] newValues = new Object[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            int element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
            newState[index] = 1;
        }
    }

    public boolean removeKey(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        this.values[i] = null;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new int[capacity];
        this.values = new Object[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public void values(ObjectArrayList list) {
        list.setSize(this.distinct);
        Object[] elements = list.elements();
        Object[] val = this.values;
        byte[] stat = this.state;
        int j = 0;
        int i = stat.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = val[i];
        }
    }
}

