/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.bench;

import cern.colt.Timer;
import cern.colt.Version;
import cern.colt.function.Double9Function;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleFactory3D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.bench.BenchmarkKernel;
import cern.colt.matrix.bench.Double2DProcedure;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.LUDecompositionQuick;
import cern.colt.matrix.linalg.Property;
import cern.colt.matrix.linalg.SeqBlas;
import cern.colt.matrix.linalg.SmpBlas;
import cern.jet.math.Functions;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class BenchmarkMatrix {
    protected BenchmarkMatrix() {
    }

    protected static void bench_dgemm(String[] args) {
        int[] sizes;
        boolean transposeB;
        boolean transposeA;
        double[] densities;
        double minSecs;
        int cpus;
        String[] types;
        try {
            int k = 1;
            types = new String[]{args[k++]};
            cpus = Integer.parseInt(args[k++]);
            minSecs = new Double(args[k++]);
            densities = new double[]{new Double(args[k++])};
            transposeA = new Boolean(args[k++]);
            transposeB = new Boolean(args[k++]);
            sizes = new int[args.length - k];
            int i = 0;
            while (k < args.length) {
                sizes[i] = Integer.parseInt(args[k]);
                ++k;
                ++i;
            }
        }
        catch (Exception exc) {
            System.out.println(BenchmarkMatrix.usage(args[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(cpus, SeqBlas.seqBlas);
        Double2DProcedure fun = BenchmarkMatrix.fun_dgemm(transposeA, transposeB);
        String title = fun.toString();
        String params = transposeA + ", " + transposeB + ", 1, A, B, 0, C";
        title = title + " dgemm(" + params + ")";
        BenchmarkMatrix.run(minSecs, title, fun, types, sizes, densities);
    }

    protected static void bench_dgemv(String[] args) {
        int[] sizes;
        boolean transposeA;
        double[] densities;
        double minSecs;
        int cpus;
        String[] types;
        try {
            int k = 1;
            types = new String[]{args[k++]};
            cpus = Integer.parseInt(args[k++]);
            minSecs = new Double(args[k++]);
            densities = new double[]{new Double(args[k++])};
            transposeA = new Boolean(args[k++]);
            sizes = new int[args.length - k];
            int i = 0;
            while (k < args.length) {
                sizes[i] = Integer.parseInt(args[k]);
                ++k;
                ++i;
            }
        }
        catch (Exception exc) {
            System.out.println(BenchmarkMatrix.usage(args[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(cpus, SeqBlas.seqBlas);
        Double2DProcedure fun = BenchmarkMatrix.fun_dgemv(transposeA);
        String title = fun.toString();
        String params = transposeA + ", 1, A, B, 0, C";
        title = title + " dgemv(" + params + ")";
        BenchmarkMatrix.run(minSecs, title, fun, types, sizes, densities);
    }

    protected static void bench_pow(String[] args) {
        int[] sizes;
        int exponent;
        double[] densities;
        double minSecs;
        int cpus;
        String[] types;
        try {
            int k = 1;
            types = new String[]{args[k++]};
            cpus = Integer.parseInt(args[k++]);
            minSecs = new Double(args[k++]);
            densities = new double[]{new Double(args[k++])};
            exponent = Integer.parseInt(args[k++]);
            sizes = new int[args.length - k];
            int i = 0;
            while (k < args.length) {
                sizes[i] = Integer.parseInt(args[k]);
                ++k;
                ++i;
            }
        }
        catch (Exception exc) {
            System.out.println(BenchmarkMatrix.usage(args[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(cpus, SeqBlas.seqBlas);
        Double2DProcedure fun = BenchmarkMatrix.fun_pow(exponent);
        String title = fun.toString();
        String params = "A," + exponent;
        title = title + " pow(" + params + ")";
        BenchmarkMatrix.run(minSecs, title, fun, types, sizes, densities);
    }

    protected static void benchGeneric(Double2DProcedure fun, String[] args) {
        int[] sizes;
        double[] densities;
        double minSecs;
        int cpus;
        String[] types;
        try {
            int k = 1;
            types = new String[]{args[k++]};
            cpus = Integer.parseInt(args[k++]);
            minSecs = new Double(args[k++]);
            densities = new double[]{new Double(args[k++])};
            sizes = new int[args.length - k];
            int i = 0;
            while (k < args.length) {
                sizes[i] = Integer.parseInt(args[k]);
                ++k;
                ++i;
            }
        }
        catch (Exception exc) {
            System.out.println(BenchmarkMatrix.usage(args[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(cpus, SeqBlas.seqBlas);
        String title = fun.toString();
        BenchmarkMatrix.run(minSecs, title, fun, types, sizes, densities);
    }

    protected static String commands() {
        return "dgemm, dgemv, pow, assign, assignGetSet, assignGetSetQuick, assignLog, assignPlusMult, elementwiseMult, elementwiseMultB, SOR5, SOR8, LUDecompose, LUSolve";
    }

    protected static Double2DProcedure fun_dgemm(final boolean transposeA, final boolean transposeB) {
        return new Double2DProcedure(){

            public String toString() {
                return "Blas matrix-matrix mult";
            }

            public void setParameters(DoubleMatrix2D G, DoubleMatrix2D H) {
                super.setParameters(G, H);
                this.D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns()).assign(0.5);
                this.C = this.D.copy();
                this.B = this.D.copy();
            }

            public void init() {
                this.C.assign(this.D);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.dgemm(transposeA, transposeB, 1.0, this.A, this.B, 0.0, this.C);
            }

            public double operations() {
                double m = this.A.rows();
                double n = this.A.columns();
                double p = this.B.columns();
                return 2.0 * m * n * p / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure fun_dgemv(final boolean transposeA) {
        return new Double2DProcedure(){

            public String toString() {
                return "Blas matrix-vector mult";
            }

            public void setParameters(DoubleMatrix2D G, DoubleMatrix2D H) {
                super.setParameters(G, H);
                this.D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns()).assign(0.5);
                this.C = this.D.copy();
                this.B = this.D.copy();
            }

            public void init() {
                this.C.viewRow(0).assign(this.D.viewRow(0));
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.dgemv(transposeA, 1.0, this.A, this.B.viewRow(0), 0.0, this.C.viewRow(0));
            }

            public double operations() {
                double m = this.A.rows();
                double n = this.A.columns();
                return 2.0 * m * n / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure fun_pow(final int k) {
        return new Double2DProcedure(){
            public double dummy;

            public String toString() {
                return "matrix to the power of an exponent";
            }

            public void setParameters(DoubleMatrix2D A, DoubleMatrix2D B) {
                if (k < 0) {
                    if (!Property.ZERO.isDiagonallyDominantByRow(A) || !Property.ZERO.isDiagonallyDominantByColumn(A)) {
                        Property.ZERO.generateNonSingular(A);
                    }
                    super.setParameters(A, B);
                }
            }

            public void init() {
            }

            public void apply(Timer timer) {
                Algebra.DEFAULT.pow(this.A, k);
            }

            public double operations() {
                double m = this.A.rows();
                if (k == 0) {
                    return m;
                }
                double mflops = 0.0;
                if (k < 0) {
                    double N = Math.min(this.A.rows(), this.A.columns());
                    mflops += 2.0 * N * N * N / 3.0 / 1000000.0;
                    double n = this.A.columns();
                    double nx = this.B.columns();
                    mflops += 2.0 * nx * (n * n + n) / 1000000.0;
                }
                return mflops += 2.0 * (double)(Math.abs(k) - 1) * m * m * m / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funAssign() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B) [Mops/sec]";
            }

            public void init() {
                this.A.assign(0.0);
            }

            public void apply(Timer timer) {
                this.A.assign(this.B);
            }
        };
    }

    protected static Double2DProcedure funAssignGetSet() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B) via get and set [Mops/sec]";
            }

            public void init() {
                this.A.assign(0.0);
            }

            public void apply(Timer timer) {
                int rows = this.B.rows();
                int columns = this.B.columns();
                for (int row = 0; row < rows; ++row) {
                    for (int column = 0; column < columns; ++column) {
                        this.A.set(row, column, this.B.get(row, column));
                    }
                }
            }
        };
    }

    protected static Double2DProcedure funAssignGetSetQuick() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B) via getQuick and setQuick [Mops/sec]";
            }

            public void init() {
                this.A.assign(0.0);
            }

            public void apply(Timer timer) {
                int rows = this.B.rows();
                int columns = this.B.columns();
                for (int row = 0; row < rows; ++row) {
                    for (int column = 0; column < columns; ++column) {
                        this.A.setQuick(row, column, this.B.getQuick(row, column));
                    }
                }
            }
        };
    }

    protected static Double2DProcedure funAssignLog() {
        return new Double2DProcedure(){

            public String toString() {
                return "A[i,j] = log(A[i,j]) via Blas.assign(fun) [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, Functions.log);
            }
        };
    }

    protected static Double2DProcedure funAssignPlusMult() {
        return new Double2DProcedure(){

            public String toString() {
                return "A[i,j] = A[i,j] + s*B[i,j] via Blas.assign(fun) [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, this.B, Functions.plusMult(0.5));
            }

            public double operations() {
                double m = this.A.rows();
                double n = this.A.columns();
                return 2.0 * m * n / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funCorrelation() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
            }

            public void setParameters(DoubleMatrix2D A, DoubleMatrix2D B) {
                super.setParameters(A.viewDice(), B);
            }

            public void apply(Timer timer) {
                Statistic.correlation(Statistic.covariance(this.A));
            }

            public double operations() {
                double m = this.A.rows();
                double n = this.A.columns();
                return m * (n * n + n) / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funElementwiseMult() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(F.mult(0.5)) via Blas [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, Functions.mult(0.5));
            }
        };
    }

    protected static Double2DProcedure funElementwiseMultB() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B,F.mult) via Blas [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, this.B, Functions.mult);
            }
        };
    }

    protected static Double2DProcedure funGetQuick() {
        return new Double2DProcedure(){
            public double dummy;

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
            }

            public void apply(Timer timer) {
                int rows = this.B.rows();
                int columns = this.B.columns();
                double sum = 0.0;
                for (int row = 0; row < rows; ++row) {
                    for (int column = 0; column < columns; ++column) {
                        sum += this.A.getQuick(row, column);
                    }
                }
                this.dummy = sum;
            }
        };
    }

    protected static Double2DProcedure funLUDecompose() {
        return new Double2DProcedure(){
            LUDecompositionQuick lu = new LUDecompositionQuick(0.0);

            public String toString() {
                return "LU.decompose(A) [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                this.lu.decompose(this.A);
            }

            public double operations() {
                double N = Math.min(this.A.rows(), this.A.columns());
                return 2.0 * N * N * N / 3.0 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funLUSolve() {
        return new Double2DProcedure(){
            LUDecompositionQuick lu;

            public String toString() {
                return "LU.solve(A) [Mflops/sec]";
            }

            public void setParameters(DoubleMatrix2D A, DoubleMatrix2D B) {
                this.lu = null;
                if (!Property.ZERO.isDiagonallyDominantByRow(A) || !Property.ZERO.isDiagonallyDominantByColumn(A)) {
                    Property.ZERO.generateNonSingular(A);
                }
                super.setParameters(A, B);
                this.lu = new LUDecompositionQuick(0.0);
                this.lu.decompose(A);
            }

            public void init() {
                this.B.assign(this.D);
            }

            public void apply(Timer timer) {
                this.lu.solve(this.B);
            }

            public double operations() {
                double n = this.A.columns();
                double nx = this.B.columns();
                return 2.0 * nx * (n * n + n) / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funMatMultLarge() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void setParameters(DoubleMatrix2D A, DoubleMatrix2D B) {
                this.A = A;
                this.B = B;
                this.C = A.copy();
            }

            public void init() {
                this.C.assign(0.0);
            }

            public void apply(Timer timer) {
                this.A.zMult(this.B, this.C);
            }

            public double operations() {
                double m = this.A.rows();
                double n = this.A.columns();
                double p = this.B.columns();
                return 2.0 * m * n * p / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funMatVectorMult() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void setParameters(DoubleMatrix2D G, DoubleMatrix2D H) {
                super.setParameters(G, H);
                this.D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns()).assign(0.5);
                this.C = this.D.copy();
                this.B = this.D.copy();
            }

            public void init() {
                this.C.viewRow(0).assign(this.D.viewRow(0));
            }

            public void apply(Timer timer) {
                this.A.zMult(this.B.viewRow(0), this.C.viewRow(0));
            }

            public double operations() {
                double m = this.A.rows();
                double n = this.A.columns();
                return 2.0 * m * n / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funSetQuick() {
        return new Double2DProcedure(){
            private int current;
            private double density;

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
                this.A.assign(0.0);
                int seed = 123456;
                this.current = 4 * seed + 1;
                this.density = (double)this.A.cardinality() / (double)this.A.size();
            }

            public void apply(Timer timer) {
                int rows = this.B.rows();
                int columns = this.B.columns();
                for (int row = 0; row < rows; ++row) {
                    for (int column = 0; column < columns; ++column) {
                        this.current *= 663608941;
                        double random = (double)((long)this.current & 0xFFFFFFFFL) * 2.3283064365386963E-10;
                        if (random < this.density) {
                            this.A.setQuick(row, column, random);
                            continue;
                        }
                        this.A.setQuick(row, column, 0.0);
                    }
                }
            }
        };
    }

    protected static Double2DProcedure funSOR5() {
        return new Double2DProcedure(){
            double value = 2.0;
            double omega = 1.25;
            final double alpha = this.omega * 0.25;
            final double beta = 1.0 - this.omega;
            Double9Function function = new Double9Function(){

                public final double apply(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
                    return alpha * a11 + beta * (a01 + a10 + a12 + a21);
                }
            };

            public String toString() {
                return "A.zAssign8Neighbors(5 point function) [Mflops/sec]";
            }

            public void init() {
                this.B.assign(this.D);
            }

            public void apply(Timer timer) {
                this.A.zAssign8Neighbors(this.B, this.function);
            }

            public double operations() {
                double n = this.A.columns();
                double m = this.A.rows();
                return 6.0 * m * n / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funSOR8() {
        return new Double2DProcedure(){
            double value = 2.0;
            double omega = 1.25;
            final double alpha = this.omega * 0.25;
            final double beta = 1.0 - this.omega;
            Double9Function function = new Double9Function(){

                public final double apply(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
                    return alpha * a11 + beta * (a00 + a10 + a20 + a01 + a21 + a02 + a12 + a22);
                }
            };

            public String toString() {
                return "A.zAssign8Neighbors(9 point function) [Mflops/sec]";
            }

            public void init() {
                this.B.assign(this.D);
            }

            public void apply(Timer timer) {
                this.A.zAssign8Neighbors(this.B, this.function);
            }

            public double operations() {
                double n = this.A.columns();
                double m = this.A.rows();
                return 10.0 * m * n / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funSort() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                this.A.viewSorted(0);
            }
        };
    }

    protected static DoubleFactory2D getFactory(String type) {
        if (type.equals("dense")) {
            return DoubleFactory2D.dense;
        }
        if (type.equals("sparse")) {
            return DoubleFactory2D.sparse;
        }
        if (type.equals("rowCompressed")) {
            return DoubleFactory2D.rowCompressed;
        }
        String s = "type=" + type + " is unknown. Use one of {dense,sparse,rowCompressed}";
        throw new IllegalArgumentException(s);
    }

    protected static Double2DProcedure getGenericFunction(String cmd) {
        if (cmd.equals("dgemm")) {
            return BenchmarkMatrix.fun_dgemm(false, false);
        }
        if (cmd.equals("dgemv")) {
            return BenchmarkMatrix.fun_dgemv(false);
        }
        if (cmd.equals("pow")) {
            return BenchmarkMatrix.fun_pow(2);
        }
        if (cmd.equals("assign")) {
            return BenchmarkMatrix.funAssign();
        }
        if (cmd.equals("assignGetSet")) {
            return BenchmarkMatrix.funAssignGetSet();
        }
        if (cmd.equals("assignGetSetQuick")) {
            return BenchmarkMatrix.funAssignGetSetQuick();
        }
        if (cmd.equals("elementwiseMult")) {
            return BenchmarkMatrix.funElementwiseMult();
        }
        if (cmd.equals("elementwiseMultB")) {
            return BenchmarkMatrix.funElementwiseMultB();
        }
        if (cmd.equals("SOR5")) {
            return BenchmarkMatrix.funSOR5();
        }
        if (cmd.equals("SOR8")) {
            return BenchmarkMatrix.funSOR8();
        }
        if (cmd.equals("LUDecompose")) {
            return BenchmarkMatrix.funLUDecompose();
        }
        if (cmd.equals("LUSolve")) {
            return BenchmarkMatrix.funLUSolve();
        }
        if (cmd.equals("assignLog")) {
            return BenchmarkMatrix.funAssignLog();
        }
        if (cmd.equals("assignPlusMult")) {
            return BenchmarkMatrix.funAssignPlusMult();
        }
        return null;
    }

    protected static boolean handle(String[] params) {
        boolean success = true;
        String cmd = params[0];
        if (cmd.equals("dgemm")) {
            BenchmarkMatrix.bench_dgemm(params);
        } else if (cmd.equals("dgemv")) {
            BenchmarkMatrix.bench_dgemv(params);
        } else if (cmd.equals("pow")) {
            BenchmarkMatrix.bench_pow(params);
        } else {
            Double2DProcedure fun = BenchmarkMatrix.getGenericFunction(cmd);
            if (fun != null) {
                BenchmarkMatrix.benchGeneric(fun, params);
            } else {
                success = false;
                String s = "Command=" + params[0] + " is illegal or unknown. Should be one of " + BenchmarkMatrix.commands() + "followed by appropriate parameters.\n" + BenchmarkMatrix.usage() + "\nIgnoring this line.\n";
                System.out.println(s);
            }
        }
        return success;
    }

    public static void main(String[] args) {
        int n = args.length;
        if (n == 0 || n <= 1 && args[0].equals("-help")) {
            System.out.println(BenchmarkMatrix.usage());
            return;
        }
        if (args[0].equals("-help")) {
            if (BenchmarkMatrix.commands().indexOf(args[1]) < 0) {
                System.out.println(args[1] + ": no such command available.\n" + BenchmarkMatrix.usage());
            } else {
                System.out.println(BenchmarkMatrix.usage(args[1]));
            }
            return;
        }
        System.out.println("Colt Matrix benchmark running on\n");
        System.out.println(BenchmarkKernel.systemInfo() + "\n");
        System.out.println("Colt Version is " + Version.asString() + "\n");
        Timer timer = new Timer().start();
        if (!args[0].equals("-file")) {
            System.out.println("\n\nExecuting command = " + new ObjectArrayList(args) + " ...");
            BenchmarkMatrix.handle(args);
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(args[1]));
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage());
            }
            StreamTokenizer stream = new StreamTokenizer(reader);
            stream.eolIsSignificant(true);
            stream.slashSlashComments(true);
            stream.slashStarComments(true);
            try {
                String line;
                ObjectArrayList words = new ObjectArrayList();
                while (true) {
                    int token = stream.nextToken();
                    if (token == -1) break;
                    if (token == 10) {
                        if (words.size() > 0) {
                            String[] params = new String[words.size()];
                            for (int i = 0; i < words.size(); ++i) {
                                params[i] = (String)words.get(i);
                            }
                            System.out.println("\n\nExecuting command = " + words + " ...");
                            BenchmarkMatrix.handle(params);
                        }
                        words.clear();
                        continue;
                    }
                    Former formatter = new FormerFactory().create("%G");
                    String word = token == -2 ? formatter.form(stream.nval) : stream.sval;
                    if (word == null) continue;
                    words.add(word);
                }
                reader.close();
                System.out.println("\nCommand file name used: " + args[1] + "\nTo reproduce and compare results, here it's contents:");
                try {
                    reader = new BufferedReader(new FileReader(args[1]));
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
                reader.close();
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        System.out.println("\nProgram execution took a total of " + timer.minutes() + " minutes.");
        System.out.println("Good bye.");
    }

    protected static void run(double minSeconds, String title, Double2DProcedure function, String[] types, int[] sizes, double[] densities) {
        DoubleMatrix3D timings = DoubleFactory3D.dense.make(types.length, sizes.length, densities.length);
        Timer runTime = new Timer().start();
        for (int k = 0; k < types.length; ++k) {
            DoubleFactory2D factory = BenchmarkMatrix.getFactory(types[k]);
            System.out.print("\n@");
            for (int i = 0; i < sizes.length; ++i) {
                int size = sizes[i];
                System.out.print("x");
                for (int j = 0; j < densities.length; ++j) {
                    float opsPerSec;
                    double density = densities[j];
                    System.out.print(".");
                    if (k <= 0 || !(density >= 0.1) || size < 500) {
                        double val = 0.5;
                        function.A = null;
                        function.B = null;
                        function.C = null;
                        function.D = null;
                        DoubleMatrix2D A = factory.sample(size, size, val, density);
                        DoubleMatrix2D B = factory.sample(size, size, val, density);
                        function.setParameters(A, B);
                        A = null;
                        B = null;
                        double ops = function.operations();
                        double secs = BenchmarkKernel.run(minSeconds, function);
                        opsPerSec = (float)(ops / secs);
                    } else {
                        opsPerSec = Float.NaN;
                    }
                    timings.set(k, i, j, opsPerSec);
                }
            }
        }
        runTime.stop();
        String sliceAxisName = "type";
        String rowAxisName = "size";
        String colAxisName = "d";
        String[] sliceNames = types;
        BinFunctions1D F = BinFunctions1D.functions;
        BinFunction1D[] aggr = null;
        String[] rowNames = new String[sizes.length];
        String[] colNames = new String[densities.length];
        int i = sizes.length;
        while (--i >= 0) {
            rowNames[i] = Integer.toString(sizes[i]);
        }
        int j = densities.length;
        while (--j >= 0) {
            colNames[j] = Double.toString(densities[j]);
        }
        System.out.println("*");
        String tmp = rowAxisName;
        rowAxisName = colAxisName;
        colAxisName = tmp;
        String[] tmp2 = rowNames;
        rowNames = colNames;
        colNames = tmp2;
        timings = timings.viewDice(0, 2, 1);
        System.out.println(new Formatter("%1.3G").toTitleString(timings, sliceNames, rowNames, colNames, sliceAxisName, rowAxisName, colAxisName, "Performance of " + title, aggr));
        System.out.println("Run took a total of " + runTime + ". End of run.");
    }

    protected static void runSpecial(double minSeconds, String title, Double2DProcedure function) {
        int[] sizes = new int[]{10000};
        double[] densities = new double[]{1.0E-5};
        boolean[] sparses = new boolean[]{true};
        DoubleMatrix2D timings = DoubleFactory2D.dense.make(sizes.length, 4);
        Timer runTime = new Timer().start();
        for (int i = 0; i < sizes.length; ++i) {
            int size = sizes[i];
            double density = densities[i];
            boolean sparse = sparses[i];
            DoubleFactory2D factory = sparse ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
            System.out.print("\n@");
            System.out.print("x");
            double val = 0.5;
            function.A = null;
            function.B = null;
            function.C = null;
            function.D = null;
            DoubleMatrix2D A = factory.sample(size, size, val, density);
            DoubleMatrix2D B = factory.sample(size, size, val, density);
            function.setParameters(A, B);
            A = null;
            B = null;
            float secs = BenchmarkKernel.run(minSeconds, function);
            double ops = function.operations();
            float opsPerSec = (float)(ops / (double)secs);
            timings.viewRow(i).set(0, sparse ? 0.0 : 1.0);
            timings.viewRow(i).set(1, size);
            timings.viewRow(i).set(2, density);
            timings.viewRow(i).set(3, opsPerSec);
        }
        runTime.stop();
        BinFunctions1D F = BinFunctions1D.functions;
        BinFunction1D[] aggr = null;
        String[] rowNames = null;
        String[] colNames = new String[]{"dense (y=1,n=0)", "size", "density", "flops/sec"};
        String rowAxisName = null;
        String colAxisName = null;
        System.out.println("*");
        System.out.println(new Formatter("%1.3G").toTitleString(timings, rowNames, colNames, rowAxisName, colAxisName, title, aggr));
        System.out.println("Run took a total of " + runTime + ". End of run.");
    }

    protected static String usage() {
        String usage = "\nUsage (help): To get this help, type java cern.colt.matrix.bench.BenchmarkMatrix -help\nTo get help on a command's args, omit args and type java cern.colt.matrix.bench.BenchmarkMatrix -help <command>\nAvailable commands: " + BenchmarkMatrix.commands() + "\n\n" + "Usage (direct): java cern.colt.matrix.bench.BenchmarkMatrix command {args}\n" + "Example: dgemm dense 2 2.0 0.999 false true 5 10 25 50 100 250 500\n\n" + "Usage (batch mode): java cern.colt.matrix.bench.BenchmarkMatrix -file <file>\nwhere <file> is a text file with each line holding a command followed by appropriate args (comments and empty lines ignored).\n\n" + "Example file's content:\n" + "dgemm dense 1 2.0 0.999 false true 5 10 25 50 100 250 500\n" + "dgemm dense 2 2.0 0.999 false true 5 10 25 50 100 250 500\n\n" + "/*\n" + "Java like comments in file are ignored\n" + "dgemv dense 1 2.0 0.001 false 5 10 25 50 100 250 500 1000\n" + "dgemv sparse 1 2.0 0.001 false 5 10 25 50 100 250 500 1000\n" + "dgemv rowCompressed 1 2.0 0.001 false 5 10 25 50 100 250 500 1000\n" + "*/\n" + "// more comments ignored\n";
        return usage;
    }

    protected static String usage(String cmd) {
        String usage = cmd + " description: " + BenchmarkMatrix.getGenericFunction(cmd).toString() + "\nArguments to be supplied:\n" + "\t<operation> <type> <cpus> <minSecs> <density>";
        if (cmd.equals("dgemv")) {
            usage = usage + " <transposeA>";
        }
        if (cmd.equals("dgemm")) {
            usage = usage + " <transposeA> <transposeB>";
        }
        if (cmd.equals("pow")) {
            usage = usage + " <exponent>";
        }
        usage = usage + " {sizes}\n" + "where\n" + "\toperation = the operation to benchmark; in this case: " + cmd + "\n" + "\ttype = matrix type to be used; e.g. dense, sparse or rowCompressed\n" + "\tcpus = #cpus available; e.g. 1 or 2 or ...\n" + "\tminSecs = #seconds each operation shall at least run; e.g. 2.0 is a good number giving realistic timings\n" + "\tdensity = the density of the matrices to be benchmarked; e.g. 0.999 is very dense, 0.001 is very sparse\n";
        if (cmd.equals("dgemv")) {
            usage = usage + "\ttransposeA = false or true\n";
        }
        if (cmd.equals("dgemm")) {
            usage = usage + "\ttransposeA = false or true\n\ttransposeB = false or true\n";
        }
        if (cmd.equals("pow")) {
            usage = usage + "\texponent = the number of times to multiply; e.g. 1000\n";
        }
        usage = usage + "\tsizes = a list of problem sizes; e.g. 100 200 benchmarks squared 100x100 and 200x200 matrices";
        return usage;
    }
}

