/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;

public class Partitioning {
    protected Partitioning() {
    }

    public static void partition(DoubleMatrix2D matrix, int[] rowIndexes, int rowFrom, int rowTo, int column, final double[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        if (rowFrom < 0 || rowTo >= matrix.rows() || rowTo >= rowIndexes.length) {
            throw new IllegalArgumentException();
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IllegalArgumentException();
        }
        if (splitFrom < 0 || splitTo >= splitters.length) {
            throw new IllegalArgumentException();
        }
        if (splitIndexes.length < splitters.length) {
            throw new IllegalArgumentException();
        }
        final int[] g = rowIndexes;
        Swapper swapper = new Swapper(){

            public void swap(int b, int c) {
                int tmp = g[b];
                g[b] = g[c];
                g[c] = tmp;
            }
        };
        final DoubleMatrix1D columnView = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                double av = splitters[a];
                double bv = columnView.getQuick(g[b]);
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        IntComparator comp2 = new IntComparator(){

            public int compare(int a, int b) {
                double bv;
                double av = columnView.getQuick(g[a]);
                return av < (bv = columnView.getQuick(g[b])) ? -1 : (av == bv ? 0 : 1);
            }
        };
        IntComparator comp3 = new IntComparator(){

            public int compare(int a, int b) {
                double av = splitters[a];
                double bv = splitters[b];
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        cern.colt.Partitioning.genericPartition(rowFrom, rowTo, splitFrom, splitTo, splitIndexes, comp, comp2, comp3, swapper);
    }

    public static DoubleMatrix2D partition(DoubleMatrix2D matrix, int column, double[] splitters, int[] splitIndexes) {
        int rowFrom = 0;
        int rowTo = matrix.rows() - 1;
        int splitFrom = 0;
        int splitTo = splitters.length - 1;
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        Partitioning.partition(matrix, rowIndexes, rowFrom, rowTo, column, splitters, splitFrom, splitTo, splitIndexes);
        int[] columnIndexes = new int[matrix.columns()];
        int i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnIndexes[i2] = i2;
        }
        return matrix.viewSelection(rowIndexes, columnIndexes);
    }

    private static void xPartitionOld(DoubleMatrix2D matrix, DoubleMatrix1D column, int from, int to, double[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
    }

    private static int xPartitionOld(DoubleMatrix2D matrix, DoubleMatrix1D column, int from, int to, double splitter) {
        return 0;
    }
}

