/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix;

public abstract class AbstractMatrix1D
extends AbstractMatrix {
    protected int size;
    protected int zero;
    protected int stride;

    protected AbstractMatrix1D() {
    }

    protected int _offset(int absRank) {
        return absRank;
    }

    protected int _rank(int rank) {
        return this.zero + rank * this.stride;
    }

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at index=" + index);
        }
    }

    protected void checkIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.size) continue;
            this.checkIndex(index);
        }
    }

    protected void checkRange(int index, int width) {
        if (index < 0 || index + width > this.size) {
            throw new IndexOutOfBoundsException("index: " + index + ", width: " + width + ", size=" + this.size);
        }
    }

    protected void checkSize(double[] B) {
        if (this.size != B.length) {
            throw new IllegalArgumentException("Incompatible sizes: " + this.toStringShort() + " and " + B.length);
        }
    }

    public void checkSize(AbstractMatrix1D B) {
        if (this.size != B.size) {
            throw new IllegalArgumentException("Incompatible sizes: " + this.toStringShort() + " and " + B.toStringShort());
        }
    }

    protected int index(int rank) {
        return this._offset(this._rank(rank));
    }

    protected void setUp(int size) {
        this.setUp(size, 0, 1);
    }

    protected void setUp(int size, int zero, int stride) {
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.size = size;
        this.zero = zero;
        this.stride = stride;
        this.isNoView = true;
    }

    public int size() {
        return this.size;
    }

    protected int stride(int dimension) {
        if (dimension != 0) {
            throw new IllegalArgumentException("invalid dimension: " + dimension + "used to access" + this.toStringShort());
        }
        return this.stride;
    }

    public String toStringShort() {
        return AbstractFormatter.shape(this);
    }

    protected AbstractMatrix1D vFlip() {
        if (this.size > 0) {
            this.zero += (this.size - 1) * this.stride;
            this.stride = -this.stride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix1D vPart(int index, int width) {
        this.checkRange(index, width);
        this.zero += this.stride * index;
        this.size = width;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix1D vStrides(int stride) {
        if (stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + stride);
        }
        this.stride *= stride;
        if (this.size != 0) {
            this.size = (this.size - 1) / stride + 1;
        }
        this.isNoView = false;
        return this;
    }
}

