/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;

class WrapperDoubleMatrix1D
extends DoubleMatrix1D {
    protected DoubleMatrix1D content;

    public WrapperDoubleMatrix1D(DoubleMatrix1D newContent) {
        if (newContent != null) {
            this.setUp(newContent.size());
        }
        this.content = newContent;
    }

    protected DoubleMatrix1D getContent() {
        return this.content;
    }

    public double getQuick(int index) {
        return this.content.getQuick(index);
    }

    public DoubleMatrix1D like(int size) {
        return this.content.like(size);
    }

    public DoubleMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    public void setQuick(int index, double value) {
        this.content.setQuick(index, value);
    }

    public DoubleMatrix1D viewFlip() {
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){

            public double getQuick(int index) {
                return this.content.get(this.size - 1 - index);
            }

            public void setQuick(int index, double value) {
                this.content.set(this.size - 1 - index, value);
            }
        };
        return view;
    }

    public DoubleMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){

            public double getQuick(int i) {
                return this.content.get(index + i);
            }

            public void setQuick(int i, double value) {
                this.content.set(index + i, value);
            }
        };
        view.size = width;
        return view;
    }

    public DoubleMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){

            public double getQuick(int i) {
                return this.content.get(idx[i]);
            }

            public void setQuick(int i, double value) {
                this.content.set(idx[i], value);
            }
        };
        view.size = indexes.length;
        return view;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    public DoubleMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){

            public double getQuick(int index) {
                return this.content.get(index * _stride);
            }

            public void setQuick(int index, double value) {
                this.content.set(index * _stride, value);
            }
        };
        view.size = this.size;
        if (this.size != 0) {
            view.size = (this.size - 1) / _stride + 1;
        }
        return view;
    }
}

