/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.BreitWigner;
import cern.jet.random.Uniform;
import cern.jet.random.engine.RandomEngine;

public class BreitWignerMeanSquare
extends BreitWigner {
    protected Uniform uniform;
    protected static BreitWigner shared = new BreitWignerMeanSquare(1.0, 0.2, 1.0, BreitWignerMeanSquare.makeDefaultGenerator());

    public BreitWignerMeanSquare(double mean, double gamma, double cut, RandomEngine randomGenerator) {
        super(mean, gamma, cut, randomGenerator);
        this.uniform = new Uniform(randomGenerator);
    }

    public Object clone() {
        BreitWignerMeanSquare copy = (BreitWignerMeanSquare)super.clone();
        if (this.uniform != null) {
            copy.uniform = new Uniform(copy.randomGenerator);
        }
        return copy;
    }

    public double nextDouble(double mean, double gamma, double cut) {
        if (gamma == 0.0) {
            return mean;
        }
        if (cut == Double.NEGATIVE_INFINITY) {
            double val = Math.atan(-mean / gamma);
            double rval = this.uniform.nextDoubleFromTo(val, 1.5707963267948966);
            double displ = gamma * Math.tan(rval);
            return Math.sqrt(mean * mean + mean * displ);
        }
        double tmp = Math.max(0.0, mean - cut);
        double lower = Math.atan((tmp * tmp - mean * mean) / (mean * gamma));
        double upper = Math.atan(((mean + cut) * (mean + cut) - mean * mean) / (mean * gamma));
        double rval = this.uniform.nextDoubleFromTo(lower, upper);
        double displ = gamma * Math.tan(rval);
        return Math.sqrt(Math.max(0.0, mean * mean + mean * displ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double mean, double gamma, double cut) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            return shared.nextDouble(mean, gamma, cut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomGenerator) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

