/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BooleanListBitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import junit.framework.TestCase;
import test.it.unimi.dsi.bits.BitVectorTestCase;

public class AbstractBitVectorTest
extends TestCase {
    public void testUnsupported() {
        MinimalAlternatingBitVector v = new MinimalAlternatingBitVector();
        v.getBoolean(0);
        v.length();
        boolean ok = false;
        try {
            v.removeBoolean(0);
        }
        catch (UnsupportedOperationException e) {
            ok = true;
        }
        AbstractBitVectorTest.assertTrue((boolean)ok);
        ok = false;
        try {
            v.set(0L, 0);
        }
        catch (UnsupportedOperationException e) {
            ok = true;
        }
        AbstractBitVectorTest.assertTrue((boolean)ok);
        ok = false;
        try {
            v.add(0L, 0);
        }
        catch (UnsupportedOperationException e) {
            ok = true;
        }
        AbstractBitVectorTest.assertTrue((boolean)ok);
        v.length(0x100000000L);
        ok = false;
        try {
            v.size();
        }
        catch (IllegalStateException e) {
            ok = true;
        }
        AbstractBitVectorTest.assertTrue((boolean)ok);
        ok = false;
        try {
            v.asLongBigList(1).size();
        }
        catch (IllegalStateException e) {
            ok = true;
        }
        AbstractBitVectorTest.assertTrue((boolean)ok);
    }

    public void testCopy() {
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector(), (Object)new MinimalAlternatingBitVector().copy());
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector().subVector(2L, 20L), (Object)new MinimalAlternatingBitVector().subVector(2L, 20L).copy());
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector().subVector(5L, 12L), (Object)new MinimalAlternatingBitVector().subVector(2L, 20L).subVector(3L, 10L));
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector().subVector(5L, 12L), (Object)new MinimalAlternatingBitVector().subVector(2L, 20L).subVector(3L, 10L).copy());
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector().subList(2, 20), (Object)new MinimalAlternatingBitVector().subList(2, 20).copy());
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector().subList(5, 12), (Object)new MinimalAlternatingBitVector().subList(2, 20).subList(3, 10));
        AbstractBitVectorTest.assertEquals((Object)new MinimalAlternatingBitVector().subList(5, 12), (Object)new MinimalAlternatingBitVector().subList(2, 20).subList(3, 10).copy());
    }

    public void testCount() {
        MinimalAlternatingBitVector v = new MinimalAlternatingBitVector();
        AbstractBitVectorTest.assertEquals((long)(v.length() / 2L), (long)v.count());
    }

    public void testRemove() {
        BitVectorTestCase.testRemove(new AbstractBitVector.SubBitVector(BooleanListBitVector.getInstance().length(1000L), 10L, 100L));
    }

    public void testAdd() {
        BitVectorTestCase.testAdd(new AbstractBitVector.SubBitVector(BooleanListBitVector.getInstance().length(1000L), 10L, 100L));
    }

    public void testCompareTo() {
        MinimalAlternatingBitVector v = new MinimalAlternatingBitVector();
        LongArrayBitVector w = LongArrayBitVector.copy(v);
        AbstractBitVectorTest.assertEquals((int)0, (int)w.compareTo(v));
        AbstractBitVectorTest.assertEquals((int)0, (int)v.compareTo(w));
        w.set(100);
        AbstractBitVectorTest.assertEquals((int)1, (int)w.compareTo(v));
        AbstractBitVectorTest.assertEquals((int)-1, (int)v.compareTo(w));
        w = LongArrayBitVector.ofLength(10L);
        AbstractBitVectorTest.assertEquals((int)-1, (int)w.compareTo(v));
        AbstractBitVectorTest.assertEquals((int)1, (int)v.compareTo(w));
        w = LongArrayBitVector.of(1);
        AbstractBitVectorTest.assertEquals((int)1, (int)w.compareTo(v));
        AbstractBitVectorTest.assertEquals((int)-1, (int)v.compareTo(w));
    }

    private static final class MinimalAlternatingBitVector
    extends AbstractBitVector {
        private long length = 129L;

        private MinimalAlternatingBitVector() {
        }

        public boolean getBoolean(long index) {
            return index % 2L != 0L;
        }

        public long length() {
            return this.length;
        }

        public MinimalAlternatingBitVector length(long newLength) {
            this.length = newLength;
            return this;
        }
    }
}

