/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.navigation;

import info.aduna.webapp.navigation.NavigationNode;

public abstract class NavigationNodeBase
implements NavigationNode {
    private String id;
    private boolean hidden;
    private boolean enabled;
    private NavigationNode parent;
    protected String path;
    protected String icon;
    protected String i18n;
    protected String viewSuffix;

    public NavigationNodeBase(String id) {
        this.setId(id);
        this.setEnabled(true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public NavigationNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(NavigationNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean isParent(NavigationNode node) {
        boolean result = false;
        if (node != null && node != this) {
            if (node.getParent() == this) {
                result = true;
            } else if (node.getParent() != null) {
                result = this.isParent(node.getParent());
            }
        }
        return result;
    }

    @Override
    public String getPathPrefix() {
        StringBuilder result = new StringBuilder();
        if (this.getParent() != null) {
            if (this.getParent().getPathPrefix() != null) {
                result.append(this.getParent().getPathPrefix());
            }
            if (this.getParent().getId().length() > 0) {
                result.append(this.getParent().getId());
                result.append(this.getPathSeparator());
            }
        }
        return result.toString();
    }

    @Override
    public String getPathSeparator() {
        String result = null;
        if (this.getParent() != null) {
            result = this.getParent().getPathSeparator();
        }
        return result;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            StringBuilder result = new StringBuilder();
            result.append(this.getPathPrefix());
            result.append(this.getId());
            this.setPath(result.toString());
        }
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getIconPrefix() {
        StringBuilder result = new StringBuilder();
        if (this.getParent() != null) {
            if (this.getParent().getIconPrefix() != null) {
                result.append(this.getParent().getIconPrefix());
            }
            if (this.getParent().getId().length() > 0) {
                result.append(this.getParent().getId());
                result.append(this.getIconSeparator());
            }
        }
        return result.toString();
    }

    @Override
    public String getIconSeparator() {
        String result = null;
        if (this.getParent() != null) {
            result = this.getParent().getIconSeparator();
        }
        return result;
    }

    @Override
    public String getIconSuffix() {
        String result = null;
        if (this.getParent() != null) {
            result = this.getParent().getIconSuffix();
        }
        return result;
    }

    @Override
    public String getIcon() {
        if (this.icon == null) {
            StringBuilder result = new StringBuilder();
            result.append(this.getIconPrefix());
            result.append(this.getId());
            result.append(this.getIconSuffix());
            this.setIcon(result.toString());
        }
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getI18nPrefix() {
        StringBuilder result = new StringBuilder();
        if (this.getParent() != null) {
            if (this.getParent().getI18nPrefix() != null) {
                result.append(this.getParent().getI18nPrefix());
            }
            if (this.getParent().getId().length() > 0) {
                result.append(this.getParent().getId());
                result.append(this.getI18nSeparator());
            }
        }
        return result.toString();
    }

    @Override
    public String getI18nSeparator() {
        String result = null;
        if (this.getParent() != null) {
            result = this.getParent().getI18nSeparator();
        }
        return result;
    }

    @Override
    public String getI18nSuffix() {
        String result = null;
        if (this.getParent() != null) {
            result = this.getParent().getI18nSuffix();
        }
        return result;
    }

    @Override
    public String getI18n() {
        if (this.i18n == null) {
            StringBuilder result = new StringBuilder();
            result.append(this.getI18nPrefix());
            result.append(this.getId());
            result.append(this.getI18nSuffix());
            this.setI18n(result.toString());
        }
        return this.i18n;
    }

    @Override
    public void setI18n(String i18n) {
        this.i18n = i18n;
    }

    @Override
    public String getViewSuffix() {
        if (this.viewSuffix == null && this.getParent() != null) {
            this.setViewSuffix(this.getParent().getViewSuffix());
        }
        return this.viewSuffix;
    }

    @Override
    public void setViewSuffix(String viewSuffix) {
        this.viewSuffix = viewSuffix;
    }

    @Override
    public int getDepth() {
        int result = 0;
        if (this.getParent() != null) {
            result = this.getParent().getDepth() + 1;
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result;
        boolean bl = result = this == other;
        if (!result && other instanceof NavigationNode && this.getClass().equals(other.getClass())) {
            NavigationNode otherNode = (NavigationNode)other;
            result = this.getId().equals(otherNode.getId());
            if (result && (this.getParent() != null || otherNode.getParent() != null)) {
                result = this.getParent() != null && otherNode.getParent() != null ? this.getParent().equals(otherNode.getParent()) : false;
            }
        }
        return result;
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        if (this.getParent() != null) {
            result += 31 * this.getParent().hashCode();
        }
        return result;
    }

    protected void copyCommonAttributes(NavigationNode node) {
        node.setEnabled(this.isEnabled());
        node.setHidden(this.isHidden());
        node.setI18n(this.getI18n());
        node.setIcon(this.getIcon());
        node.setPath(this.getPath());
        node.setViewSuffix(this.getViewSuffix());
    }
}

