/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.system.logging;

import info.aduna.app.AppConfiguration;
import info.aduna.logging.LogLevel;
import info.aduna.logging.LogReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class LoggingOverviewController
implements Controller {
    private AppConfiguration config;
    String viewName = "system/logging/overview";
    String appenderName = null;
    String[] loglevels = new String[]{"All", LogLevel.ERROR.toString(), LogLevel.WARN.toString(), LogLevel.INFO.toString(), LogLevel.DEBUG.toString()};

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int offset = this.getOffset(request);
        int count = this.getCount(request);
        HashMap<String, Object> model = new HashMap<String, Object>();
        LogReader logReader = this.getLogReader(offset, count, request);
        model.put("logreader", logReader);
        model.put("offset", new Integer(offset));
        model.put("count", new Integer(count));
        model.put("countsAvailable", Arrays.asList(50, 100, 200, 500));
        if (logReader.supportsLevelFilter()) {
            LogLevel level = logReader.getLevel();
            model.put("level", level == null ? "ALL" : level.toString());
            model.put("loglevels", Arrays.asList(this.loglevels));
        }
        if (logReader.supportsThreadFilter()) {
            String thread = logReader.getThread();
            model.put("thread", thread == null ? "ALL" : thread);
            ArrayList<String> l = new ArrayList<String>();
            l.add("All");
            l.addAll(logReader.getThreadNames());
            model.put("threadnames", l);
        }
        if (logReader.supportsDateRanges()) {
            Calendar cal = Calendar.getInstance();
            if (logReader.getStartDate() != null) {
                cal.setTime(logReader.getStartDate());
                model.put("startDate", Boolean.TRUE);
            } else {
                cal.setTime(logReader.getMinDate());
                model.put("startDate", Boolean.FALSE);
            }
            model.put("s_year", cal.get(1));
            model.put("s_month", cal.get(2));
            model.put("s_day", cal.get(5));
            model.put("s_hour", cal.get(11));
            model.put("s_min", cal.get(12));
            cal = Calendar.getInstance();
            if (logReader.getEndDate() != null) {
                cal.setTime(logReader.getEndDate());
                model.put("endDate", Boolean.TRUE);
            } else {
                cal.setTime(logReader.getMaxDate());
                model.put("endDate", Boolean.FALSE);
            }
            model.put("e_year", cal.get(1));
            model.put("e_month", cal.get(2));
            model.put("e_day", cal.get(5));
            model.put("e_hour", cal.get(11));
            model.put("e_min", cal.get(12));
        }
        return new ModelAndView(this.viewName, model);
    }

    public LogReader getLogReader(int offset, int count, HttpServletRequest request) {
        LogReader logReader = (LogReader)request.getSession().getAttribute("logreader" + (this.appenderName != null ? "+" + this.appenderName : ""));
        if (logReader == null) {
            logReader = this.appenderName == null ? this.config.getLogConfiguration().getDefaultLogReader() : this.config.getLogConfiguration().getLogReader(this.appenderName);
            request.getSession().setAttribute("logreader" + (this.appenderName != null ? "+" + this.appenderName : ""), (Object)logReader);
        }
        logReader.setOffset(offset);
        logReader.setLimit(count);
        if (logReader.supportsLevelFilter() && request.getParameter("level") != null) {
            if (request.getParameter("level").equalsIgnoreCase("ALL")) {
                logReader.setLevel(null);
            } else {
                logReader.setLevel(LogLevel.valueOf(request.getParameter("level")));
            }
        }
        if (logReader.supportsThreadFilter() && request.getParameter("thread") != null) {
            if (request.getParameter("thread").equalsIgnoreCase("ALL")) {
                logReader.setThread(null);
            } else {
                logReader.setThread(request.getParameter("thread"));
            }
        }
        if (logReader.supportsDateRanges() && request.getParameter("filterapplied") != null) {
            Calendar cal;
            if (request.getParameter("applystartdate") != null) {
                cal = Calendar.getInstance();
                cal.set(Integer.parseInt(request.getParameter("s_year")), Integer.parseInt(request.getParameter("s_month")), Integer.parseInt(request.getParameter("s_day")), Integer.parseInt(request.getParameter("s_hour")), Integer.parseInt(request.getParameter("s_min")), 0);
                logReader.setStartDate(cal.getTime());
            } else if (logReader.getStartDate() != null) {
                logReader.setStartDate(null);
            }
            if (request.getParameter("applyenddate") != null) {
                cal = Calendar.getInstance();
                cal.set(Integer.parseInt(request.getParameter("e_year")), Integer.parseInt(request.getParameter("e_month")), Integer.parseInt(request.getParameter("e_day")), Integer.parseInt(request.getParameter("e_hour")), Integer.parseInt(request.getParameter("e_min")), 59);
                logReader.setEndDate(cal.getTime());
            } else if (logReader.getEndDate() != null) {
                logReader.setEndDate(null);
            }
        }
        try {
            logReader.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize log reader.", e);
        }
        return logReader;
    }

    public AppConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(AppConfiguration config) {
        this.config = config;
    }

    private int getOffset(HttpServletRequest request) {
        int result = 0;
        String offsetString = request.getParameter("offset");
        if (offsetString != null && !offsetString.equals("")) {
            try {
                result = Integer.parseInt(offsetString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return result > 0 ? result : 0;
    }

    private int getCount(HttpServletRequest request) {
        int result = 50;
        String countString = request.getParameter("count");
        if (countString != null && !countString.equals("")) {
            try {
                result = Integer.parseInt(countString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return result;
    }

    public String getAppenderName() {
        return this.appenderName;
    }

    public void setAppenderName(String appenderName) {
        this.appenderName = appenderName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

