/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openrdf.console.Command;
import org.openrdf.console.ConsoleIO;
import org.openrdf.console.ConsoleState;
import org.openrdf.console.Disconnect;
import org.openrdf.http.client.SesameHTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.manager.LocalRepositoryManager;
import org.openrdf.repository.manager.RemoteRepositoryManager;
import org.openrdf.repository.manager.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connect
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connect.class);
    private final ConsoleState appInfo;
    private final ConsoleIO consoleIO;
    private final Disconnect disconnect;

    Connect(ConsoleIO consoleIO, ConsoleState info, Disconnect disconnect) {
        this.consoleIO = consoleIO;
        this.appInfo = info;
        this.disconnect = disconnect;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length < 2) {
            this.consoleIO.writeln("Usage:\nconnect default                         Opens the default repository set for this console\nconnect <dataDirectory>                 Opens the repository set in the specified data dir\nconnect <serverURL> [user [password]]   Connects to a Sesame server with optional credentials\n");
            return;
        }
        String target = tokens[1];
        if ("default".equalsIgnoreCase(target)) {
            this.connectDefault();
        } else {
            try {
                new URL(target);
                String username = tokens.length > 2 ? tokens[2] : null;
                String password = tokens.length > 3 ? tokens[3] : null;
                this.connectRemote(target, username, password);
            }
            catch (MalformedURLException e) {
                this.connectLocal(target);
            }
        }
    }

    protected boolean connectDefault() {
        return this.installNewManager(new LocalRepositoryManager(this.appInfo.getDataDirectory()), "default data directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectRemote(String url, String user, String passwd) {
        String pass = passwd == null ? "" : passwd;
        boolean result = false;
        try {
            SesameHTTPClient httpClient = new SesameHTTPClient();
            try {
                httpClient.setServerURL(url);
                if (user != null) {
                    httpClient.setUsernameAndPassword(user, pass);
                }
                httpClient.getServerProtocol();
            }
            finally {
                httpClient.shutDown();
            }
            RemoteRepositoryManager manager = new RemoteRepositoryManager(url);
            manager.setUsernameAndPassword(user, pass);
            result = this.installNewManager(manager, url);
        }
        catch (UnauthorizedException e) {
            if (user != null && pass.length() > 0) {
                this.consoleIO.writeError("Authentication for user '" + user + "' failed");
                LOGGER.warn("Authentication for user '" + user + "' failed", (Throwable)e);
            } else {
                try {
                    this.consoleIO.writeln("Authentication required");
                    String username = this.consoleIO.readln("Username:");
                    String password = this.consoleIO.readPassword("Password:");
                    this.connectRemote(url, username, password);
                }
                catch (IOException ioe) {
                    this.consoleIO.writeError("Failed to read user credentials");
                    LOGGER.warn("Failed to read user credentials", (Throwable)ioe);
                }
            }
        }
        catch (IOException e) {
            this.consoleIO.writeError("Failed to access the server: " + e.getMessage());
            LOGGER.warn("Failed to access the server", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Failed to access the server: " + e.getMessage());
            LOGGER.warn("Failed to access the server", (Throwable)e);
        }
        return result;
    }

    protected boolean connectLocal(String path) {
        File dir = new File(path);
        boolean result = false;
        if (dir.exists() && dir.isDirectory()) {
            result = this.installNewManager(new LocalRepositoryManager(dir), dir.toString());
        } else {
            this.consoleIO.writeError("Specified path is not an (existing) directory: " + path);
        }
        return result;
    }

    private boolean installNewManager(RepositoryManager newManager, String newManagerID) {
        boolean installed = false;
        String managerID = this.appInfo.getManagerID();
        if (newManagerID.equals(managerID)) {
            this.consoleIO.writeln("Already connected to " + managerID);
            installed = true;
        } else {
            try {
                newManager.initialize();
                this.disconnect.execute(false);
                this.appInfo.setManager(newManager);
                this.appInfo.setManagerID(newManagerID);
                this.consoleIO.writeln("Connected to " + newManagerID);
                installed = true;
            }
            catch (RepositoryException e) {
                this.consoleIO.writeError(e.getMessage());
                LOGGER.error("Failed to install new manager", (Throwable)e);
            }
        }
        return installed;
    }

    protected boolean connectRemote(String url) {
        return this.connectRemote(url, null, null);
    }
}

