/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import org.openrdf.console.ConsoleState;
import org.openrdf.rio.RDFParseException;

class ConsoleIO {
    private static final String PLEASE_OPEN_FIRST = "please open a repository first";
    private final BufferedReader input;
    private final PrintStream out;
    private final PrintStream err;
    private final ConsoleState appInfo;
    private boolean echo = false;
    private boolean quiet = false;
    private boolean force = false;
    private boolean cautious = false;
    private boolean errorWritten;

    ConsoleIO(BufferedReader input, PrintStream out, PrintStream err, ConsoleState info) {
        this.input = input;
        this.out = out;
        this.err = err;
        this.appInfo = info;
    }

    protected String readMultiLineInput() throws IOException {
        String repositoryID = this.appInfo.getRepositoryID();
        if (!this.quiet) {
            if (repositoryID != null) {
                this.write(repositoryID);
            }
            this.write("> ");
        }
        String line = this.input.readLine();
        String result = null;
        if (line != null) {
            StringBuilder buf = new StringBuilder(256);
            buf.append(line);
            while (line != null && !line.endsWith(".")) {
                line = this.input.readLine();
                buf.append('\n');
                buf.append(line);
            }
            buf.setLength(buf.length() - 1);
            result = buf.toString().trim();
        }
        if (this.echo) {
            this.writeln(result);
        }
        return result;
    }

    protected String readln(String ... message) throws IOException {
        String prompt;
        if (!this.quiet && message.length > 0 && (prompt = message[0]) != null) {
            this.write(prompt + " ");
        }
        String result = this.input.readLine();
        if (this.echo) {
            this.writeln(result);
        }
        return result;
    }

    protected String readPassword(String message) throws IOException {
        String result = this.readln(message);
        if (this.echo && !result.isEmpty()) {
            this.writeln("************");
        }
        return result;
    }

    protected void write(String string) {
        this.out.print(string);
    }

    protected void writeln() {
        this.out.println();
    }

    protected void writeln(String string) {
        this.out.println(string);
    }

    protected void writeError(String errMsg) {
        this.err.println(errMsg);
        this.errorWritten = true;
    }

    protected void writeUnopenedError() {
        this.writeError(PLEASE_OPEN_FIRST);
    }

    protected void writeParseError(String prefix, int lineNo, int colNo, String msg) {
        String locationString = RDFParseException.getLocationString(lineNo, colNo);
        int locSize = locationString.length();
        StringBuilder builder = new StringBuilder(locSize + prefix.length() + msg.length() + 3);
        builder.append(prefix).append(": ").append(msg);
        if (locSize > 0) {
            builder.append(" ").append(locationString);
        }
        this.writeError(builder.toString());
    }

    protected boolean askProceed(String msg, boolean defaultValue) throws IOException {
        boolean result;
        block3: {
            String reply;
            String defaultString;
            String string = defaultString = defaultValue ? "yes" : "no";
            boolean bl = this.force ? true : (result = this.cautious ? false : defaultValue);
            if (this.force || this.cautious) break block3;
            do {
                this.writeln(msg);
                this.write("Proceed? (yes|no) [" + defaultString + "]: ");
                reply = this.readln(new String[0]);
                if ("no".equalsIgnoreCase(reply) || "no.".equalsIgnoreCase(reply)) {
                    result = false;
                } else {
                    if (!"yes".equalsIgnoreCase(reply) && !"yes.".equalsIgnoreCase(reply)) continue;
                    result = true;
                }
                break;
            } while (!reply.trim().isEmpty());
        }
        return result;
    }

    protected void setEcho(boolean echo) {
        this.echo = echo;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setForce() {
        this.force = true;
    }

    public void setCautious() {
        this.cautious = true;
    }

    public boolean wasErrorWritten() {
        return this.errorWritten;
    }
}

