/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrEnds
implements Function {
    @Override
    public String getURI() {
        return FN.ENDS_WITH.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("STRENDS requires 2 arguments, got " + args.length);
        }
        Value leftVal = args[0];
        Value rightVal = args[1];
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            Literal leftLit = (Literal)leftVal;
            Literal rightLit = (Literal)rightVal;
            if (QueryEvaluationUtil.compatibleArguments(leftLit, rightLit)) {
                String leftLexVal = leftLit.getLabel();
                String rightLexVal = rightLit.getLabel();
                return BooleanLiteralImpl.valueOf(leftLexVal.endsWith(rightLexVal));
            }
            throw new ValueExprEvaluationException("incompatible operands for STRENDS function");
        }
        throw new ValueExprEvaluationException("STRENDS function expects literal operands");
    }
}

