/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.BasicQueryWriterSettings;
import org.openrdf.query.resultio.QueryResultWriter;
import org.openrdf.query.resultio.QueryResultWriterBase;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicWriterSettings;

abstract class SPARQLJSONWriterBase
extends QueryResultWriterBase
implements QueryResultWriter {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    protected boolean firstTupleWritten = false;
    protected boolean documentOpen = false;
    protected boolean headerOpen = false;
    protected boolean headerComplete = false;
    protected boolean tupleVariablesFound = false;
    protected boolean linksFound = false;
    private final JsonGenerator jg;

    public SPARQLJSONWriterBase(OutputStream out) {
        try {
            this.jg = JSON_FACTORY.createJsonGenerator((Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void endHeader() throws QueryResultHandlerException {
        if (!this.headerComplete) {
            try {
                this.jg.writeEndObject();
                if (this.tupleVariablesFound) {
                    this.jg.writeObjectFieldStart("results");
                    this.jg.writeArrayFieldStart("bindings");
                }
                this.headerComplete = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException(e);
            }
        }
    }

    @Override
    public void startQueryResult(List<String> columnHeaders) throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.tupleVariablesFound = true;
            this.jg.writeArrayFieldStart("vars");
            for (String nextColumn : columnHeaders) {
                this.jg.writeString(nextColumn);
            }
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Must call startQueryResult before handleSolution");
            }
            this.firstTupleWritten = true;
            this.jg.writeStartObject();
            for (Binding binding : bindingSet) {
                this.jg.writeFieldName(binding.getName());
                this.writeValue(binding.getValue());
            }
            this.jg.writeEndObject();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
            }
            this.jg.writeEndArray();
            this.jg.writeEndObject();
            this.endDocument();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void startDocument() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.documentOpen = true;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            this.firstTupleWritten = false;
            this.linksFound = false;
            if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
                this.jg.useDefaultPrettyPrinter();
            }
            try {
                if (this.getWriterConfig().isSet(BasicQueryWriterSettings.JSONP_CALLBACK)) {
                    String callbackName = this.getWriterConfig().get(BasicQueryWriterSettings.JSONP_CALLBACK);
                    this.jg.writeRaw(callbackName);
                    this.jg.writeRaw("(");
                }
                this.jg.writeStartObject();
            }
            catch (IOException e) {
                throw new QueryResultHandlerException(e);
            }
        }
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    @Override
    public void startHeader() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            try {
                this.jg.writeObjectFieldStart("head");
                this.headerOpen = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException(e);
            }
        }
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.jg.writeArrayFieldStart("link");
            for (String nextLink : linkUrls) {
                this.jg.writeString(nextLink);
            }
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException(e);
        }
    }

    protected void writeValue(Value value) throws IOException, QueryResultHandlerException {
        this.jg.writeStartObject();
        if (value instanceof URI) {
            this.jg.writeStringField("type", "uri");
            this.jg.writeStringField("value", ((URI)value).toString());
        } else if (value instanceof BNode) {
            this.jg.writeStringField("type", "bnode");
            this.jg.writeStringField("value", ((BNode)value).getID());
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (lit.getLanguage() != null) {
                this.jg.writeObjectField("xml:lang", (Object)lit.getLanguage());
            }
            if (lit.getDatatype() != null) {
                this.jg.writeObjectField("datatype", (Object)lit.getDatatype().stringValue());
            }
            this.jg.writeObjectField("type", (Object)"literal");
            this.jg.writeObjectField("value", (Object)lit.getLabel());
        } else {
            throw new TupleQueryResultHandlerException("Unknown Value object type: " + value.getClass());
        }
        this.jg.writeEndObject();
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            this.endHeader();
        }
        if (this.tupleVariablesFound) {
            throw new QueryResultHandlerException("Cannot call handleBoolean after startQueryResults");
        }
        try {
            if (value) {
                this.jg.writeBooleanField("boolean", Boolean.TRUE.booleanValue());
            } else {
                this.jg.writeBooleanField("boolean", Boolean.FALSE.booleanValue());
            }
            this.endDocument();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException(e);
        }
    }

    @Override
    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicQueryWriterSettings.JSONP_CALLBACK);
        result.add(BasicWriterSettings.PRETTY_PRINT);
        result.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        result.add(BasicWriterSettings.RDF_LANGSTRING_TO_LANG_LITERAL);
        return result;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }

    protected void endDocument() throws IOException {
        this.jg.writeEndObject();
        if (this.getWriterConfig().isSet(BasicQueryWriterSettings.JSONP_CALLBACK)) {
            this.jg.writeRaw(");");
        }
        this.jg.flush();
        this.documentOpen = false;
        this.headerOpen = false;
        this.headerComplete = false;
        this.tupleVariablesFound = false;
        this.firstTupleWritten = false;
        this.linksFound = false;
    }

    static {
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }
}

