/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.queryrender.builder.Group;

public class BasicGroup
implements Group {
    private boolean mIsOptional = false;
    private Collection<TupleExpr> mExpressions = new LinkedHashSet<TupleExpr>();
    private List<Group> mChildren = new ArrayList<Group>();
    private Collection<ValueExpr> mFilters = new LinkedHashSet<ValueExpr>();

    public BasicGroup(boolean theOptional) {
        this.mIsOptional = theOptional;
    }

    @Override
    public int size() {
        int aSize = this.mExpressions.size();
        for (Group aChild : this.mChildren) {
            aSize += aChild.size();
        }
        return aSize;
    }

    @Override
    public void addChild(Group theGroup) {
        this.mChildren.add(theGroup);
    }

    public void removeChild(Group theGroup) {
        this.mChildren.remove(theGroup);
    }

    public void addFilter(ValueExpr theExpr) {
        this.mFilters.add(theExpr);
    }

    public boolean isEmpty() {
        return this.mFilters.isEmpty() && this.mExpressions.isEmpty() && this.mChildren.isEmpty();
    }

    @Override
    public boolean isOptional() {
        return this.mIsOptional;
    }

    @Override
    public TupleExpr expr() {
        return this.expr(true);
    }

    private TupleExpr expr(boolean filterExpr) {
        TupleExpr aExpr = null;
        if (this.mExpressions.isEmpty() && this.mFilters.isEmpty()) {
            if (this.mChildren.isEmpty()) {
                return null;
            }
        } else if (this.mExpressions.isEmpty() && !this.mFilters.isEmpty()) {
            if (this.mChildren.isEmpty()) {
                aExpr = new Filter(new EmptySet(), this.filtersAsAnd());
            }
        } else {
            aExpr = this.asJoin(this.mExpressions);
            if (filterExpr) {
                aExpr = this.filteredTuple(aExpr);
            }
        }
        if (!this.mChildren.isEmpty()) {
            for (Group aGroup : this.mChildren) {
                if (aExpr == null) {
                    if (this.mExpressions.isEmpty() && !this.mFilters.isEmpty()) {
                        aExpr = new Filter(aGroup.expr(), this.filtersAsAnd());
                        continue;
                    }
                    aExpr = aGroup.expr();
                    continue;
                }
                BinaryTupleOperator aJoin = aGroup.isOptional() ? new LeftJoin() : new Join();
                aJoin.setLeftArg(aExpr);
                if (aGroup.isOptional() && aJoin instanceof LeftJoin && aGroup instanceof BasicGroup && !((BasicGroup)aGroup).mFilters.isEmpty()) {
                    BasicGroup aBasicGroup = (BasicGroup)aGroup;
                    aJoin.setRightArg(aBasicGroup.expr(false));
                    ((LeftJoin)aJoin).setCondition(aBasicGroup.filtersAsAnd());
                } else {
                    aJoin.setRightArg(aGroup.expr());
                }
                aExpr = aJoin;
            }
        }
        return aExpr;
    }

    private TupleExpr filteredTuple(TupleExpr theExpr) {
        TupleExpr aExpr = theExpr;
        for (ValueExpr aValEx : this.mFilters) {
            Filter aFilter = new Filter();
            aFilter.setCondition(aValEx);
            aFilter.setArg(aExpr);
            aExpr = aFilter;
        }
        return aExpr;
    }

    private ValueExpr filtersAsAnd() {
        ValueExpr aExpr = null;
        for (ValueExpr aValEx : this.mFilters) {
            if (aExpr == null) {
                aExpr = aValEx;
                continue;
            }
            And aAnd = new And();
            aAnd.setLeftArg(aValEx);
            aAnd.setRightArg(aExpr);
            aExpr = aAnd;
        }
        return aExpr;
    }

    public void add(TupleExpr theExpr) {
        this.mExpressions.add(theExpr);
    }

    public void addAll(Collection<? extends TupleExpr> theTupleExprs) {
        this.mExpressions.addAll(theTupleExprs);
    }

    private TupleExpr asJoin(Collection<TupleExpr> theList) {
        Join aJoin = new Join();
        if (theList.isEmpty()) {
            throw new RuntimeException("Can't have an empty or missing join.");
        }
        if (theList.size() == 1) {
            return theList.iterator().next();
        }
        for (TupleExpr aExpr : theList) {
            if (aJoin.getLeftArg() == null) {
                aJoin.setLeftArg(aExpr);
                continue;
            }
            if (aJoin.getRightArg() == null) {
                aJoin.setRightArg(aExpr);
                continue;
            }
            Join aNewJoin = new Join();
            aNewJoin.setLeftArg(aJoin);
            aNewJoin.setRightArg(aExpr);
            aJoin = aNewJoin;
        }
        return aJoin;
    }

    public Collection<StatementPattern> getPatterns() {
        HashSet<StatementPattern> aPatternSet = new HashSet<StatementPattern>();
        for (TupleExpr aExpr : this.mExpressions) {
            if (!(aExpr instanceof StatementPattern)) continue;
            aPatternSet.add((StatementPattern)aExpr);
        }
        return aPatternSet;
    }
}

